/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.read;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.infinispan.commands.CancellableCommand;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.distexec.mapreduce.MapReduceManager;
import org.infinispan.distexec.mapreduce.Reducer;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ReduceCommand<KOut, VOut>
extends BaseRpcCommand
implements CancellableCommand {
    public static final int COMMAND_ID = 31;
    private static final Log log = LogFactory.getLog(ReduceCommand.class);
    private Set<KOut> keys = new HashSet<KOut>();
    private Reducer<KOut, VOut> reducer;
    private String taskId;
    private boolean emitCompositeIntermediateKeys;
    private MapReduceManager mrManager;
    private UUID uuid;

    private ReduceCommand() {
        super(null);
    }

    public ReduceCommand(String cacheName) {
        super(cacheName);
    }

    public ReduceCommand(String taskId, Reducer<KOut, VOut> reducer, String cacheName, Collection<KOut> inputKeys) {
        super(cacheName);
        this.taskId = taskId;
        if (inputKeys != null && !inputKeys.isEmpty()) {
            this.keys.addAll(inputKeys);
        }
        this.reducer = reducer;
        this.uuid = UUID.randomUUID();
    }

    public void init(MapReduceManager mrManager) {
        this.mrManager = mrManager;
    }

    @Override
    public Object perform(InvocationContext context) throws Throwable {
        return this.mrManager.reduce(this);
    }

    public boolean isEmitCompositeIntermediateKeys() {
        return this.emitCompositeIntermediateKeys;
    }

    public void setEmitCompositeIntermediateKeys(boolean emitCompositeIntermediateKeys) {
        this.emitCompositeIntermediateKeys = emitCompositeIntermediateKeys;
    }

    public Set<KOut> getKeys() {
        return this.keys;
    }

    public Reducer<KOut, VOut> getReducer() {
        return this.reducer;
    }

    public String getTaskId() {
        return this.taskId;
    }

    @Override
    public byte getCommandId() {
        return 31;
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.taskId, this.keys, this.reducer, this.emitCompositeIntermediateKeys, this.uuid};
    }

    @Override
    public void setParameters(int commandId, Object[] args) {
        if (commandId != 31) {
            throw new IllegalStateException("Invalid method id");
        }
        int i = 0;
        this.taskId = (String)args[i++];
        this.keys = (Set)args[i++];
        this.reducer = (Reducer)args[i++];
        this.emitCompositeIntermediateKeys = (Boolean)args[i++];
        this.uuid = (UUID)args[i++];
    }

    @Override
    public boolean isReturnValueExpected() {
        return true;
    }

    @Override
    public boolean canBlock() {
        return true;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReduceCommand)) {
            return false;
        }
        ReduceCommand other = (ReduceCommand)obj;
        return !(this.taskId == null ? other.taskId != null : !this.taskId.equals(other.taskId));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.taskId == null ? 0 : this.taskId.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ReduceCommand [keys=" + this.keys + ", taskId=" + this.taskId + "]";
    }
}

