/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.executors;

import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.commons.executors.ExecutorFactory;
import org.infinispan.commons.util.InfinispanCollections;

public final class LazyInitializingExecutorService
implements ExecutorService {
    private volatile ExecutorService delegate;
    private final ExecutorFactory factory;
    private final Properties executorProperties;

    public LazyInitializingExecutorService(ExecutorFactory factory, Properties executorProperties) {
        this.factory = factory;
        this.executorProperties = executorProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initIfNeeded() {
        if (this.delegate == null) {
            LazyInitializingExecutorService lazyInitializingExecutorService = this;
            synchronized (lazyInitializingExecutorService) {
                if (this.delegate == null) {
                    this.delegate = this.factory.getExecutor(this.executorProperties);
                }
            }
        }
    }

    @Override
    public void shutdown() {
        if (this.delegate != null) {
            this.delegate.shutdown();
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        if (this.delegate == null) {
            return InfinispanCollections.emptyList();
        }
        return this.delegate.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.delegate == null || this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate == null || this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        if (this.delegate == null) {
            return true;
        }
        return this.delegate.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        this.initIfNeeded();
        return this.delegate.submit(task);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        this.initIfNeeded();
        return this.delegate.submit(task, result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        this.initIfNeeded();
        return this.delegate.submit(task);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        this.initIfNeeded();
        return this.delegate.invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        this.initIfNeeded();
        return this.delegate.invokeAll(tasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        this.initIfNeeded();
        return this.delegate.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.initIfNeeded();
        return this.delegate.invokeAny(tasks, timeout, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.initIfNeeded();
        this.delegate.execute(command);
    }
}

