/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.support;

import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.persistence.spi.CacheWriter;
import org.infinispan.persistence.spi.InitializationContext;

public abstract class DelegatingCacheWriter
implements CacheWriter {
    protected final CacheWriter actual;
    protected InitializationContext ctx;

    public DelegatingCacheWriter(CacheWriter actual) {
        this.actual = actual;
    }

    @Override
    public void init(InitializationContext ctx) {
        this.ctx = ctx;
        if (this.actual instanceof DelegatingCacheWriter) {
            this.actual.init(ctx);
        }
    }

    @Override
    public void start() {
        if (this.actual instanceof DelegatingCacheWriter) {
            this.actual.start();
        }
    }

    @Override
    public void stop() {
        if (this.actual instanceof DelegatingCacheWriter) {
            this.actual.stop();
        }
    }

    public void write(MarshalledEntry entry) {
        this.actual.write(entry);
    }

    public boolean delete(Object key) {
        return this.actual.delete(key);
    }

    public CacheWriter undelegate() {
        CacheWriter cl = this;
        while ((cl = cl.actual) instanceof DelegatingCacheWriter) {
        }
        return cl;
    }
}

