/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.pbcast;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.protocols.PingData;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.protocols.pbcast.GmsImpl;
import org.jgroups.protocols.pbcast.JoinRsp;
import org.jgroups.util.Digest;
import org.jgroups.util.Promise;
import org.jgroups.util.Util;

public class ClientGmsImpl
extends GmsImpl {
    private final Promise<JoinRsp> join_promise = new Promise();

    public ClientGmsImpl(GMS g) {
        super(g);
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.join_promise.reset();
    }

    @Override
    public void join(Address address, boolean useFlushIfPresent) {
        this.joinInternal(address, false, useFlushIfPresent);
    }

    @Override
    public void joinWithStateTransfer(Address local_addr, boolean useFlushIfPresent) {
        this.joinInternal(local_addr, true, useFlushIfPresent);
    }

    protected void joinInternal(Address mbr, boolean joinWithStateTransfer, boolean useFlushIfPresent) {
        JoinRsp rsp = null;
        Address coord = null;
        long join_attempts = 0L;
        this.leaving = false;
        this.join_promise.reset();
        while (!this.leaving) {
            if (rsp == null && !this.join_promise.hasResult()) {
                List<PingData> responses = this.findInitialMembers(this.join_promise);
                if (responses == null) {
                    throw new NullPointerException("responses returned by findInitialMembers for " + this.join_promise + " is null");
                }
                if (this.join_promise.hasResult() && (rsp = this.join_promise.getResult(this.gms.join_timeout)) != null) continue;
                if (responses.isEmpty()) {
                    this.log.trace("%s: no initial members discovered: creating cluster as first member", this.gms.local_addr);
                    this.becomeSingletonMember(mbr);
                    return;
                }
                this.log.trace("%s: initial_mbrs are %s", this.gms.local_addr, ClientGmsImpl.print(responses));
                coord = this.determineCoord(responses);
                if (coord == null) {
                    if (!this.gms.handle_concurrent_startup) {
                        this.log.trace("handle_concurrent_startup is false; ignoring responses of initial clients");
                        this.becomeSingletonMember(mbr);
                        return;
                    }
                    this.log.trace("%s: could not determine coordinator from responses %s", this.gms.local_addr, responses);
                    TreeSet<Address> clients = new TreeSet<Address>();
                    clients.add(mbr);
                    for (PingData response : responses) {
                        clients.add(response.getAddress());
                    }
                    this.log.trace("%s: clients to choose new coord from are: %s", this.gms.local_addr, clients);
                    Address new_coord = (Address)clients.first();
                    if (new_coord.equals(mbr)) {
                        this.log.trace("%s: I (%s) am the first of the clients, will become coordinator", this.gms.local_addr, mbr);
                        this.becomeSingletonMember(mbr);
                        return;
                    }
                    this.log.trace("%s: I (%s) am not the first of the clients, waiting for another client to become coordinator", this.gms.local_addr, mbr);
                    Util.sleep(500L);
                    continue;
                }
                this.log.debug("%s: sending JOIN(%s) to %s", this.gms.local_addr, mbr, coord);
                this.sendJoinMessage(coord, mbr, joinWithStateTransfer, useFlushIfPresent);
            }
            if (rsp == null) {
                rsp = this.join_promise.getResult(this.gms.join_timeout);
            }
            if (rsp == null) {
                this.log.warn("%s: JOIN(%s) sent to %s timed out (after %d ms), on try %d", this.gms.local_addr, mbr, coord, this.gms.join_timeout, ++join_attempts);
                if (this.gms.max_join_attempts == 0L || join_attempts < this.gms.max_join_attempts) continue;
                this.log.warn("%s: too many JOIN attempts (%d): becoming singleton", this.gms.local_addr, join_attempts);
                this.becomeSingletonMember(mbr);
                return;
            }
            if (!this.isJoinResponseValid(rsp)) {
                rsp = null;
                continue;
            }
            this.log.trace("%s: JOIN-RSP=%s [size=%d]\n\n", this.gms.local_addr, rsp.getView(), rsp.getView().size());
            if (!this.installView(rsp.getView(), rsp.getDigest())) {
                this.log.error("%s: view installation failed, retrying to join cluster", this.gms.local_addr);
                rsp = null;
                continue;
            }
            Message view_ack = new Message(coord).setFlag(Message.Flag.OOB, Message.Flag.INTERNAL).putHeader(this.gms.getId(), new GMS.GmsHeader(10));
            this.gms.getDownProtocol().down(new Event(1, view_ack));
            return;
        }
    }

    @Override
    public void leave(Address mbr) {
        this.leaving = true;
        this.wrongMethod("leave");
    }

    @Override
    public void handleJoinResponse(JoinRsp join_rsp) {
        this.join_promise.setResult(join_rsp);
    }

    protected boolean isJoinResponseValid(JoinRsp rsp) {
        if (rsp.getFailReason() != null) {
            throw new SecurityException(rsp.getFailReason());
        }
        Digest tmp_digest = rsp.getDigest();
        if (tmp_digest == null || tmp_digest.capacity() == 0) {
            this.log.warn("%s: digest is empty: digest=%s", this.gms.local_addr, rsp.getDigest());
            return false;
        }
        if (!tmp_digest.contains(this.gms.local_addr)) {
            this.log.error("%s: digest in JOIN_RSP does not contain myself; join response: %s", this.gms.local_addr, rsp);
            return false;
        }
        if (rsp.getView() == null) {
            this.log.error("%s: JoinRsp has a null view, skipping it", this.gms.local_addr);
            return false;
        }
        return true;
    }

    private List<PingData> findInitialMembers(Promise<JoinRsp> promise) {
        List responses = (List)this.gms.getDownProtocol().down(new Event(12, promise));
        if (responses != null) {
            Iterator iter = responses.iterator();
            while (iter.hasNext()) {
                Address address = ((PingData)iter.next()).getAddress();
                if (address == null || !address.equals(this.gms.local_addr)) continue;
                iter.remove();
            }
        }
        return responses;
    }

    private boolean installView(View new_view, Digest digest) {
        if (!new_view.containsMember(this.gms.local_addr)) {
            this.log.error("%s: I'm not member of %s, will not install view", this.gms.local_addr, new_view);
            return false;
        }
        this.gms.installView(new_view, digest);
        if (this.gms.impl == null || this.gms.impl instanceof ClientGmsImpl) {
            this.gms.becomeParticipant();
        }
        this.gms.getUpProtocol().up(new Event(16));
        this.gms.getDownProtocol().down(new Event(16));
        return true;
    }

    protected static String print(List<PingData> rsps) {
        StringBuilder sb = new StringBuilder();
        for (PingData rsp : rsps) {
            sb.append(rsp.getAddress() + " ");
        }
        return sb.toString();
    }

    void sendJoinMessage(Address coord, Address mbr, boolean joinWithTransfer, boolean useFlushIfPresent) {
        Message msg = new Message(coord).setFlag(Message.Flag.OOB, Message.Flag.INTERNAL);
        GMS.GmsHeader hdr = joinWithTransfer ? new GMS.GmsHeader(11, mbr, useFlushIfPresent) : new GMS.GmsHeader(1, mbr, useFlushIfPresent);
        msg.putHeader(this.gms.getId(), hdr);
        this.gms.getDownProtocol().down(new Event(1, msg));
    }

    private Address determineCoord(List<PingData> mbrs) {
        int count;
        Address winner = null;
        if (mbrs == null || mbrs.size() < 1) {
            return null;
        }
        HashMap<Address, Integer> votes = new HashMap<Address, Integer>(5);
        for (PingData pingData : mbrs) {
            if (!pingData.hasCoord()) continue;
            if (!votes.containsKey(pingData.getCoordAddress())) {
                votes.put(pingData.getCoordAddress(), 1);
                continue;
            }
            count = (Integer)votes.get(pingData.getCoordAddress());
            votes.put(pingData.getCoordAddress(), count + 1);
        }
        for (PingData pingData : mbrs) {
            if (!votes.containsKey(pingData.getAddress()) || pingData.isCoord()) continue;
            votes.remove(pingData.getAddress());
        }
        if (votes.size() > 1) {
            this.log.warn("there was more than 1 candidate for coordinator %s: ", votes);
        }
        int most_votes = 0;
        for (Map.Entry entry : votes.entrySet()) {
            Address tmp = (Address)entry.getKey();
            count = (Integer)entry.getValue();
            if (count <= most_votes) continue;
            winner = tmp;
            most_votes = count;
        }
        votes.clear();
        return winner;
    }

    void becomeSingletonMember(Address mbr) {
        View new_view = View.create(mbr, 0L, mbr);
        Digest initial_digest = new Digest(mbr, 0L, 0L);
        this.gms.installView(new_view, initial_digest);
        this.gms.becomeCoordinator();
        this.gms.getUpProtocol().up(new Event(16));
        this.gms.getDownProtocol().down(new Event(16));
        this.log.debug("created cluster (first member). My view is %s, impl is %s", this.gms.getViewId(), this.gms.getImpl().getClass().getName());
    }
}

