/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc.delegate;

import java.sql.Connection;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Workspace;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.modeshape.jcr.api.Repositories;
import org.modeshape.jdbc.JdbcLocalI18n;
import org.modeshape.jdbc.LocalJcrDriver;
import org.modeshape.jdbc.delegate.AbstractRepositoryDelegate;
import org.modeshape.jdbc.delegate.ConnectionInfo;
import org.modeshape.jdbc.delegate.LocalSession;
import org.modeshape.jdbc.delegate.RepositoryDelegateFactory;

public class LocalRepositoryDelegate
extends AbstractRepositoryDelegate {
    public static final RepositoryDelegateFactory FACTORY = new RepositoryDelegateFactory(){};
    private static final String JNDI_EXAMPLE_URL = "jdbc:jcr:jndi:{jndiName}";
    protected static final Set<LocalSession> TRANSACTION_IDS = Collections.synchronizedSet(new HashSet());
    private LocalJcrDriver.JcrContextFactory jcrContext = null;

    public LocalRepositoryDelegate(String url, Properties info, LocalJcrDriver.JcrContextFactory contextFactory) {
        super(url, info);
        this.jcrContext = contextFactory == null ? new LocalJcrDriver.JcrContextFactory(){

            @Override
            public Context createContext(Properties properties) throws NamingException {
                InitialContext initContext = properties == null || properties.isEmpty() ? new InitialContext() : new InitialContext(properties);
                return initContext;
            }
        } : contextFactory;
    }

    @Override
    protected ConnectionInfo createConnectionInfo(String url, Properties info) {
        return new JNDIConnectionInfo(url, info);
    }

    protected LocalJcrDriver.JcrContextFactory getJcrContext() {
        return this.jcrContext;
    }

    private LocalSession getLocalSession() throws LoginException, NoSuchWorkspaceException, RepositoryException {
        return LocalSession.getLocalSessionInstance().getLocalSession(this.getRepository(), this.getConnectionInfo());
    }

    private LocalSession getCurrentLocalSession() {
        return LocalSession.getLocalSessionInstance().getLocalSession();
    }

    @Override
    public String getDescriptor(String descriptorKey) {
        return this.getRepository().getDescriptor(descriptorKey);
    }

    @Override
    public NodeType nodeType(String name) throws RepositoryException {
        LocalSession localSession = this.getLocalSession();
        return localSession.getSession().getWorkspace().getNodeTypeManager().getNodeType(name);
    }

    @Override
    public List<NodeType> nodeTypes() throws RepositoryException {
        LocalSession localSession = this.getLocalSession();
        ArrayList<NodeType> types = new ArrayList<NodeType>();
        NodeTypeIterator its = localSession.getSession().getWorkspace().getNodeTypeManager().getAllNodeTypes();
        while (its.hasNext()) {
            types.add((NodeType)its.next());
        }
        return types;
    }

    @Override
    public QueryResult execute(String query, String language) throws RepositoryException {
        LOGGER.trace("Executing query: {0}" + query, new Object[0]);
        Query jcrQuery = this.getLocalSession().getSession().getWorkspace().getQueryManager().createQuery(query, language);
        return jcrQuery.execute();
    }

    @Override
    protected void createRepository() throws SQLException {
        LOGGER.debug("Creating repository for LocalRepositoryDelegte", new Object[0]);
        Repository repository = null;
        Set<String> repositoryNames = null;
        ConnectionInfo connInfo = this.getConnectionInfo();
        assert (connInfo != null);
        String jndiName = connInfo.getRepositoryPath();
        if (jndiName == null) {
            String msg = JdbcLocalI18n.urlMustContainJndiNameOfRepositoryOrRepositoriesObject.text(new Object[0]);
            throw new SQLException(msg);
        }
        Context context = null;
        try {
            context = this.jcrContext.createContext(connInfo.getProperties());
        }
        catch (NamingException e) {
            throw new SQLException(JdbcLocalI18n.unableToGetJndiContext.text(new Object[]{e.getLocalizedMessage()}));
        }
        if (context == null) {
            throw new SQLException(JdbcLocalI18n.unableToFindObjectInJndi.text(new Object[]{jndiName}));
        }
        String repositoryName = "NotAssigned";
        try {
            Object target = context.lookup(jndiName);
            repositoryName = connInfo.getRepositoryName();
            if (target instanceof Repositories) {
                LOGGER.trace("JNDI Lookup found Repositories ", new Object[0]);
                Repositories repositories = (Repositories)target;
                if (repositoryName == null) {
                    repositoryNames = repositories.getRepositoryNames();
                    if (repositoryNames == null || repositoryNames.isEmpty()) {
                        throw new SQLException(JdbcLocalI18n.noRepositoryNamesFound.text(new Object[0]));
                    }
                    if (repositoryNames.size() == 1) {
                        repositoryName = repositoryNames.iterator().next();
                        connInfo.setRepositoryName(repositoryName);
                        LOGGER.trace("Setting Repository {0} as default", new Object[]{repositoryName});
                    } else {
                        throw new SQLException(JdbcLocalI18n.objectInJndiIsRepositories.text(new Object[]{jndiName}));
                    }
                }
                try {
                    repository = repositories.getRepository(repositoryName);
                }
                catch (RepositoryException e) {
                    throw new SQLException(JdbcLocalI18n.unableToFindNamedRepository.text(new Object[]{jndiName, repositoryName}));
                }
            } else if (target instanceof Repository) {
                LOGGER.trace("JNDI Lookup found a Repository", new Object[0]);
                repository = (Repository)target;
                repositoryNames = new HashSet<String>(1);
                if (repositoryName == null) {
                    repositoryName = "DefaultRepository";
                    connInfo.setRepositoryName(repositoryName);
                }
                repositoryNames.add(repositoryName);
            } else {
                throw new SQLException(JdbcLocalI18n.objectInJndiMustBeRepositoryOrRepositories.text(new Object[]{jndiName}));
            }
            assert (repository != null);
        }
        catch (NamingException e) {
            throw new SQLException(JdbcLocalI18n.unableToFindObjectInJndi.text(new Object[]{jndiName}), e);
        }
        this.setRepository(repository);
        this.setRepositoryName(repositoryName);
        this.setRepositoryNames(repositoryNames);
    }

    @Override
    public boolean isValid(int timeout) throws RepositoryException {
        LocalSession ls = this.getLocalSession();
        if (!ls.getSession().isLive()) {
            ls.remove();
            return false;
        }
        return true;
    }

    @Override
    public void closeStatement() {
        LocalSession session = this.getCurrentLocalSession();
        try {
            if (session != null) {
                session.remove();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void close() {
        for (LocalSession id : TRANSACTION_IDS) {
            id.remove();
        }
    }

    @Override
    public void rollback() throws RepositoryException {
        this.closeStatement();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            if (iface.isInstance(this)) {
                return iface.cast(this);
            }
            if (iface.isInstance(Workspace.class)) {
                Workspace workspace = this.getLocalSession().getSession().getWorkspace();
                return iface.cast(workspace);
            }
        }
        catch (RepositoryException re) {
            throw new SQLException(re.getLocalizedMessage());
        }
        throw new SQLException(JdbcLocalI18n.classDoesNotImplementInterface.text(new Object[]{Connection.class.getSimpleName(), iface.getName()}));
    }

    class JNDIConnectionInfo
    extends ConnectionInfo {
        protected JNDIConnectionInfo(String url, Properties properties) {
            super(url, properties);
        }

        @Override
        public String getUrlExample() {
            return LocalRepositoryDelegate.JNDI_EXAMPLE_URL;
        }

        @Override
        public String getUrlPrefix() {
            return "jdbc:jcr:jndi:";
        }

        @Override
        protected void addRepositoryNamePropertyInfo(List<DriverPropertyInfo> results) {
            boolean no_errors = results.size() == 0;
            boolean nameRequired = false;
            if (this.getRepositoryName() == null) {
                boolean found = false;
                if (no_errors) {
                    try {
                        Context context = LocalRepositoryDelegate.this.getJcrContext().createContext(this.getProperties());
                        Object obj = context.lookup(this.getRepositoryPath());
                        if (obj instanceof Repositories) {
                            nameRequired = true;
                            found = true;
                        } else if (obj instanceof Repository) {
                            found = true;
                        }
                    }
                    catch (NamingException e) {
                        // empty catch block
                    }
                }
                if (nameRequired || !found) {
                    DriverPropertyInfo info = new DriverPropertyInfo(JdbcLocalI18n.repositoryNamePropertyName.text(new Object[0]), null);
                    info.description = JdbcLocalI18n.repositoryNamePropertyDescription.text(new Object[0]);
                    info.required = nameRequired;
                    info.choices = null;
                    results.add(info);
                }
            }
        }
    }
}

