/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.jcr.query.QueryResult;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.modeshape.jcr.MultiUseAbstractTest;
import org.modeshape.jdbc.DriverInfo;
import org.modeshape.jdbc.JcrConnection;
import org.modeshape.jdbc.JcrMetaData;
import org.modeshape.jdbc.JdbcLocalI18n;
import org.modeshape.jdbc.TestUtil;
import org.modeshape.jdbc.delegate.ConnectionInfo;
import org.modeshape.jdbc.delegate.RepositoryDelegate;

public class JcrMetaDataTest
extends MultiUseAbstractTest {
    private JcrMetaData metadata;
    private DriverInfo driverInfo;
    @Mock
    private JcrConnection connection;
    @Mock
    private RepositoryDelegate delegate;
    @Mock
    private ConnectionInfo connInfo;
    @Mock
    private QueryResult queryResult;
    private static final int NO_LIMIT = 0;

    @BeforeClass
    public static void beforeAll() throws Exception {
        MultiUseAbstractTest.beforeAll();
        JcrMetaDataTest.registerNodeTypes((String)"cars.cnd");
        JcrMetaDataTest.importContent((String)"/", (String)"cars-system-view-with-uuids.xml", (int)3);
    }

    @Before
    public void beforeEach() throws Exception {
        super.beforeEach();
        MockitoAnnotations.initMocks((Object)((Object)this));
        this.driverInfo = new DriverInfo(JdbcLocalI18n.driverName.text(new Object[0]), JdbcLocalI18n.driverVendor.text(new Object[0]), JdbcLocalI18n.driverVendorUrl.text(new Object[0]), JdbcLocalI18n.driverVersion.text(new Object[0]));
        this.print = false;
        Mockito.when((Object)this.connection.getRepositoryDelegate()).thenReturn((Object)this.delegate);
        HashSet<String> names = new HashSet<String>();
        names.add("repo");
        Mockito.when((Object)this.connection.getCatalog()).thenReturn((Object)"repo");
        Mockito.when((Object)this.connection.driverInfo()).thenReturn((Object)this.driverInfo);
        this.metadata = new JcrMetaData(this.connection);
        Mockito.when((Object)this.delegate.getConnectionInfo()).thenReturn((Object)this.connInfo);
        Mockito.when((Object)this.delegate.execute(Matchers.anyString(), Matchers.anyString())).thenReturn((Object)this.queryResult);
        Mockito.when((Object)this.connInfo.getRepositoryName()).thenReturn((Object)"repoName");
        Mockito.when((Object)this.queryResult.getColumnNames()).thenReturn((Object)TestUtil.COLUMN_NAMES);
    }

    @Test
    public void shouldHaveSession() {
        Assert.assertThat((Object)session, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldHaveMetaData() {
        Assert.assertThat((Object)this.metadata, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void testMethodsWithoutParams() throws Exception {
        Class<?> dbmdClass = this.metadata.getClass();
        Method[] methods = dbmdClass.getDeclaredMethods();
        Map<Object, Object> expectedMap = new HashMap();
        ArrayList<String> failedMessages = new ArrayList<String>();
        expectedMap = this.getExpected();
        for (int i = 0; i < methods.length; ++i) {
            if (!expectedMap.containsKey(methods[i].getName())) continue;
            Object actualValue = null;
            Object expectedValue = null;
            Object expectedReturn = expectedMap.get(methods[i].getName());
            Object[] params = null;
            if (expectedReturn instanceof List) {
                List returned = (List)expectedReturn;
                params = (Object[])returned.get(1);
                expectedValue = returned.get(0);
                actualValue = methods[i].invoke((Object)this.metadata, params);
            } else {
                expectedValue = expectedReturn;
                actualValue = methods[i].invoke((Object)this.metadata, new Object[0]);
            }
            if (expectedValue == null || actualValue == null) {
                if (expectedValue == null && actualValue != null) {
                    failedMessages.add(" Expected doesn't match with actual for method - " + methods[i].getName() + " expected: <" + expectedValue + "> but was: < " + actualValue + "> ");
                    continue;
                }
                if (expectedValue == null || actualValue != null) continue;
                failedMessages.add(" Expected doesn't match with actual for method - " + methods[i].getName() + " expected: <" + expectedValue + "> but was: < " + actualValue + "> ");
                continue;
            }
            if (expectedValue.equals(actualValue)) continue;
            failedMessages.add(" Expected doesn't match with actual for method - " + methods[i].getName() + " expected: <" + expectedValue + "> but was: < " + actualValue + "> ");
        }
        Assert.assertThat((Object)((Object)failedMessages).toString().trim(), (Matcher)Is.is((Object)"[]"));
    }

    @Test
    public void testMethodsWithExceptions() throws Exception {
        Class<?> metadataClass = this.metadata.getClass();
        Method[] methods = metadataClass.getDeclaredMethods();
        HashMap expectedMap = new HashMap();
        for (int i = 0; i < methods.length; ++i) {
            if (!expectedMap.containsKey(methods[i].getName())) continue;
            methods[i].invoke((Object)this.metadata, new Object[0]);
        }
    }

    private Map<String, Object> getExpected() {
        HashMap<String, Object> expected = new HashMap<String, Object>();
        expected.put("allProceduresAreCallable", Boolean.FALSE);
        expected.put("allTablesAreSelectable", Boolean.FALSE);
        expected.put("doesMaxRowSizeIncludeBlobs", Boolean.FALSE);
        expected.put("isCatalogAtStart", Boolean.TRUE);
        expected.put("isReadOnly", Boolean.TRUE);
        expected.put("locatorsUpdateCopy", Boolean.FALSE);
        expected.put("nullPlusNonNullIsNull", Boolean.FALSE);
        expected.put("nullsAreSortedAtEnd", Boolean.FALSE);
        expected.put("nullsAreSortedAtStart", Boolean.FALSE);
        expected.put("nullsAreSortedHigh", Boolean.FALSE);
        expected.put("nullsAreSortedLow", Boolean.TRUE);
        expected.put("storesLowerCaseIdentifiers", Boolean.FALSE);
        expected.put("storesLowerCaseQuotedIdentifiers", Boolean.FALSE);
        expected.put("storesMixedCaseIdentifiers", Boolean.FALSE);
        expected.put("storesMixedCaseQuotedIdentifiers", Boolean.FALSE);
        expected.put("storesUpperCaseIdentifiers", Boolean.FALSE);
        expected.put("storesUpperCaseQuotedIdentifiers", Boolean.FALSE);
        expected.put("supportsAlterTableWithAddColumn", Boolean.FALSE);
        expected.put("supportsAlterTableWithDropColumn", Boolean.FALSE);
        expected.put("supportsANSI92EntryLevelSQL", Boolean.FALSE);
        expected.put("supportsANSI92FullSQL", Boolean.FALSE);
        expected.put("supportsANSI92IntermediateSQL", Boolean.FALSE);
        expected.put("supportsBatchUpdates", Boolean.FALSE);
        expected.put("supportsCatalogsInDataManipulation", Boolean.FALSE);
        expected.put("supportsCatalogsInIndexDefinitions", Boolean.FALSE);
        expected.put("supportsCatalogsInPrivilegeDefinitions", Boolean.FALSE);
        expected.put("supportsCatalogsInProcedureCalls", Boolean.FALSE);
        expected.put("supportsCatalogsInTableDefinitions", Boolean.FALSE);
        expected.put("supportsColumnAliasing", Boolean.FALSE);
        expected.put("supportsCorrelatedSubqueries", Boolean.FALSE);
        expected.put("supportsCoreSQLGrammar", Boolean.FALSE);
        expected.put("supportsDataDefinitionAndDataManipulationTransactions", Boolean.FALSE);
        expected.put("supportsDataManipulationTransactionsOnly", Boolean.FALSE);
        expected.put("supportsDifferentTableCorrelationNames", Boolean.FALSE);
        expected.put("supportsExpressionsInOrderBy", Boolean.FALSE);
        expected.put("supportsExtendedSQLGrammar", Boolean.FALSE);
        expected.put("supportsFullOuterJoins", Boolean.FALSE);
        expected.put("supportsGetGeneratedKeys", Boolean.FALSE);
        expected.put("supportsGroupBy", Boolean.FALSE);
        expected.put("supportsGroupByBeyondSelect", Boolean.FALSE);
        expected.put("supportsGroupByUnrelated", Boolean.FALSE);
        expected.put("supportsIntegrityEnhancementFacility", Boolean.FALSE);
        expected.put("supportsLikeEscapeClause", Boolean.FALSE);
        expected.put("supportsLimitedOuterJoins", Boolean.FALSE);
        expected.put("supportsMinimumSQLGrammar", Boolean.FALSE);
        expected.put("supportsMixedCaseIdentifiers", Boolean.FALSE);
        expected.put("supportsMixedCaseQuotedIdentifiers", Boolean.FALSE);
        expected.put("supportsOpenCursorsAcrossCommit", Boolean.FALSE);
        expected.put("supportsMultipleResultSets", Boolean.FALSE);
        expected.put("supportsMultipleOpenResults", Boolean.FALSE);
        expected.put("supportsMultipleTransactions", Boolean.FALSE);
        expected.put("supportsNamedParameters", Boolean.FALSE);
        expected.put("supportsNonNullableColumns", Boolean.FALSE);
        expected.put("supportsOpenCursorsAcrossRollback", Boolean.FALSE);
        expected.put("supportsOpenStatementsAcrossCommit", Boolean.FALSE);
        expected.put("supportsOpenStatementsAcrossRollback", Boolean.FALSE);
        expected.put("supportsOrderByUnrelated", Boolean.FALSE);
        expected.put("supportsOuterJoins", Boolean.TRUE);
        expected.put("supportsPositionedDelete", Boolean.FALSE);
        expected.put("supportsPositionedUpdate", Boolean.FALSE);
        expected.put("supportsSavepoints", Boolean.FALSE);
        expected.put("supportsSchemasInDataManipulation", Boolean.FALSE);
        expected.put("supportsSchemasInIndexDefinitions", Boolean.FALSE);
        expected.put("supportsSchemasInPrivilegeDefinitions", Boolean.FALSE);
        expected.put("supportsSchemasInProcedureCalls", Boolean.FALSE);
        expected.put("supportsSchemasInTableDefinitions", Boolean.FALSE);
        expected.put("supportsSelectForUpdate", Boolean.FALSE);
        expected.put("supportsStatementPooling", Boolean.FALSE);
        expected.put("supportsStoredProcedures", Boolean.FALSE);
        expected.put("supportsSubqueriesInComparisons", Boolean.FALSE);
        expected.put("supportsSubqueriesInExists", Boolean.FALSE);
        expected.put("supportsSubqueriesInIns", Boolean.FALSE);
        expected.put("supportsSubqueriesInQuantifieds", Boolean.FALSE);
        expected.put("supportsTableCorrelationNames", Boolean.TRUE);
        expected.put("supportsTransactions", Boolean.FALSE);
        expected.put("supportsUnion", Boolean.FALSE);
        expected.put("supportsUnionAll", Boolean.FALSE);
        expected.put("usesLocalFilePerTable", Boolean.FALSE);
        expected.put("usesLocalFiles", Boolean.FALSE);
        expected.put("usesLocalFilePerTable", Boolean.FALSE);
        expected.put("getJDBCMajorVersion", new Integer(2));
        expected.put("getJDBCMinorVersion", new Integer(0));
        expected.put("getDefaultTransactionIsolation", 0);
        expected.put("getDriverMajorVersion", TestUtil.majorVersion());
        expected.put("getDriverMinorVersion", TestUtil.minorVersion());
        expected.put("getMaxBinaryLiteralLength", new Integer(0));
        expected.put("getMaxCatalogNameLength", new Integer(0));
        expected.put("getMaxCharLiteralLength", new Integer(0));
        expected.put("getMaxColumnNameLength", new Integer(0));
        expected.put("getMaxColumnsInGroupBy", new Integer(0));
        expected.put("getMaxColumnsInIndex", new Integer(0));
        expected.put("getMaxColumnsInOrderBy", new Integer(0));
        expected.put("getMaxColumnsInSelect", new Integer(0));
        expected.put("getMaxColumnsInTable", new Integer(0));
        expected.put("getMaxConnections", new Integer(0));
        expected.put("getMaxCursorNameLength", new Integer(0));
        expected.put("getMaxIndexLength", new Integer(0));
        expected.put("getMaxProcedureNameLength", new Integer(0));
        expected.put("getMaxRowSize", new Integer(0));
        expected.put("getMaxStatementLength", new Integer(0));
        expected.put("getMaxStatements", new Integer(0));
        expected.put("getMaxTableNameLength", new Integer(0));
        expected.put("getMaxTablesInSelect", new Integer(0));
        expected.put("getMaxUserNameLength", new Integer(0));
        expected.put("getSQLStateType", new Integer(0));
        expected.put("getCatalogSeparator", null);
        expected.put("getCatalogTerm", "Repository");
        expected.put("getDriverName", JdbcLocalI18n.driverName.text(new Object[0]));
        expected.put("getDriverVersion", JdbcLocalI18n.driverVersion.text(new Object[0]));
        expected.put("getIdentifierQuoteString", "\"");
        return expected;
    }
}

