/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.jcr.Binary;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.query.Row;
import org.modeshape.jdbc.QueryResultRowIterator;
import org.modeshape.jdbc.TestUtil;

class QueryResultRow
implements Row {
    protected final QueryResultRowIterator iterator;
    private Node[] nodes;
    protected final Object[] tuple;

    protected QueryResultRow(QueryResultRowIterator iterator, Node[] nodes, Object[] tuple) {
        this.iterator = iterator;
        this.tuple = tuple;
        this.nodes = nodes;
    }

    public Node getNode() throws RepositoryException {
        if (this.nodes.length == 1) {
            return this.nodes[0];
        }
        throw new RepositoryException("More than one selector");
    }

    public Node getNode(String selectorName) throws RepositoryException {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (!this.nodes[i].getName().equals(selectorName)) continue;
            return this.nodes[i];
        }
        return null;
    }

    public String getPath() throws RepositoryException {
        if (this.nodes.length == 1) {
            return this.nodes[0].getPath();
        }
        throw new RepositoryException("More than one selector");
    }

    public String getPath(String selectorName) throws RepositoryException {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (!this.nodes[i].getName().equals(selectorName)) continue;
            return this.nodes[i].getPath();
        }
        return null;
    }

    public double getScore() {
        throw new UnsupportedOperationException();
    }

    public double getScore(String selectorName) {
        throw new UnsupportedOperationException();
    }

    public Value getValue(String arg0) throws ItemNotFoundException {
        for (int i = 0; i < TestUtil.COLUMN_NAMES.length; ++i) {
            if (!TestUtil.COLUMN_NAMES[i].equals(arg0)) continue;
            return this.createValue(this.tuple[i]);
        }
        throw new ItemNotFoundException("Item " + arg0 + " not found");
    }

    public Value[] getValues() throws RepositoryException {
        Value[] values = new Value[this.tuple.length];
        for (int i = 0; i < this.tuple.length; ++i) {
            values[i] = this.createValue(this.tuple[i]);
        }
        return values;
    }

    private Value createValue(final Object value) {
        if (value == null) {
            return null;
        }
        Value rtnvalue = new Value(){
            final Object valueObject;
            {
                this.valueObject = value;
            }

            public boolean getBoolean() throws ValueFormatException, IllegalStateException, RepositoryException {
                if (value instanceof Boolean) {
                    return (Boolean)this.valueObject;
                }
                throw new ValueFormatException("Value not a Boolean");
            }

            public Calendar getDate() throws ValueFormatException, IllegalStateException, RepositoryException {
                if (value instanceof Date) {
                    GregorianCalendar t = new GregorianCalendar();
                    t.clear();
                    ((Calendar)t).setTimeZone(TimeZone.getTimeZone(TestUtil.TIME_ZONE));
                    t.setTimeInMillis(((Date)value).getTime());
                    return t;
                }
                if (value instanceof Calendar) {
                    return (Calendar)value;
                }
                throw new ValueFormatException("Value not instance of Date");
            }

            public double getDouble() throws ValueFormatException, IllegalStateException, RepositoryException {
                if (value instanceof Double) {
                    return (Double)this.valueObject;
                }
                throw new ValueFormatException("Value not a Double");
            }

            public long getLong() throws ValueFormatException, IllegalStateException, RepositoryException {
                if (value instanceof Long) {
                    return (Long)this.valueObject;
                }
                throw new ValueFormatException("Value not a Long");
            }

            public Binary getBinary() throws RepositoryException {
                if (value instanceof Binary) {
                    return (Binary)this.valueObject;
                }
                if (value instanceof byte[]) {
                    final byte[] bytes = (byte[])value;
                    return new Binary(){

                        public void dispose() {
                        }

                        public long getSize() {
                            return bytes.length;
                        }

                        public InputStream getStream() {
                            return new ByteArrayInputStream(bytes);
                        }

                        public int read(byte[] b, long position) throws IOException {
                            if (this.getSize() <= position) {
                                return -1;
                            }
                            InputStream stream = null;
                            IOException error = null;
                            try {
                                long skipped;
                                stream = this.getStream();
                                for (long skip = position; skip > 0L; skip -= skipped) {
                                    skipped = stream.skip(skip);
                                    if (skipped > 0L) continue;
                                    int n = -1;
                                    return n;
                                }
                                int n = stream.read(b);
                                return n;
                            }
                            catch (IOException e) {
                                error = e;
                                throw e;
                            }
                            finally {
                                block19: {
                                    if (stream != null) {
                                        try {
                                            stream.close();
                                        }
                                        catch (RuntimeException t) {
                                            if (error == null) {
                                                throw t;
                                            }
                                        }
                                        catch (IOException t) {
                                            if (error != null) break block19;
                                            throw t;
                                        }
                                    }
                                }
                            }
                        }
                    };
                }
                throw new ValueFormatException("Value not a Binary");
            }

            public BigDecimal getDecimal() throws ValueFormatException, RepositoryException {
                if (value instanceof BigDecimal) {
                    return (BigDecimal)this.valueObject;
                }
                throw new ValueFormatException("Value not a Decimal");
            }

            public InputStream getStream() throws IllegalStateException, RepositoryException {
                if (value instanceof Binary) {
                    return ((Binary)this.valueObject).getStream();
                }
                if (value instanceof InputStream) {
                    return (InputStream)this.valueObject;
                }
                throw new ValueFormatException("Value not an InputStream");
            }

            public String getString() throws IllegalStateException {
                if (value instanceof String) {
                    return (String)this.valueObject;
                }
                return this.valueObject.toString();
            }

            public int getType() {
                return 1;
            }
        };
        return rtnvalue;
    }
}

