/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Set;
import javax.naming.Context;
import javax.naming.NamingException;
import org.modeshape.common.collection.Collections;
import org.modeshape.common.i18n.I18nResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.jdbc.DriverInfo;
import org.modeshape.jdbc.JdbcLocalI18n;
import org.modeshape.jdbc.delegate.ConnectionInfo;
import org.modeshape.jdbc.delegate.LocalRepositoryDelegate;
import org.modeshape.jdbc.delegate.RepositoryDelegateFactory;

public class LocalJcrDriver
implements Driver {
    protected static Logger logger = Logger.getLogger((String)"org.modeshape.jdbc");
    public static final String WORKSPACE_PROPERTY_NAME = "workspace";
    public static final String REPOSITORY_PROPERTY_NAME = "repositoryName";
    public static final String USERNAME_PROPERTY_NAME = "user";
    public static final String PASSWORD_PROPERTY_NAME = "password";
    public static final String TEIID_SUPPORT_PROPERTY_NAME = "teiidsupport";
    protected static final Set<String> ALL_PROPERTY_NAMES = Collections.unmodifiableSet((Object[])new String[]{"workspace", "repositoryName", "user", "password", "teiidsupport"});
    public static final String JNDI_URL_PREFIX = "jdbc:jcr:jndi:";
    private static LocalJcrDriver INSTANCE = new LocalJcrDriver();
    private final JcrContextFactory contextFactory;
    private final RepositoryDelegateFactory delegateFactory;
    private final DriverInfo driverInfo;

    public static LocalJcrDriver getInstance() {
        return INSTANCE;
    }

    public LocalJcrDriver() {
        this(null);
    }

    public LocalJcrDriver(JcrContextFactory namingContextFactory) {
        this(LocalRepositoryDelegate.FACTORY, new DriverInfo(JdbcLocalI18n.driverName.text(new Object[0]), JdbcLocalI18n.driverVendor.text(new Object[0]), JdbcLocalI18n.driverVendorUrl.text(new Object[0]), JdbcLocalI18n.driverVersion.text(new Object[0])), namingContextFactory);
    }

    protected LocalJcrDriver(RepositoryDelegateFactory delegateFactory, DriverInfo driverInfo, JcrContextFactory namingContextFactory) {
        assert (delegateFactory != null);
        assert (driverInfo != null);
        this.delegateFactory = delegateFactory;
        this.driverInfo = driverInfo;
        this.contextFactory = namingContextFactory;
    }

    @Override
    public boolean acceptsURL(String url) {
        return this.delegateFactory.acceptUrl(url);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return this.delegateFactory.createRepositoryDelegate(url, info, this.contextFactory).getConnectionInfo().getPropertyInfos();
    }

    protected ConnectionInfo createConnectionInfo(String url, Properties info) throws SQLException {
        return this.delegateFactory.createRepositoryDelegate(url, info, this.contextFactory).getConnectionInfo();
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        return this.delegateFactory.createRepositoryDelegate(url, info, this.contextFactory).createConnection(this.getDriverInfo());
    }

    @Override
    public int getMajorVersion() {
        return this.getDriverInfo().getMajorVersion();
    }

    @Override
    public int getMinorVersion() {
        return this.getDriverInfo().getMinorVersion();
    }

    public String getVendorName() {
        return this.getDriverInfo().getVendorName();
    }

    public String getVendorUrl() {
        return this.getDriverInfo().getVendorUrl();
    }

    public String getVersion() {
        return this.getDriverInfo().getVersion();
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    protected final DriverInfo getDriverInfo() {
        return this.driverInfo;
    }

    static {
        try {
            DriverManager.registerDriver(INSTANCE);
        }
        catch (SQLException e) {
            logger.error((I18nResource)JdbcLocalI18n.driverErrorRegistering, new Object[]{e.getMessage()});
        }
    }

    public static interface JcrContextFactory {
        public Context createContext(Properties var1) throws NamingException;
    }
}

