/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc.util;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLXML;
import javax.jcr.Value;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.modeshape.jdbc.JcrResultSet;
import org.modeshape.jdbc.JcrType;
import org.modeshape.jdbc.util.StringLineReader;

public class ResultSetReader
extends StringLineReader {
    private static final String DEFAULT_DELIM = "    ";
    ResultSet source = null;
    ResultSetMetaData metadata = null;
    int columnCount = 0;
    String delimiter = null;
    boolean firstTime = true;
    int[] columnTypes = null;
    private int rowCount = 0;
    private boolean compareColumns = true;

    public ResultSetReader(ResultSet in, String delimiter, boolean compareCols) {
        this.source = in;
        this.delimiter = delimiter;
        this.compareColumns = compareCols;
    }

    @Override
    public void close() throws IOException {
        try {
            this.source.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        super.close();
    }

    @Override
    protected String nextLine() throws IOException, SQLException {
        if (this.firstTime) {
            this.firstTime = false;
            this.metadata = this.source.getMetaData();
            this.columnCount = this.metadata.getColumnCount();
            this.columnTypes = new int[this.columnCount];
            for (int i = 0; i < this.columnCount; ++i) {
                this.columnTypes[i] = this.metadata.getColumnType(i + 1);
            }
            return ResultSetReader.resultSetMetaDataToString(this.metadata, this.delimiter);
        }
        if (this.source.next()) {
            ++this.rowCount;
            StringBuffer sb = new StringBuffer();
            for (int col = 1; col <= this.columnCount; ++col) {
                Object anObj = this.source.getObject(col);
                if (this.compareColumns) {
                    this.compareColumn(col, anObj);
                }
                if (this.columnTypes[col - 1] == 2005) {
                    sb.append(anObj != null ? anObj : "null");
                } else if (this.columnTypes[col - 1] == 2004) {
                    sb.append(anObj != null ? "BLOB" : "null");
                } else if (this.columnTypes[col - 1] == 2009) {
                    SQLXML xml = (SQLXML)anObj;
                    sb.append(anObj != null ? ResultSetReader.prettyPrint(xml) : "null");
                } else {
                    sb.append(anObj != null ? anObj : "null");
                }
                if (col == this.columnCount) continue;
                sb.append(this.delimiter);
            }
            sb.append("\n");
            return sb.toString();
        }
        return null;
    }

    private void compareColumn(int col, Object objIdx) throws SQLException {
        String colName = this.metadata.getColumnName(col);
        Object objName = this.source.getObject(colName);
        Assert.assertThat((Object)objIdx, (Matcher)Is.is((Object)objName));
        if (objIdx == null) {
            return;
        }
        if (this.source instanceof JcrResultSet) {
            Value v = ((JcrResultSet)this.source).getValue(col);
            JcrType jcrType = JcrType.typeInfo((int)v.getType());
            Assert.assertThat((Object)objIdx, (Matcher)IsInstanceOf.instanceOf((Class)jcrType.getRepresentationClass()));
        }
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public static String resultSetMetaDataToString(ResultSetMetaData metadata, String delimiter) throws SQLException {
        StringBuffer sb = new StringBuffer();
        int columnCount = metadata.getColumnCount();
        for (int col = 1; col <= columnCount; ++col) {
            JcrType jcrType;
            String colName = metadata.getColumnName(col);
            String colTypeName = metadata.getColumnTypeName(col);
            if (colName.equalsIgnoreCase("jcr:score")) {
                jcrType = JcrType.typeInfo((String)"Double");
                Assert.assertThat((Object)colTypeName, (Matcher)Is.is((Object)jcrType.getJcrName()));
            } else if (colName.equalsIgnoreCase("mode:depth")) {
                jcrType = JcrType.typeInfo((String)"Long");
                Assert.assertThat((Object)colTypeName, (Matcher)Is.is((Object)jcrType.getJcrName()));
            }
            sb.append(colName).append("[").append(colTypeName).append("]");
            if (col == columnCount) continue;
            sb.append(delimiter);
        }
        sb.append("\n");
        return sb.toString();
    }

    public static String prettyPrint(SQLXML xml) throws SQLException {
        try {
            TransformerFactory transFactory = TransformerFactory.newInstance();
            transFactory.setAttribute("indent-number", new Integer(2));
            Transformer tf = transFactory.newTransformer();
            tf.setOutputProperty("omit-xml-declaration", "yes");
            tf.setOutputProperty("encoding", "UTF-8");
            tf.setOutputProperty("indent", "yes");
            tf.setOutputProperty("method", "xml");
            tf.setOutputProperty("standalone", "yes");
            tf.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            StreamResult xmlOut = new StreamResult(new BufferedOutputStream(out));
            tf.transform(xml.getSource(StreamSource.class), xmlOut);
            return out.toString();
        }
        catch (Exception e) {
            return xml.getString();
        }
    }
}

