/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc.util;

import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;

public abstract class StringLineReader
extends Reader {
    String currentLine = null;
    int currentLineIndex = 0;
    boolean closed = false;

    @Override
    public void close() throws IOException {
        this.closed = true;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("Reader already closed");
        }
        int srcoff = this.currentLineIndex;
        if (this.currentLine == null || this.currentLine != null && this.currentLine.length() - this.currentLineIndex <= 0) {
            try {
                this.currentLine = this.nextLine();
            }
            catch (SQLException e) {
                throw new IOException(e.getLocalizedMessage(), e);
            }
            srcoff = this.currentLineIndex = 0;
        }
        if (this.currentLine != null) {
            if (len > this.currentLine.length() - this.currentLineIndex) {
                len = this.currentLine.length() - this.currentLineIndex;
            }
            System.arraycopy(this.currentLine.toCharArray(), srcoff, cbuf, off, len);
            this.currentLineIndex += len;
            return len;
        }
        return -1;
    }

    protected abstract String nextLine() throws IOException, SQLException;
}

