/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc.util;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.modeshape.jdbc.util.TimestampWithTimezone;

public class TimestampWithTimezoneTest {
    public static DateFormat DATETIME_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    public static DateFormat TIME_FORMAT = new SimpleDateFormat("hh:mm:ss a");

    @Before
    public void setUp() {
        TimestampWithTimezone.resetCalendar((TimeZone)TimeZone.getTimeZone("America/Chicago"));
    }

    @After
    public void tearDown() {
        TimestampWithTimezone.resetCalendar(null);
    }

    public void helpIsDateSame(Calendar initial, Calendar target, Date expected) throws Exception {
        Date d = TimestampWithTimezone.createDate((Calendar)initial, (Calendar)target);
        DATE_FORMAT.setCalendar(target);
        String result = DATE_FORMAT.format(d);
        String expresult = DATE_FORMAT.format(expected);
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)expresult));
    }

    public void helpIsTimeSame(Calendar initial, Calendar target, Time time) throws Exception {
        Time d = TimestampWithTimezone.createTime((Calendar)initial, (Calendar)target);
        TIME_FORMAT.setCalendar(target);
        String result = TIME_FORMAT.format(d);
        String expresult = TIME_FORMAT.format(time);
        System.out.println(time.toString() + " - " + expresult);
        Assert.assertThat((Object)result, (Matcher)Is.is((Object)expresult));
    }

    @Test
    public void testDateTimezoneSame() throws Exception {
        GregorianCalendar cal_initial = new GregorianCalendar(TimeZone.getTimeZone("America/Chicago"));
        cal_initial.set(2004, 5, 23, 0, 0, 0);
        GregorianCalendar cal_target = new GregorianCalendar(TimeZone.getTimeZone("GMT-06:00"));
        Date d = Date.valueOf("2004-06-23");
        this.helpIsDateSame(cal_initial, cal_target, d);
    }

    @Test
    public void testDateDiffTimezone1() throws Exception {
        GregorianCalendar cal_initial = new GregorianCalendar(TimeZone.getTimeZone("America/Chicago"));
        cal_initial.set(2004, 5, 23, 0, 0, 0);
        GregorianCalendar cal_target = new GregorianCalendar(TimeZone.getTimeZone("Europe/London"));
        Date d = Date.valueOf("2004-06-23");
        this.helpIsDateSame(cal_initial, cal_target, d);
    }

    @Test
    public void testDateDiffTimezone2() throws Exception {
        GregorianCalendar cal_initial = new GregorianCalendar(TimeZone.getTimeZone("America/Chicago"));
        cal_initial.set(2004, 5, 23, 23, 15, 0);
        GregorianCalendar cal_target = new GregorianCalendar(TimeZone.getTimeZone("Europe/London"));
        Date d = Date.valueOf("2004-06-24");
        this.helpIsDateSame(cal_initial, cal_target, d);
    }

    @Test
    public void testTimeTimezoneSame() throws Exception {
        GregorianCalendar cal_initial = new GregorianCalendar(TimeZone.getTimeZone("America/Chicago"));
        cal_initial.set(2004, 5, 23, 15, 39, 10);
        GregorianCalendar cal_target = new GregorianCalendar(TimeZone.getTimeZone("GMT-06:00"));
        Time d = Time.valueOf("15:39:10");
        this.helpIsTimeSame(cal_initial, cal_target, d);
    }

    @Ignore
    @Test
    public void testTimeDiffTimezone1() throws Exception {
        GregorianCalendar cal_initial = new GregorianCalendar(TimeZone.getTimeZone("America/Chicago"));
        cal_initial.set(2004, 5, 23, 22, 39, 10);
        GregorianCalendar cal_target = new GregorianCalendar(TimeZone.getTimeZone("Europe/London"));
        Time d = Time.valueOf("03:39:10");
        this.helpIsTimeSame(cal_initial, cal_target, d);
    }

    @Ignore
    @Test
    public void testTimeDiffTimezone2() throws Exception {
        GregorianCalendar cal_initial = new GregorianCalendar(TimeZone.getTimeZone("Europe/London"));
        cal_initial.set(2004, 5, 23, 3, 39, 10);
        GregorianCalendar cal_target = new GregorianCalendar(TimeZone.getTimeZone("America/Chicago"));
        Time d = Time.valueOf("22:39:10");
        this.helpIsTimeSame(cal_initial, cal_target, d);
    }

    @Test
    public void testCreateDate() {
        GregorianCalendar cal_target = new GregorianCalendar();
        cal_target.set(2004, 5, 30, 0, 0, 0);
        cal_target.set(14, 0);
        Date date = TimestampWithTimezone.createDate((Calendar)cal_target);
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(date.getTime());
        Assert.assertThat((Object)cal.get(11), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)cal.get(12), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)cal.get(13), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)cal.get(14), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)cal.get(1), (Matcher)Is.is((Object)2004));
        Assert.assertThat((Object)cal.get(2), (Matcher)Is.is((Object)5));
        Assert.assertThat((Object)cal.get(5), (Matcher)Is.is((Object)30));
    }

    public void testCreateTime() {
        GregorianCalendar cal_target = new GregorianCalendar();
        cal_target.set(2004, 5, 30, 23, 39, 10);
        cal_target.set(14, 120);
        Time date = TimestampWithTimezone.createTime((Calendar)cal_target);
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(date.getTime());
        Assert.assertThat((Object)cal.get(11), (Matcher)Is.is((Object)23));
        Assert.assertThat((Object)cal.get(12), (Matcher)Is.is((Object)39));
        Assert.assertThat((Object)cal.get(13), (Matcher)Is.is((Object)10));
        Assert.assertThat((Object)cal.get(14), (Matcher)Is.is((Object)0));
        Assert.assertThat((Object)cal.get(1), (Matcher)Is.is((Object)2004));
        Assert.assertThat((Object)cal.get(2), (Matcher)Is.is((Object)5));
        Assert.assertThat((Object)cal.get(5), (Matcher)Is.is((Object)30));
    }

    public void testCreateTimeStamp() {
        GregorianCalendar cal_target = new GregorianCalendar();
        cal_target.set(2004, 5, 30, 23, 39, 10);
        cal_target.set(14, 120);
        Timestamp date = TimestampWithTimezone.createTimestamp((Calendar)cal_target);
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(date.getTime());
        Assert.assertThat((Object)cal.get(11), (Matcher)Is.is((Object)23));
        Assert.assertThat((Object)cal.get(12), (Matcher)Is.is((Object)39));
        Assert.assertThat((Object)cal.get(13), (Matcher)Is.is((Object)10));
        Assert.assertThat((Object)cal.get(14), (Matcher)Is.is((Object)120));
        Assert.assertThat((Object)cal.get(1), (Matcher)Is.is((Object)2004));
        Assert.assertThat((Object)cal.get(2), (Matcher)Is.is((Object)5));
        Assert.assertThat((Object)cal.get(5), (Matcher)Is.is((Object)30));
    }

    @Test
    public void testDateToDateConversion2() {
        Calendar localTime = Calendar.getInstance(TimeZone.getTimeZone("America/Chicago"));
        localTime.set(2, 5);
        localTime.set(5, 22);
        localTime.set(1, 2004);
        localTime.set(10, 23);
        localTime.set(12, 15);
        localTime.set(13, 20);
        localTime.set(9, 1);
        Date converted = TimestampWithTimezone.createDate((Calendar)localTime, (Calendar)Calendar.getInstance(TimeZone.getTimeZone("Europe/London")));
        Calendar cal = Calendar.getInstance();
        cal.setTime(converted);
        Assert.assertThat((Object)cal.get(14), (Matcher)Is.is((Object)0));
    }
}

