/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.TimeZone;
import javax.jcr.query.QueryResult;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.modeshape.common.util.IoUtil;
import org.modeshape.jdbc.JcrResultSet;
import org.modeshape.jdbc.JcrStatement;
import org.modeshape.jdbc.TestUtil;
import org.modeshape.jdbc.util.TimestampWithTimezone;

public class JcrResultSetTest {
    @Mock
    private JcrStatement statement;
    private QueryResult result;
    private JcrResultSet resultSet;

    @Before
    public void beforeEach() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.result = TestUtil.createQueryResult();
        this.resultSet = new JcrResultSet(this.statement, this.result, null);
        GregorianCalendar londonTime = new GregorianCalendar();
        londonTime.clear();
        ((Calendar)londonTime).setTimeZone(TimeZone.getTimeZone(TestUtil.TIME_ZONE));
        TimestampWithTimezone.resetCalendar((TimeZone)TimeZone.getTimeZone(TestUtil.TIME_ZONE));
    }

    @After
    public void afterEach() throws Exception {
        this.result = null;
        this.resultSet = null;
    }

    @Test
    public void shouldHaveResultSet() {
        Assert.assertThat((Object)this.resultSet, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldCallNext() throws SQLException {
        for (int i = 1; i <= TestUtil.TUPLES.size(); ++i) {
            Assert.assertThat((Object)this.resultSet.next(), (Matcher)Is.is((Object)true));
        }
        Assert.assertThat((Object)this.resultSet.next(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldCallGetRow() throws SQLException {
        Assert.assertThat((Object)this.resultSet.getRow(), (Matcher)Is.is((Object)0));
        for (int i = 1; i <= TestUtil.TUPLES.size(); ++i) {
            Assert.assertThat((Object)this.resultSet.next(), (Matcher)Is.is((Object)true));
            Assert.assertThat((Object)this.resultSet.getRow(), (Matcher)Is.is((Object)i));
        }
    }

    @Test
    public void shouldCallIsBeforeFirst() throws SQLException {
        Assert.assertThat((Object)this.resultSet.isBeforeFirst(), (Matcher)Is.is((Object)true));
        for (int i = 1; i <= TestUtil.TUPLES.size(); ++i) {
            Assert.assertThat((Object)this.resultSet.next(), (Matcher)Is.is((Object)true));
            Assert.assertThat((Object)this.resultSet.isBeforeFirst(), (Matcher)Is.is((Object)false));
        }
        Assert.assertThat((Object)this.resultSet.next(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.resultSet.isBeforeFirst(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldCallIsFirst() throws SQLException {
        Assert.assertThat((Object)this.resultSet.isFirst(), (Matcher)Is.is((Object)false));
        for (int i = 1; i <= TestUtil.TUPLES.size(); ++i) {
            Assert.assertThat((Object)this.resultSet.next(), (Matcher)Is.is((Object)true));
            if (i == 1) {
                Assert.assertThat((Object)this.resultSet.isFirst(), (Matcher)Is.is((Object)true));
                continue;
            }
            Assert.assertThat((Object)this.resultSet.isFirst(), (Matcher)Is.is((Object)false));
        }
        Assert.assertThat((Object)this.resultSet.next(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.resultSet.isFirst(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldCallIsLast() throws SQLException {
        this.resultSet.isLast();
        Assert.assertThat((Object)this.resultSet.isLast(), (Matcher)Is.is((Object)false));
        for (int i = 1; i <= TestUtil.TUPLES.size(); ++i) {
            Assert.assertThat((Object)this.resultSet.next(), (Matcher)Is.is((Object)true));
            if (i == TestUtil.TUPLES.size()) {
                Assert.assertThat((Object)this.resultSet.isLast(), (Matcher)Is.is((Object)true));
                continue;
            }
            Assert.assertThat((Object)this.resultSet.isLast(), (Matcher)Is.is((Object)false));
        }
        Assert.assertThat((Object)this.resultSet.next(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.resultSet.isLast(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldCallIsAfterLast() throws SQLException {
        Assert.assertThat((Object)this.resultSet.isAfterLast(), (Matcher)Is.is((Object)false));
        for (int i = 1; i <= TestUtil.TUPLES.size(); ++i) {
            Assert.assertThat((Object)this.resultSet.next(), (Matcher)Is.is((Object)true));
            Assert.assertThat((Object)this.resultSet.isAfterLast(), (Matcher)Is.is((Object)false));
        }
        Assert.assertThat((Object)this.resultSet.next(), (Matcher)Is.is((Object)false));
        Assert.assertThat((Object)this.resultSet.isAfterLast(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void shouldCallGetStringUsingColmnName() throws SQLException {
        int col = this.getColumnTypeLoc(TestUtil.STRING);
        for (int i = 0; i < TestUtil.TUPLES.size(); ++i) {
            Assert.assertThat((Object)this.resultSet.next(), (Matcher)Is.is((Object)true));
            Object[] tuple = TestUtil.TUPLES.get(i);
            Assert.assertThat((Object)this.resultSet.getString(TestUtil.COLUMN_NAMES[col]), (Matcher)Is.is((Object)tuple[col]));
        }
    }

    @Test
    public void shouldCallGetStringUsingColmnIndex() throws SQLException {
        int col = this.getColumnTypeLoc(TestUtil.STRING);
        for (int i = 0; i < TestUtil.TUPLES.size(); ++i) {
            Assert.assertThat((Object)this.resultSet.next(), (Matcher)Is.is((Object)true));
            Object[] tuple = TestUtil.TUPLES.get(i);
            Assert.assertThat((Object)this.resultSet.getString(col + 1), (Matcher)Is.is((Object)tuple[col]));
        }
    }

    @Test
    public void shouldCallGetLongReturnZeroWhenNullUsingColumnName() throws SQLException {
        int col = 8;
        for (int i = 0; i < TestUtil.TUPLES.size(); ++i) {
            Assert.assertThat((Object)this.resultSet.next(), (Matcher)Is.is((Object)true));
            Assert.assertThat((Object)this.resultSet.getLong(TestUtil.COLUMN_NAMES[col]), (Matcher)Is.is((Object)new Long(0L)));
        }
    }

    @Test
    public void shouldCallGetLongUsingColumnName() throws SQLException {
        int col = this.getColumnTypeLoc(TestUtil.LONG);
        for (int i = 0; i < TestUtil.TUPLES.size(); ++i) {
            Assert.assertThat((Object)this.resultSet.next(), (Matcher)Is.is((Object)true));
            Object[] tuple = TestUtil.TUPLES.get(i);
            Assert.assertThat((Object)this.resultSet.getLong(TestUtil.COLUMN_NAMES[col]), (Matcher)Is.is((Object)tuple[col]));
        }
    }

    @Test
    public void shouldCallGetLongUsingColmnIndex() throws SQLException {
        int col = this.getColumnTypeLoc(TestUtil.LONG);
        for (int i = 0; i < TestUtil.TUPLES.size(); ++i) {
            Assert.assertThat((Object)this.resultSet.next(), (Matcher)Is.is((Object)true));
            Object[] tuple = TestUtil.TUPLES.get(i);
            Assert.assertThat((Object)this.resultSet.getLong(col + 1), (Matcher)Is.is((Object)tuple[col]));
        }
    }

    @Test
    public void shouldCallGetDoubleUsingColumnName() throws SQLException {
        int col = this.getColumnTypeLoc(TestUtil.DOUBLE);
        for (int i = 0; i < TestUtil.TUPLES.size(); ++i) {
            Assert.assertThat((Object)this.resultSet.next(), (Matcher)Is.is((Object)true));
            Object[] tuple = TestUtil.TUPLES.get(i);
            Assert.assertThat((Object)this.resultSet.getDouble(TestUtil.COLUMN_NAMES[col]), (Matcher)Is.is((Object)tuple[col]));
        }
    }

    @Test
    public void shouldCallGetDoubleUsingColmnIndex() throws SQLException {
        int col = this.getColumnTypeLoc(TestUtil.DOUBLE);
        for (int i = 0; i < TestUtil.TUPLES.size(); ++i) {
            Assert.assertThat((Object)this.resultSet.next(), (Matcher)Is.is((Object)true));
            Object[] tuple = TestUtil.TUPLES.get(i);
            Assert.assertThat((Object)this.resultSet.getDouble(col + 1), (Matcher)Is.is((Object)tuple[col]));
        }
    }

    @Test
    public void shouldCallGetBooleanUsingColumnName() throws SQLException {
        int col = this.getColumnTypeLoc(TestUtil.BOOLEAN);
        for (int i = 0; i < TestUtil.TUPLES.size(); ++i) {
            Assert.assertThat((Object)this.resultSet.next(), (Matcher)Is.is((Object)true));
            Object[] tuple = TestUtil.TUPLES.get(i);
            Assert.assertThat((Object)this.resultSet.getBoolean(TestUtil.COLUMN_NAMES[col]), (Matcher)Is.is((Object)tuple[col]));
        }
    }

    @Test
    public void shouldCallGetBooleanUsingColmnIndex() throws SQLException {
        int col = this.getColumnTypeLoc(TestUtil.BOOLEAN);
        for (int i = 0; i < TestUtil.TUPLES.size(); ++i) {
            Assert.assertThat((Object)this.resultSet.next(), (Matcher)Is.is((Object)true));
            Object[] tuple = TestUtil.TUPLES.get(i);
            Assert.assertThat((Object)this.resultSet.getBoolean(col + 1), (Matcher)Is.is((Object)tuple[col]));
        }
    }

    @Test
    public void shouldCallGetDateUsingColumnName() throws SQLException {
        int col = this.getColumnTypeLoc(TestUtil.DATE);
        for (int i = 0; i < TestUtil.TUPLES.size(); ++i) {
            Assert.assertThat((Object)this.resultSet.next(), (Matcher)Is.is((Object)true));
            Date r = this.resultSet.getDate(col + 1);
            Assert.assertThat((Object)r.toString(), (Matcher)Is.is((Object)TestUtil.USE_DATE_FOR_SOURCE));
        }
    }

    @Test
    public void shouldCallGetDateUsingColumnNameAndCalendar() throws SQLException {
        GregorianCalendar localTime = new GregorianCalendar();
        ((Calendar)localTime).setTimeZone(TimeZone.getTimeZone(TestUtil.EXPECTED_TIMEZONE));
        int col = this.getColumnTypeLoc(TestUtil.DATE);
        for (int i = 0; i < TestUtil.TUPLES.size(); ++i) {
            Assert.assertThat((Object)this.resultSet.next(), (Matcher)Is.is((Object)true));
            Date resultDate = this.resultSet.getDate(col + 1, (Calendar)localTime);
            Assert.assertThat((Object)resultDate.toString(), (Matcher)Is.is((Object)TestUtil.EXPECTED_DATE_FOR_TARGET));
        }
    }

    @Test
    public void shouldCallGetDateUsingColmnIndex() throws SQLException {
        int col = this.getColumnTypeLoc(TestUtil.DATE);
        for (int i = 0; i < TestUtil.TUPLES.size(); ++i) {
            Assert.assertThat((Object)this.resultSet.next(), (Matcher)Is.is((Object)true));
            Date r = this.resultSet.getDate(col + 1);
            Assert.assertThat((Object)r.toString(), (Matcher)Is.is((Object)TestUtil.USE_DATE_FOR_SOURCE));
        }
    }

    @Test
    public void shouldCallGetDateUsingColmnIndexAndCalendar() throws SQLException {
        GregorianCalendar localTime = new GregorianCalendar();
        ((Calendar)localTime).setTimeZone(TimeZone.getTimeZone(TestUtil.EXPECTED_TIMEZONE));
        int col = this.getColumnTypeLoc(TestUtil.DATE);
        for (int i = 0; i < TestUtil.TUPLES.size(); ++i) {
            Assert.assertThat((Object)this.resultSet.next(), (Matcher)Is.is((Object)true));
            Date resultDate = this.resultSet.getDate(col + 1, (Calendar)localTime);
            Assert.assertThat((Object)resultDate.toString(), (Matcher)Is.is((Object)TestUtil.EXPECTED_DATE_FOR_TARGET));
        }
    }

    @Test
    public void shouldCallGetTimeUsingColumnName() throws SQLException {
        int col = this.getColumnTypeLoc(TestUtil.DATE);
        for (int i = 0; i < TestUtil.TUPLES.size(); ++i) {
            Assert.assertThat((Object)this.resultSet.next(), (Matcher)Is.is((Object)true));
            Time r = this.resultSet.getTime(col + 1);
            Assert.assertThat((Object)r.toString(), (Matcher)Is.is((Object)TestUtil.USE_TIME_FOR_SOURCE));
        }
    }

    @Test
    public void shouldCallGetTimeUsingColumnNameAndCalendar() throws SQLException {
        GregorianCalendar localTime = new GregorianCalendar();
        ((Calendar)localTime).setTimeZone(TimeZone.getTimeZone(TestUtil.EXPECTED_TIMEZONE));
        String EXPECTED_TIME_FOR_TARGET = "08:39:10";
        int col = this.getColumnTypeLoc(TestUtil.DATE);
        for (int i = 0; i < TestUtil.TUPLES.size(); ++i) {
            Assert.assertThat((Object)this.resultSet.next(), (Matcher)Is.is((Object)true));
            Time resultTime = this.resultSet.getTime(TestUtil.COLUMN_NAMES[col], (Calendar)localTime);
            Assert.assertThat((Object)resultTime.toString(), (Matcher)Is.is((Object)EXPECTED_TIME_FOR_TARGET));
        }
    }

    @Test
    public void shouldCallGetTimeUsingColmnIndex() throws SQLException {
        int col = this.getColumnTypeLoc(TestUtil.DATE);
        for (int i = 0; i < TestUtil.TUPLES.size(); ++i) {
            Assert.assertThat((Object)this.resultSet.next(), (Matcher)Is.is((Object)true));
            Time r = this.resultSet.getTime(col + 1);
            Assert.assertThat((Object)r.toString(), (Matcher)Is.is((Object)TestUtil.USE_TIME_FOR_SOURCE));
        }
    }

    @Test
    public void shouldCallGetTimeUsingColmnIndexAndCalendar() throws SQLException {
        GregorianCalendar localTime = new GregorianCalendar();
        ((Calendar)localTime).setTimeZone(TimeZone.getTimeZone(TestUtil.EXPECTED_TIMEZONE));
        String EXPECTED_TIME_FOR_TARGET = "08:39:10";
        int col = this.getColumnTypeLoc(TestUtil.DATE);
        for (int i = 0; i < TestUtil.TUPLES.size(); ++i) {
            Assert.assertThat((Object)this.resultSet.next(), (Matcher)Is.is((Object)true));
            Time resultTime = this.resultSet.getTime(col + 1, (Calendar)localTime);
            Assert.assertThat((Object)resultTime.toString(), (Matcher)Is.is((Object)EXPECTED_TIME_FOR_TARGET));
        }
    }

    @Test
    public void shouldCallGetTimeStampUsingColumnName() throws SQLException {
        int col = this.getColumnTypeLoc(TestUtil.DATE);
        for (int i = 0; i < TestUtil.TUPLES.size(); ++i) {
            Assert.assertThat((Object)this.resultSet.next(), (Matcher)Is.is((Object)true));
            Timestamp r = this.resultSet.getTimestamp(col + 1);
            Assert.assertThat((Object)r.toString(), (Matcher)Is.is((Object)TestUtil.USE_TIMESTAMP_FOR_SOURCE));
        }
    }

    @Test
    public void shouldCallGetTimeStampUsingColumnNameAndCalendar() throws SQLException {
        GregorianCalendar localTime = new GregorianCalendar();
        localTime.clear();
        ((Calendar)localTime).setTimeZone(TimeZone.getTimeZone(TestUtil.EXPECTED_TIMEZONE));
        int col = this.getColumnTypeLoc(TestUtil.DATE);
        for (int i = 0; i < TestUtil.TUPLES.size(); ++i) {
            Assert.assertThat((Object)this.resultSet.next(), (Matcher)Is.is((Object)true));
            Timestamp resultTimestamp = this.resultSet.getTimestamp(TestUtil.COLUMN_NAMES[col], (Calendar)localTime);
            Assert.assertThat((Object)resultTimestamp.toString(), (Matcher)Is.is((Object)TestUtil.EXPECTED_TIMESTAMP_FOR_TARGET));
        }
    }

    @Test
    public void shouldCallGetTimeStampUsingColmnIndex() throws SQLException {
        int col = this.getColumnTypeLoc(TestUtil.DATE);
        for (int i = 0; i < TestUtil.TUPLES.size(); ++i) {
            Assert.assertThat((Object)this.resultSet.next(), (Matcher)Is.is((Object)true));
            Timestamp r = this.resultSet.getTimestamp(col + 1);
            Assert.assertThat((Object)r.toString(), (Matcher)Is.is((Object)TestUtil.USE_TIMESTAMP_FOR_SOURCE));
        }
    }

    @Test
    public void shouldCallGetTimeStampUsingColmnIndexAndCalendar() throws SQLException {
        GregorianCalendar localTime = new GregorianCalendar();
        localTime.clear();
        ((Calendar)localTime).setTimeZone(TimeZone.getTimeZone(TestUtil.EXPECTED_TIMEZONE));
        int col = this.getColumnTypeLoc(TestUtil.DATE);
        for (int i = 0; i < TestUtil.TUPLES.size(); ++i) {
            Assert.assertThat((Object)this.resultSet.next(), (Matcher)Is.is((Object)true));
            Timestamp resultTime = this.resultSet.getTimestamp(col + 1, (Calendar)localTime);
            Assert.assertThat((Object)resultTime.toString(), (Matcher)Is.is((Object)TestUtil.EXPECTED_TIMESTAMP_FOR_TARGET));
        }
    }

    @Test
    public void shouldCallGetBytesUsingColmnIndex() throws SQLException {
        int numCols = TestUtil.COLUMN_NAMES.length;
        for (int i = 0; i < TestUtil.TUPLES.size(); ++i) {
            Assert.assertThat((Object)this.resultSet.next(), (Matcher)Is.is((Object)true));
            Object[] tuple = TestUtil.TUPLES.get(i);
            for (int x = 1; x <= numCols; ++x) {
                Object expectedValue = tuple[x - 1];
                if (expectedValue != null && !(expectedValue instanceof byte[])) {
                    expectedValue = expectedValue.toString().getBytes();
                }
                Assert.assertThat((Object)this.resultSet.getBytes(x), (Matcher)Is.is((Object)expectedValue));
            }
        }
    }

    @Test
    public void shouldCallGetBytesUsingColumnName() throws SQLException {
        int numCols = TestUtil.COLUMN_NAMES.length;
        for (int i = 0; i < TestUtil.TUPLES.size(); ++i) {
            Assert.assertThat((Object)this.resultSet.next(), (Matcher)Is.is((Object)true));
            Object[] tuple = TestUtil.TUPLES.get(i);
            for (int x = 0; x < numCols; ++x) {
                Object expectedValue = tuple[x];
                if (expectedValue != null && !(expectedValue instanceof byte[])) {
                    expectedValue = expectedValue.toString().getBytes();
                }
                Assert.assertThat((Object)this.resultSet.getBytes(TestUtil.COLUMN_NAMES[x]), (Matcher)Is.is((Object)expectedValue));
            }
        }
    }

    @Test
    public void shouldCallGetBinaryUsingColmnIndex() throws SQLException, IOException {
        int col = this.getColumnTypeLoc(TestUtil.BINARY);
        for (int i = 0; i < TestUtil.TUPLES.size(); ++i) {
            Assert.assertThat((Object)this.resultSet.next(), (Matcher)Is.is((Object)true));
            Object[] tuple = TestUtil.TUPLES.get(i);
            Assert.assertThat((Object)IoUtil.readBytes((InputStream)this.resultSet.getBinaryStream(col + 1)), (Matcher)Is.is((Object)tuple[col]));
        }
    }

    @Test
    public void shouldCallGetBinaryUsingColumnName() throws SQLException, IOException {
        int col = this.getColumnTypeLoc(TestUtil.BINARY);
        for (int i = 0; i < TestUtil.TUPLES.size(); ++i) {
            Assert.assertThat((Object)this.resultSet.next(), (Matcher)Is.is((Object)true));
            Object[] tuple = TestUtil.TUPLES.get(i);
            Assert.assertThat((Object)IoUtil.readBytes((InputStream)this.resultSet.getBinaryStream(TestUtil.COLUMN_NAMES[col])), (Matcher)Is.is((Object)tuple[col]));
        }
    }

    @Test
    public void shouldCallGetObjectUsingColumnName() throws Exception {
        int numCols = TestUtil.COLUMN_NAMES.length;
        for (int i = 0; i < TestUtil.TUPLES.size(); ++i) {
            Assert.assertThat((Object)this.resultSet.next(), (Matcher)Is.is((Object)true));
            Object[] tuple = TestUtil.TUPLES.get(i);
            for (int x = 0; x < numCols; ++x) {
                Object o = this.resultSet.getObject(TestUtil.COLUMN_NAMES[x]);
                Object expectedValue = tuple[x];
                if (expectedValue instanceof Calendar) {
                    expectedValue = new Timestamp(((Calendar)expectedValue).getTimeInMillis());
                }
                if (expectedValue instanceof byte[]) {
                    Assert.assertThat((Object)(o instanceof Blob), (Matcher)Is.is((Object)true));
                    o = IoUtil.readBytes((InputStream)((Blob)o).getBinaryStream());
                }
                Assert.assertThat((Object)(o != null ? o : null), (Matcher)Is.is((Object)(expectedValue != null ? expectedValue : null)));
            }
        }
    }

    private int getColumnTypeLoc(String type) {
        for (int i = 0; i <= TestUtil.TYPE_NAMES.length; ++i) {
            if (!TestUtil.TYPE_NAMES[i].equals(type)) continue;
            return i;
        }
        Assert.assertFalse((String)("Did not find a type match: " + type), (boolean)true);
        return -1;
    }

    @Test
    public void shouldReturnMetaData() throws SQLException {
        Assert.assertThat((Object)this.resultSet.getMetaData(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void shouldReturnFetchDirection() throws SQLException {
        Assert.assertThat((Object)this.resultSet.getFetchDirection(), (Matcher)Is.is((Object)1000));
    }

    @Test
    public void shouldReturnDefaultFetchSize() throws SQLException {
        Assert.assertThat((Object)this.resultSet.getFetchSize(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldReturnHoldability() throws SQLException {
        Assert.assertThat((Object)this.resultSet.getHoldability(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldBeAbleToClose() {
        this.resultSet.close();
    }

    @Test
    public void shouldReturnIsClosed() {
        Assert.assertThat((Object)this.resultSet.isClosed(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void shouldReturnRow() throws SQLException {
        Assert.assertThat((Object)this.resultSet.getRow(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldFindColumn() throws SQLException {
        Assert.assertThat((Object)this.resultSet.findColumn("propA"), (Matcher)Is.is((Object)1));
    }

    @Test
    public void shouldCallConcurrency() throws SQLException {
        Assert.assertThat((Object)this.resultSet.getConcurrency(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void shouldCallWasNull() throws SQLException {
        Assert.assertTrue((boolean)this.resultSet.wasNull());
        Assert.assertThat((Object)this.resultSet.next(), (Matcher)Is.is((Object)true));
        Assert.assertTrue((boolean)this.resultSet.wasNull());
        Assert.assertThat((Object)this.resultSet.getString("propA"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertFalse((boolean)this.resultSet.wasNull());
    }

    @Test
    public void shouldCallWasNullCallingGetObject() throws SQLException {
        Assert.assertTrue((boolean)this.resultSet.wasNull());
        Assert.assertThat((Object)this.resultSet.next(), (Matcher)Is.is((Object)true));
        Assert.assertTrue((boolean)this.resultSet.wasNull());
        Assert.assertThat((Object)this.resultSet.getObject("propA"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertFalse((boolean)this.resultSet.wasNull());
    }

    @Test
    public void shouldCallWasNullCallingGetBytes() throws SQLException {
        Assert.assertTrue((boolean)this.resultSet.wasNull());
        Assert.assertThat((Object)this.resultSet.next(), (Matcher)Is.is((Object)true));
        Assert.assertTrue((boolean)this.resultSet.wasNull());
        Assert.assertThat((Object)this.resultSet.getBytes("propA"), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertFalse((boolean)this.resultSet.wasNull());
    }

    @Test(expected=SQLException.class)
    public void shouldThrowExceptionForFetchDirectionNotForward() throws SQLException {
        this.resultSet.setFetchDirection(1001);
    }

    @Test(expected=SQLException.class)
    public void shouldThrowExceptionForBeforeFirst() throws SQLException {
        this.resultSet.beforeFirst();
    }

    @Test(expected=SQLException.class)
    public void shouldThrowExceptionForFirst() throws SQLException {
        Assert.assertThat((Object)this.resultSet.first(), (Matcher)Is.is((Object)false));
    }

    @Test(expected=SQLException.class)
    public void shouldThrowExceptionForLast() throws SQLException {
        Assert.assertThat((Object)this.resultSet.last(), (Matcher)Is.is((Object)false));
    }

    @Test(expected=SQLException.class)
    public void shouldThrowExceptionForAfterLast() throws SQLException {
        this.resultSet.afterLast();
    }

    @Test(expected=SQLException.class)
    public void shouldThrowExceptionForMoveToCurrentRow() throws SQLException {
        this.resultSet.moveToCurrentRow();
    }

    @Test(expected=SQLException.class)
    public void shouldThrowExceptionForAbsolute() throws SQLException {
        this.resultSet.absolute(1);
    }

    @Test(expected=SQLException.class)
    public void shouldThrowExceptionForRelative() throws SQLException {
        this.resultSet.relative(1);
    }

    @Test(expected=SQLException.class)
    public void shouldThrowExceptionForInsertRow() throws SQLException {
        this.resultSet.insertRow();
    }

    @Test(expected=SQLException.class)
    public void shouldThrowExceptionForDeleteRow() throws SQLException {
        this.resultSet.deleteRow();
    }

    @Test(expected=SQLException.class)
    public void shouldThrowExceptionForMoveToInsertRow() throws SQLException {
        this.resultSet.moveToInsertRow();
    }

    @Test(expected=SQLException.class)
    public void shouldThrowExceptionForInvalidColumnIndexPlus1() throws SQLException {
        Assert.assertThat((Object)this.resultSet.next(), (Matcher)Is.is((Object)true));
        this.resultSet.getString(TestUtil.COLUMN_NAMES.length + 1);
    }

    @Test(expected=SQLException.class)
    public void shouldThrowExceptionForInvalidColumnIndexMinus1() throws SQLException {
        Assert.assertThat((Object)this.resultSet.next(), (Matcher)Is.is((Object)true));
        this.resultSet.getString(-1);
    }

    @Test(expected=SQLException.class)
    public void shouldThrowExceptionResultSetIsForwardOnly() throws SQLException {
        this.resultSet.first();
    }

    @Test(expected=SQLException.class)
    public void shouldThrowExceptionInvalidColumn() throws SQLException {
        Assert.assertThat((Object)this.resultSet.next(), (Matcher)Is.is((Object)true));
        this.resultSet.getString("InvalidColumnName");
    }

    @Test(expected=SQLException.class)
    public void shouldThrowUpdatesNotSupported() throws SQLException {
        Assert.assertThat((Object)this.resultSet.next(), (Matcher)Is.is((Object)true));
        this.resultSet.insertRow();
    }

    @Test(expected=SQLException.class)
    public void shouldThrowExceptionResultSetIsClosed() throws SQLException {
        this.resultSet.close();
        this.resultSet.next();
    }

    @Test(expected=SQLException.class)
    public void shouldThrowExceptionIsClosedWhenGettingValue() throws SQLException {
        this.resultSet.close();
        this.resultSet.getString("propA");
    }

    @Test(expected=SQLException.class)
    public void shouldThrowExceptionIsClosedWhenGettingObject() throws SQLException {
        this.resultSet.close();
        this.resultSet.getObject("propA");
    }

    @Test(expected=SQLException.class)
    public void shouldThrowExceptionIsClosedWhenGettingBytes() throws SQLException {
        this.resultSet.close();
        this.resultSet.getBytes("propA");
    }

    @Test(expected=SQLException.class)
    public void shouldThrowExceptionIsRowSetWhenGettingValue() throws SQLException {
        this.resultSet.getString("propA");
    }

    @Test(expected=SQLException.class)
    public void shouldThrowExceptionIsRowSetWhenGettingObject() throws SQLException {
        this.resultSet.getObject("propA");
    }

    @Test(expected=SQLException.class)
    public void shouldThrowExceptionIsRowSetWhenGettingBytes() throws SQLException {
        this.resultSet.getBytes("propA");
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void featureNotSupportedCallingGetRowIDInt() throws SQLException {
        this.resultSet.getRowId(0);
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void featureNotSupportedCallingGetRowIDString() throws SQLException {
        this.resultSet.getRowId("columnname");
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void featureNotSupportedCallingGetCursorName() throws SQLException {
        this.resultSet.getCursorName();
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void featureNotSupportedCallingGetArrayIdx() throws SQLException {
        this.resultSet.getArray(1);
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void featureNotSupportedCallingGetArrayColName() throws SQLException {
        this.resultSet.getArray("colname");
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void featureNotSupportedCallingGetAsciiStreamIdx() throws SQLException {
        this.resultSet.getAsciiStream(1);
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void featureNotSupportedCallingGetAsciiStreamColName() throws SQLException {
        this.resultSet.getAsciiStream("colname");
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void featureNotSupportedCallingGetCharacterStreamIdx() throws SQLException {
        this.resultSet.getCharacterStream(1);
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void featureNotSupportedCallingGetCharacterStreamColName() throws SQLException {
        this.resultSet.getCharacterStream("colname");
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void featureNotSupportedCallingGetClobIdx() throws SQLException {
        this.resultSet.getClob(1);
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void featureNotSupportedCallingGetClobColName() throws SQLException {
        this.resultSet.getClob("colname");
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void featureNotSupportedCallingGetNCharacterStreamIdx() throws SQLException {
        this.resultSet.getNCharacterStream(1);
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void featureNotSupportedCallingGetNCharacterStreamColName() throws SQLException {
        this.resultSet.getNCharacterStream("colname");
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void featureNotSupportedCallingGetNClobIdx() throws SQLException {
        this.resultSet.getNClob(1);
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void featureNotSupportedCallingGetNClobColName() throws SQLException {
        this.resultSet.getNClob("colname");
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void featureNotSupportedCallingGetNStringIdx() throws SQLException {
        this.resultSet.getNString(1);
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void featureNotSupportedCallingGetNStringColName() throws SQLException {
        this.resultSet.getNString("colname");
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void featureNotSupportedCallingGetObjectIdxMap() throws SQLException {
        this.resultSet.getObject(1, (Map)null);
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void featureNotSupportedCallingGetObjectColNameMap() throws SQLException {
        this.resultSet.getObject("colname", (Map)null);
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void featureNotSupportedCallingGetObjectIdxClass() throws SQLException {
        this.resultSet.getObject(1, (Class)null);
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void featureNotSupportedCallingGetObjectColNameClass() throws SQLException {
        this.resultSet.getObject("colname", (Class)null);
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void featureNotSupportedCallingGetRefIdx() throws SQLException {
        this.resultSet.getRef(1);
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void featureNotSupportedCallingGetRefColName() throws SQLException {
        this.resultSet.getRef("colname");
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void featureNotSupportedCallingGetSQLXMLIdx() throws SQLException {
        this.resultSet.getSQLXML(1);
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void featureNotSupportedCallingGetSQLXMLColName() throws SQLException {
        this.resultSet.getSQLXML("colname");
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void featureNotSupportedCallingGetUnicodeStreamIdx() throws SQLException {
        this.resultSet.getUnicodeStream(1);
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void featureNotSupportedCallingGetUnicodeStreamColName() throws SQLException {
        this.resultSet.getUnicodeStream("colname");
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void featureNotSupportedCallingRowDeleted() throws SQLException {
        this.resultSet.rowDeleted();
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void featureNotSupportedCallingRowInserted() throws SQLException {
        this.resultSet.rowInserted();
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void featureNotSupportedCallingRowUpdated() throws SQLException {
        this.resultSet.rowUpdated();
    }

    @Test(expected=SQLFeatureNotSupportedException.class)
    public void featureNotSupportedCallingSetFetchDirectionForward() throws SQLException {
        this.resultSet.setFetchDirection(1000);
    }
}

