/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.junit.Assert;
import org.modeshape.jdbc.util.ResultSetReader;
import org.modeshape.jdbc.util.StringArrayReader;

public class ResultsComparator {
    protected static String DELIMITER = "    ";
    private ResultSetReader reader = null;
    public boolean compareColumns = true;

    public void assertResultsSetEquals(ResultSet resultSet, String expected) {
        Assert.assertNotNull((Object)resultSet);
        ResultSetReader reader = new ResultSetReader(resultSet, DELIMITER, this.compareColumns);
        this.assertReaderEquals(reader, new StringReader(expected));
    }

    public void assertResultsSetEquals(ResultSet resultSet, String[] expected) {
        Assert.assertNotNull((Object)resultSet);
        ResultSetReader reader = new ResultSetReader(resultSet, DELIMITER, this.compareColumns);
        this.assertReaderEquals(reader, new StringArrayReader(expected));
    }

    private void assertReaderEquals(Reader expected, Reader reader) {
        BufferedReader resultReader = new BufferedReader(expected);
        BufferedReader expectedReader = new BufferedReader(reader);
        try {
            this.compareResults(resultReader, expectedReader);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                resultReader.close();
                expectedReader.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String read(BufferedReader r, boolean casesensitive) throws IOException {
        StringBuffer result = new StringBuffer();
        String s = null;
        try {
            while ((s = r.readLine()) != null) {
                result.append(casesensitive ? s.trim() : s.trim().toLowerCase());
                result.append("\n");
            }
        }
        finally {
            r.close();
        }
        return result.toString();
    }

    protected void compareResults(BufferedReader resultReader, BufferedReader expectedReader) throws IOException {
        Assert.assertEquals((Object)this.read(expectedReader, this.compareCaseSensitive()), (Object)this.read(resultReader, this.compareCaseSensitive()));
    }

    protected boolean compareCaseSensitive() {
        return true;
    }

    public static void printResults(ResultSet results, boolean compareColumns) {
        Assert.assertNotNull((Object)results);
        if (results == null) {
            System.out.println("ResultSet is null");
            return;
        }
        try {
            BufferedReader in = new BufferedReader(new ResultSetReader(results, DELIMITER, compareColumns));
            String line = in.readLine();
            String nextline = null;
            System.out.println("String[] expected = {");
            while (line != null) {
                nextline = in.readLine();
                if (nextline != null) {
                    System.out.println("\"" + line + "\",");
                    line = nextline;
                    continue;
                }
                System.out.println("\"" + line + "\"");
                line = null;
            }
            System.out.println("};");
            in.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void assertRowCount(int expected) {
        if (this.reader != null) {
            Assert.assertEquals((long)expected, (long)this.reader.getRowCount());
        }
    }

    public int getRowCount(ResultSet results) {
        Assert.assertNotNull((Object)results);
        try {
            int count = 0;
            while (results.next()) {
                ++count;
            }
            return count;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void print(String msg) {
        System.out.println(msg);
    }

    public void print(Throwable e) {
        e.printStackTrace();
    }
}

