/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc;

import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import javax.jcr.Binary;
import javax.jcr.RepositoryException;

public class JcrBlob
implements Blob {
    private final Binary binary;

    public JcrBlob(Binary binary) {
        this.binary = binary;
        assert (this.binary != null);
    }

    @Override
    public void free() throws SQLException {
        this.binary.dispose();
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        try {
            return this.binary.getStream();
        }
        catch (RepositoryException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        try {
            byte[] data = new byte[length];
            int numRead = 0;
            try {
                numRead = this.binary.read(data, pos);
            }
            finally {
                this.binary.dispose();
            }
            if (numRead < length) {
                byte[] shortData = new byte[numRead];
                System.arraycopy(data, 0, shortData, 0, numRead);
                data = shortData;
            }
            return data;
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
    }

    @Override
    public long length() throws SQLException {
        try {
            return this.binary.getSize();
        }
        catch (RepositoryException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void truncate(long len) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }
}

