/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc.delegate;

import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.modeshape.jdbc.delegate.ConnectionInfo;
import org.modeshape.jdbc.delegate.LocalRepositoryDelegate;

public class LocalSession {
    private static LocalSession instance = new LocalSession();
    private ThreadLocal<LocalSession> tlocal = new ThreadLocal<LocalSession>(){

        @Override
        protected LocalSession initialValue() {
            LocalSession ls = new LocalSession();
            LocalRepositoryDelegate.TRANSACTION_IDS.add(ls);
            return ls;
        }
    };
    private Session session;

    public static LocalSession getLocalSessionInstance() {
        return instance;
    }

    private void setSession(Session localSession) {
        this.session = localSession;
    }

    public LocalSession getLocalSession() {
        return this.tlocal.get();
    }

    public LocalSession getLocalSession(Repository repository, ConnectionInfo connInfo) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        LocalSession lsession = this.tlocal.get();
        Credentials credentials = connInfo.getCredentials();
        String workspaceName = connInfo.getWorkspaceName();
        Session session = null;
        if (workspaceName != null) {
            session = credentials != null ? repository.login(credentials, workspaceName) : repository.login(workspaceName);
        } else {
            Session session2 = session = credentials != null ? repository.login(credentials) : repository.login();
        }
        assert (session != null);
        lsession.setSession(session);
        return lsession;
    }

    public Session getSession() {
        return this.session;
    }

    public void remove() {
        this.tlocal.remove();
        LocalRepositoryDelegate.TRANSACTION_IDS.remove(this);
        this.session.logout();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Session:");
        sb.append(this.session.toString());
        return sb.toString();
    }
}

