/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.modeshape.jdbc.JcrStatement;
import org.modeshape.jdbc.util.ResultsComparator;

public class ConnectionResultsComparator
extends ResultsComparator {
    protected Connection internalConnection = null;
    protected ResultSet internalResultSet = null;
    protected Statement internalStatement = null;
    private SQLException internalException = null;
    protected int updateCount = -1;

    protected ConnectionResultsComparator() {
    }

    private ConnectionResultsComparator(Connection conn) {
        this.internalConnection = conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeTest(Connection conn, String sql, String expected, int expectedRowCount, String jcrSQL) throws SQLException {
        ConnectionResultsComparator util = new ConnectionResultsComparator(conn);
        try {
            util.execute(sql, jcrSQL);
            util.assertResultsSetEquals(util.internalResultSet, expected);
            util.assertRowCount(expectedRowCount);
        }
        finally {
            util.closeResultSet();
            util.closeStatement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeTest(Connection conn, String sql, int expectedRowCount, String jcrSQL) throws SQLException {
        ConnectionResultsComparator util = new ConnectionResultsComparator(conn);
        try {
            util.execute(sql, jcrSQL);
            util.assertRowCount(expectedRowCount);
        }
        finally {
            util.closeResultSet();
            util.closeStatement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeTest(Connection conn, String sql, String[] expected, int expectedRowCount, String jcrSQL) throws SQLException {
        AssertionError lastError = null;
        for (int i = 0; i != 10; ++i) {
            ConnectionResultsComparator util = new ConnectionResultsComparator(conn);
            try {
                util.execute(sql, jcrSQL);
                util.assertResultsSetEquals(util.internalResultSet, expected);
                util.assertRowCount(expectedRowCount);
                return;
            }
            catch (AssertionError e) {
                lastError = e;
                try {
                    Thread.sleep(500L);
                    continue;
                }
                catch (InterruptedException ie) {
                    Assert.fail((String)"Interrupted");
                    return;
                }
            }
            finally {
                util.closeResultSet();
                util.closeStatement();
            }
        }
        if (lastError != null) {
            throw lastError;
        }
    }

    public static void executeTest(Connection conn, String sql, String expected, int expectedRowCount) throws SQLException {
        ConnectionResultsComparator.executeTest(conn, sql, expected, expectedRowCount, "JCR-SQL2");
    }

    public static void executeTest(Connection conn, String sql, String[] expected, int expectedRowCount) throws SQLException {
        ConnectionResultsComparator.executeTest(conn, sql, expected, expectedRowCount, "JCR-SQL2");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeTestAndPrint(Connection conn, String sql, String jcrSQL) throws SQLException {
        ConnectionResultsComparator util = new ConnectionResultsComparator(conn);
        try {
            util.execute(sql, jcrSQL);
            util.printResults();
        }
        finally {
            util.closeResultSet();
            util.closeStatement();
        }
    }

    public static void executeTestAndPrint(Connection conn, String sql) throws SQLException {
        ConnectionResultsComparator.executeTestAndPrint(conn, sql, "JCR-SQL2");
    }

    private boolean execute(String sql, String jcrSQL) throws SQLException {
        return this.execute(sql, new Object[0], jcrSQL);
    }

    private boolean execute(String sql, Object[] params, String jcrSQL) throws SQLException {
        this.updateCount = -1;
        Assert.assertNotNull((Object)this.internalConnection);
        Assert.assertTrue((!this.internalConnection.isClosed() ? 1 : 0) != 0);
        boolean result = false;
        this.internalStatement = this.createStatement();
        if (this.internalStatement instanceof JcrStatement) {
            ((JcrStatement)this.internalStatement).setJcrSqlLanguage(jcrSQL);
        }
        result = this.internalStatement.execute(sql);
        Assert.assertTrue((boolean)result);
        this.internalResultSet = this.internalStatement.getResultSet();
        Assert.assertThat((Object)this.internalResultSet, (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)this.internalResultSet.isBeforeFirst(), (Matcher)Is.is((Object)true));
        Assert.assertThat((Object)this.internalResultSet.isClosed(), (Matcher)Is.is((Object)false));
        return result;
    }

    protected Statement createStatement() throws SQLException {
        return this.internalConnection.createStatement();
    }

    public boolean exceptionOccurred() {
        return this.internalException != null;
    }

    public boolean exceptionExpected() {
        return false;
    }

    public SQLException getLastException() {
        return this.internalException;
    }

    public void printResults() {
        Assert.assertNotNull((Object)this.internalResultSet);
        ConnectionResultsComparator.printResults(this.internalResultSet, this.compareColumns);
    }

    public void assertUpdateCount(int expected) {
        Assert.assertEquals((long)expected, (long)this.updateCount);
    }

    public int getRowCount() {
        Assert.assertNotNull((Object)this.internalResultSet);
        return super.getRowCount(this.internalResultSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeStatement() {
        this.closeResultSet();
        if (this.internalStatement != null) {
            try {
                this.internalStatement.close();
            }
            catch (SQLException sQLException) {
            }
            finally {
                this.internalStatement = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeResultSet() {
        this.internalException = null;
        if (this.internalResultSet != null) {
            try {
                this.internalResultSet.close();
            }
            catch (SQLException sQLException) {
            }
            finally {
                this.internalResultSet = null;
            }
        }
    }

    public void cancelQuery() throws SQLException {
        Assert.assertNotNull((Object)this.internalConnection);
        Assert.assertTrue((!this.internalConnection.isClosed() ? 1 : 0) != 0);
        Assert.assertNotNull((Object)this.internalStatement);
        this.internalStatement.cancel();
    }
}

