/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Binary;
import javax.jcr.ItemNotFoundException;
import javax.jcr.PathNotFoundException;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.modeshape.common.util.IoUtil;
import org.modeshape.jdbc.JcrBlob;
import org.modeshape.jdbc.JcrResultSetMetaData;
import org.modeshape.jdbc.JcrStatement;
import org.modeshape.jdbc.JcrType;
import org.modeshape.jdbc.JdbcLocalI18n;
import org.modeshape.jdbc.util.TimestampWithTimezone;

public class JcrResultSet
implements ResultSet {
    private boolean closed;
    private JcrStatement statement;
    private QueryResult jcrResults;
    private ResultSetMetaData metadata;
    private RowIterator rowIter;
    private Row row;
    private Object currentValue = null;
    private Map<String, Integer> columnIndexesByName;
    private String[] columnIDs = null;

    protected JcrResultSet(JcrStatement statement, QueryResult jcrResults, ResultSetMetaData resultSetMetaData) throws SQLException {
        this.statement = statement;
        this.jcrResults = jcrResults;
        assert (this.statement != null);
        assert (this.jcrResults != null);
        this.metadata = resultSetMetaData != null ? resultSetMetaData : new JcrResultSetMetaData(this.statement.connection(), this.jcrResults);
        int colCnt = this.metadata.getColumnCount();
        this.columnIDs = new String[colCnt + 1];
        this.columnIndexesByName = new HashMap<String, Integer>(colCnt);
        for (int index = 1; index <= colCnt; ++index) {
            String name = this.metadata.getColumnName(index);
            this.columnIndexesByName.put(name, index);
            this.columnIDs[index] = name;
        }
        this.columnIndexesByName = Collections.unmodifiableMap(this.columnIndexesByName);
        try {
            this.rowIter = this.jcrResults.getRows();
        }
        catch (RepositoryException e) {
            throw new SQLException(e.getLocalizedMessage(), e);
        }
    }

    protected JcrResultSet() {
        this.closed = true;
        this.columnIndexesByName = Collections.emptyMap();
    }

    @Override
    public boolean isClosed() {
        return this.closed || this.statement.isClosed();
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.statement.close();
        }
    }

    byte[] convertToByteArray(Value value) throws SQLException {
        if (value == null) {
            return null;
        }
        InputStream is = null;
        boolean error = false;
        try {
            switch (value.getType()) {
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 12: {
                    String v = value.getString();
                    byte[] byArray = v != null ? v.getBytes() : null;
                    return byArray;
                }
                case 2: {
                    is = value.getBinary().getStream();
                    byte[] byArray = IoUtil.readBytes((InputStream)is);
                    return byArray;
                }
            }
            byte[] byArray = null;
            return byArray;
        }
        catch (IOException ioe) {
            error = true;
            throw new SQLException(ioe.getLocalizedMessage(), ioe);
        }
        catch (IllegalStateException ie) {
            error = true;
            throw new SQLException(ie.getLocalizedMessage(), ie);
        }
        catch (RepositoryException e) {
            error = true;
            throw new SQLException(e.getLocalizedMessage(), e);
        }
        finally {
            block23: {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (Exception e) {
                    if (error) break block23;
                    throw new SQLException(e.getLocalizedMessage(), e);
                }
            }
        }
    }

    protected final void notClosed() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException(JdbcLocalI18n.resultSetIsClosed.text(new Object[0]));
        }
    }

    protected final void noUpdates() throws SQLException {
        throw new SQLFeatureNotSupportedException(JdbcLocalI18n.updatesNotSupported.text(new Object[0]));
    }

    protected final void forwardOnly() throws SQLException {
        throw new SQLException(JdbcLocalI18n.resultSetIsForwardOnly.text(new Object[0]));
    }

    protected final void itemNotFoundUsingColunName(String columnName) throws SQLException {
        throw new SQLException(JdbcLocalI18n.noSuchColumn.text(new Object[]{columnName}));
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.notClosed();
        return this.metadata;
    }

    @Override
    public Statement getStatement() throws SQLException {
        this.notClosed();
        return this.statement;
    }

    @Override
    public int getType() throws SQLException {
        this.notClosed();
        return 1003;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.notClosed();
        return 1000;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.notClosed();
        this.forwardOnly();
        return false;
    }

    @Override
    public void afterLast() throws SQLException {
        this.notClosed();
        this.forwardOnly();
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.notClosed();
        this.forwardOnly();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.notClosed();
    }

    @Override
    public void deleteRow() throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        Integer result;
        this.notClosed();
        Integer n = result = columnLabel != null ? this.columnIndexesByName.get(columnLabel) : null;
        if (result == null) {
            this.itemNotFoundUsingColunName(columnLabel);
        }
        assert (result != null);
        return result;
    }

    private String findColumn(int columnIndex) throws SQLException {
        if (columnIndex > 0 && columnIndex < this.columnIDs.length) {
            return this.columnIDs[columnIndex];
        }
        throw new SQLException(JdbcLocalI18n.invalidColumnIndex.text(new Object[]{columnIndex, this.columnIDs.length}));
    }

    @Override
    public boolean first() throws SQLException {
        this.notClosed();
        this.forwardOnly();
        return false;
    }

    @Override
    public int getRow() throws SQLException {
        this.notClosed();
        return (int)this.rowIter.getPosition();
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.notClosed();
        return this.statement.getFetchSize();
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnIndex));
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        Object o = this.updateCurrentValueFromColumn(columnLabel, 12);
        if (o != null) {
            return (BigDecimal)o;
        }
        return null;
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return this.getBigDecimal(columnIndex).setScale(scale);
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        return this.getBigDecimal(columnLabel).setScale(scale);
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnIndex));
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        Object o = this.updateCurrentValueFromColumn(columnLabel, 2);
        if (o != null) {
            try {
                return ((Binary)o).getStream();
            }
            catch (RepositoryException e) {
                throw new SQLException(e);
            }
        }
        return null;
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        return this.getBlob(this.findColumn(columnIndex));
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        Object o = this.updateCurrentValueFromColumn(columnLabel, 2);
        if (o != null) {
            return new JcrBlob((Binary)o);
        }
        return null;
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        return this.getBoolean(this.findColumn(columnIndex));
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        Object o = this.updateCurrentValueFromColumn(columnLabel, 6);
        if (o != null) {
            return (Boolean)o;
        }
        return false;
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        return this.getByte(this.findColumn(columnIndex));
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        return Long.valueOf(this.getLong(columnLabel)).byteValue();
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        return this.getBytes(this.findColumn(columnIndex));
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        this.notClosed();
        this.isRowSet();
        this.currentValue = null;
        try {
            Value value = this.row.getValue(columnLabel);
            byte[] rtnbytes = this.convertToByteArray(value);
            this.currentValue = rtnbytes;
            return rtnbytes;
        }
        catch (PathNotFoundException value) {
        }
        catch (ItemNotFoundException e) {
            this.itemNotFoundUsingColunName(columnLabel);
        }
        catch (RepositoryException e) {
            throw new SQLException(e.getLocalizedMessage(), e);
        }
        return null;
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.notClosed();
        return 0;
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return this.getDate(this.findColumn(columnIndex));
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        Calendar calv = (Calendar)this.updateCurrentValueFromColumn(columnLabel, 5);
        if (calv == null) {
            return null;
        }
        return TimestampWithTimezone.createDate(calv);
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnIndex), cal);
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        Calendar actual = (Calendar)this.updateCurrentValueFromColumn(columnLabel, 5);
        if (actual == null) {
            return null;
        }
        return TimestampWithTimezone.createDate(actual, cal);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        return this.getDouble(this.findColumn(columnIndex));
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        Object o = this.updateCurrentValueFromColumn(columnLabel, 4);
        if (o != null) {
            return (Double)o;
        }
        return 0.0;
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        return this.getFloat(this.findColumn(columnIndex));
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return Double.valueOf(this.getDouble(columnLabel)).floatValue();
    }

    @Override
    public int getHoldability() throws SQLException {
        this.notClosed();
        return 0;
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        return this.getInt(this.findColumn(columnIndex));
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        this.notClosed();
        return (int)this.getLong(columnLabel);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        return this.getLong(this.findColumn(columnIndex));
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        Object o = this.updateCurrentValueFromColumn(columnLabel, 3);
        if (o != null) {
            return (Long)o;
        }
        return 0L;
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        return this.getObject(this.findColumn(columnIndex));
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getColumnTranslatedToJDBC(columnLabel);
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        return this.getShort(this.findColumn(columnIndex));
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return Long.valueOf(this.getLong(columnLabel)).shortValue();
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        return this.getString(this.findColumn(columnIndex));
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        Object o = this.updateCurrentValueFromColumn(columnLabel, 1);
        if (o != null) {
            return (String)o;
        }
        return null;
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return this.getTime(this.findColumn(columnIndex));
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        Calendar calv = (Calendar)this.updateCurrentValueFromColumn(columnLabel, 5);
        if (calv == null) {
            return null;
        }
        return TimestampWithTimezone.createTime(calv);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnIndex), cal);
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        Calendar actual = (Calendar)this.updateCurrentValueFromColumn(columnLabel, 5);
        if (actual == null) {
            return null;
        }
        return TimestampWithTimezone.createTime(actual, cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.getTimestamp(this.findColumn(columnIndex));
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        Calendar calv = (Calendar)this.updateCurrentValueFromColumn(columnLabel, 5);
        if (calv == null) {
            return null;
        }
        return TimestampWithTimezone.createTimestamp(calv);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnIndex), cal);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        Calendar actual = (Calendar)this.updateCurrentValueFromColumn(columnLabel, 5);
        if (actual == null) {
            return null;
        }
        return TimestampWithTimezone.createTimestamp(actual, cal);
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        return this.getURL(this.findColumn(columnIndex));
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        try {
            return new URL(this.getString(columnLabel));
        }
        catch (MalformedURLException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public Value getValue(int columnIndex) throws SQLException {
        return this.getValue(this.findColumn(columnIndex));
    }

    public Value getValue(String columnLabel) throws SQLException {
        this.notClosed();
        this.isRowSet();
        try {
            return this.row.getValue(columnLabel);
        }
        catch (PathNotFoundException pnfe) {
            return null;
        }
        catch (RepositoryException e) {
            throw new SQLException(e.getLocalizedMessage(), e);
        }
    }

    private Object updateCurrentValueFromColumn(String columnName, int asType) throws SQLException {
        this.notClosed();
        this.isRowSet();
        this.currentValue = null;
        try {
            Value jcrValue = this.row.getValue(columnName);
            this.currentValue = this.extractValue(jcrValue, asType);
        }
        catch (PathNotFoundException jcrValue) {
        }
        catch (ItemNotFoundException e) {
            this.itemNotFoundUsingColunName(columnName);
        }
        catch (RepositoryException e) {
            throw new SQLException(e.getLocalizedMessage(), e);
        }
        return this.currentValue;
    }

    private Object extractValue(Value jcrValue, int asType) throws SQLException {
        if (jcrValue == null) {
            return null;
        }
        try {
            switch (asType) {
                case 1: {
                    return jcrValue.getString();
                }
                case 6: {
                    return jcrValue.getBoolean();
                }
                case 5: {
                    return jcrValue.getDate();
                }
                case 4: {
                    return jcrValue.getDouble();
                }
                case 3: {
                    return jcrValue.getLong();
                }
                case 12: {
                    return jcrValue.getDecimal();
                }
                case 2: {
                    if (jcrValue.getType() != 2) {
                        throw new SQLException(JdbcLocalI18n.cannotConvertJcrValue.text(new Object[]{PropertyType.nameFromValue((int)jcrValue.getType()), "Binary"}));
                    }
                    return jcrValue.getBinary();
                }
            }
            return jcrValue.getString();
        }
        catch (ValueFormatException ve) {
            throw new SQLException(JdbcLocalI18n.cannotConvertJcrValue.text(new Object[]{PropertyType.nameFromValue((int)jcrValue.getType()), PropertyType.nameFromValue((int)asType)}), ve);
        }
        catch (IllegalArgumentException ie) {
            throw new SQLException(JdbcLocalI18n.cannotConvertJcrValue.text(new Object[]{PropertyType.nameFromValue((int)jcrValue.getType()), PropertyType.nameFromValue((int)asType)}), ie);
        }
        catch (RepositoryException e) {
            throw new SQLException(e);
        }
    }

    private Object getColumnTranslatedToJDBC(String columnName) throws SQLException {
        this.notClosed();
        this.isRowSet();
        Value value = null;
        this.currentValue = null;
        try {
            value = this.row.getValue(columnName);
        }
        catch (PathNotFoundException pathNotFoundException) {
        }
        catch (RepositoryException e) {
            throw new SQLException(e.getLocalizedMessage(), e);
        }
        if (value == null) {
            return null;
        }
        this.currentValue = JcrType.translateValueToJDBC(value);
        return this.currentValue;
    }

    @Override
    public SQLWarning getWarnings() {
        return null;
    }

    protected boolean hasNext() {
        return this.rowIter.hasNext();
    }

    @Override
    public void insertRow() throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.notClosed();
        return this.row == null && !this.rowIter.hasNext() && this.rowIter.getPosition() == this.rowIter.getSize();
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.notClosed();
        return this.rowIter.getPosition() == 0L;
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.notClosed();
        return this.rowIter.getPosition() == 1L;
    }

    @Override
    public boolean isLast() throws SQLException {
        this.notClosed();
        return this.row != null && !this.rowIter.hasNext() && this.rowIter.getPosition() == this.rowIter.getSize();
    }

    protected final void isRowSet() throws SQLException {
        if (this.row != null) {
            return;
        }
        throw new SQLException(JdbcLocalI18n.currentRowNotSet.text(new Object[0]));
    }

    @Override
    public boolean last() throws SQLException {
        this.notClosed();
        this.forwardOnly();
        return false;
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.notClosed();
        this.forwardOnly();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.noUpdates();
    }

    @Override
    public boolean next() throws SQLException {
        this.notClosed();
        if (!this.hasNext()) {
            this.row = null;
            this.currentValue = null;
            return false;
        }
        this.row = this.rowIter.nextRow();
        return true;
    }

    @Override
    public boolean previous() throws SQLException {
        this.notClosed();
        this.forwardOnly();
        return false;
    }

    @Override
    public void refreshRow() throws SQLException {
        this.notClosed();
        this.forwardOnly();
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setFetchSize(int rows) {
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateNClob(int columnIndex, NClob clob) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateNClob(String columnLabel, NClob clob) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateNString(int columnIndex, String string) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateNString(String columnLabel, String string) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateRow() throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        this.notClosed();
        this.noUpdates();
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.notClosed();
        return this.currentValue == null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return iface.cast(this);
        }
        throw new SQLException(JdbcLocalI18n.classDoesNotImplementInterface.text(new Object[0]));
    }
}

