/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.query.QueryResult;
import org.modeshape.jdbc.JcrConnection;
import org.modeshape.jdbc.JcrType;
import org.modeshape.jdbc.JdbcI18n;

public class JcrResultSetMetaData
implements ResultSetMetaData {
    private final JcrConnection connection;
    private final QueryResult results;
    private int[] nullable;

    protected JcrResultSetMetaData(JcrConnection connection, QueryResult results) {
        this.connection = connection;
        this.results = results;
    }

    @Override
    public String getCatalogName(int column) {
        return this.connection.info().getRepositoryName();
    }

    @Override
    public String getColumnClassName(int column) {
        JcrType typeInfo = JcrType.typeInfo(this.getColumnTypeName(column));
        return typeInfo != null ? typeInfo.getRepresentationClass().getName() : String.class.getName();
    }

    @Override
    public int getColumnCount() throws SQLException {
        try {
            return this.results.getColumnNames().length;
        }
        catch (RepositoryException e) {
            throw new SQLException(e.getLocalizedMessage(), e);
        }
    }

    @Override
    public int getColumnDisplaySize(int column) {
        return JcrType.typeInfo(this.getColumnTypeName(column)).getNominalDisplaySize();
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        try {
            return this.results.getColumnNames()[column - 1];
        }
        catch (RepositoryException e) {
            throw new SQLException(e.getLocalizedMessage(), e);
        }
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.getColumnLabel(column);
    }

    @Override
    public int getColumnType(int column) {
        JcrType typeInfo = JcrType.typeInfo(this.getColumnTypeName(column));
        return typeInfo != null ? typeInfo.getJdbcType() : 12;
    }

    @Override
    public String getColumnTypeName(int column) {
        if (this.results instanceof org.modeshape.jcr.api.query.QueryResult) {
            return ((org.modeshape.jcr.api.query.QueryResult)this.results).getColumnTypes()[column - 1];
        }
        return PropertyType.nameFromValue((int)1);
    }

    @Override
    public int getPrecision(int column) {
        JcrType typeInfo = JcrType.typeInfo(this.getColumnTypeName(column));
        return typeInfo.getNominalDisplaySize();
    }

    @Override
    public int getScale(int column) {
        JcrType typeInfo = JcrType.typeInfo(this.getColumnTypeName(column));
        if (typeInfo.getJcrType() == 4) {
            return 3;
        }
        return 0;
    }

    @Override
    public String getSchemaName(int column) {
        return this.connection.info().getWorkspaceName();
    }

    @Override
    public String getTableName(int column) throws SQLException {
        try {
            return this.results.getSelectorNames()[column - 1];
        }
        catch (RepositoryException e) {
            throw new SQLException(e.getLocalizedMessage(), e);
        }
    }

    @Override
    public boolean isAutoIncrement(int column) {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) {
        JcrType typeInfo = JcrType.typeInfo(this.getColumnTypeName(column));
        return typeInfo.isCaseSensitive();
    }

    @Override
    public boolean isCurrency(int column) {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) {
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        String nodeTypeName;
        if (this.nullable == null) {
            int length = this.getColumnCount();
            this.nullable = new int[length];
            for (int i = 0; i != length; ++i) {
                this.nullable[i] = -1;
            }
        } else {
            int result = this.nullable[column - 1];
            if (result != -1) {
                return result;
            }
        }
        if ((nodeTypeName = this.getTableName(column)).length() == 0) {
            return 2;
        }
        String propertyName = this.getColumnName(column);
        boolean singleProp = false;
        boolean singleResidual = false;
        boolean multiResidual = false;
        NodeType type = this.connection.nodeType(nodeTypeName);
        for (PropertyDefinition defn : type.getPropertyDefinitions()) {
            if (defn.getName().equals(propertyName)) {
                if (defn.isMultiple() || defn.isMandatory()) {
                    return 1;
                }
                singleProp = true;
                continue;
            }
            if (!defn.getName().equals("*")) continue;
            if (defn.isMultiple() || defn.isMandatory()) {
                multiResidual = true;
                continue;
            }
            singleResidual = true;
        }
        int result = 2;
        if (multiResidual) {
            result = 1;
        } else if (singleProp || singleResidual) {
            result = 0;
        }
        this.nullable[column - 1] = result;
        return result;
    }

    @Override
    public boolean isReadOnly(int column) {
        return true;
    }

    @Override
    public boolean isSearchable(int column) {
        return true;
    }

    @Override
    public boolean isSigned(int column) {
        JcrType typeInfo = JcrType.typeInfo(this.getColumnTypeName(column));
        return typeInfo.isSigned();
    }

    @Override
    public boolean isWritable(int column) {
        return false;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isInstance(this.results);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this.results)) {
            return iface.cast(this.results);
        }
        throw new SQLException(JdbcI18n.classDoesNotImplementInterface.text(ResultSetMetaData.class.getSimpleName(), iface.getName()));
    }
}

