/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc.delegate;

import java.io.File;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import org.modeshape.jcr.JcrConfiguration;
import org.modeshape.jcr.JcrEngine;
import org.modeshape.jdbc.JcrConnection;
import org.modeshape.jdbc.JcrMetaData;
import org.modeshape.jdbc.JdbcI18n;
import org.modeshape.jdbc.ModeShapeMetaData;
import org.modeshape.jdbc.delegate.ConnectionInfo;
import org.modeshape.jdbc.delegate.RepositoryDelegate;
import org.modeshape.jdbc.util.StringUtil;
import org.modeshape.jdbc.util.TextDecoder;
import org.modeshape.jdbc.util.UrlEncoder;

public class FileRepositoryDelegate
implements RepositoryDelegate {
    private static final String FILE_EXAMPLE_URL = "jdbc:jcr:file://file.path";
    public static final TextDecoder URL_DECODER = new UrlEncoder();
    private QueryResult jcrResults;
    private Query jcrQuery;
    private FileConnectionInfo connInfo = null;
    private Session session;
    private Repository repository = null;
    private Set<String> repositoryNames = null;

    public FileRepositoryDelegate(String url, Properties info) {
        this.connInfo = new FileConnectionInfo(url, info);
    }

    protected Session session() throws RepositoryException {
        if (this.session == null) {
            this.session = this.repository.login();
            assert (this.session != null);
        }
        return this.session;
    }

    @Override
    public NodeType nodeType(String name) throws RepositoryException {
        return this.session().getWorkspace().getNodeTypeManager().getNodeType(name);
    }

    @Override
    public List<NodeType> nodeTypes() throws RepositoryException {
        ArrayList<NodeType> types = new ArrayList<NodeType>();
        NodeTypeIterator its = this.session().getWorkspace().getNodeTypeManager().getAllNodeTypes();
        while (its.hasNext()) {
            types.add((NodeType)its.next());
        }
        return types;
    }

    @Override
    public QueryResult execute(String query, String language) throws RepositoryException {
        this.jcrQuery = null;
        this.jcrResults = null;
        this.jcrQuery = this.session().getWorkspace().getQueryManager().createQuery(query, language);
        this.jcrResults = this.jcrQuery.execute();
        return this.jcrResults;
    }

    @Override
    public Connection createConnection() throws SQLException {
        try {
            String filename = this.connInfo.getFileName();
            if (filename == null) {
                String msg = JdbcI18n.unableToGetJndiContext.text(this.connInfo.getEffectiveUrl());
                throw new SQLException(msg);
            }
            File f = new File(filename);
            JcrConfiguration jcrConfig = new JcrConfiguration().loadFrom(f);
            JcrEngine eng = jcrConfig.build();
            eng.start();
            String repositoryName = (String)eng.getRepositoryNames().iterator().next();
            this.repository = eng.getRepository(repositoryName);
            this.connInfo.setRepositoryName(repositoryName);
            this.repositoryNames = new HashSet<String>(1);
            this.repositoryNames.add(repositoryName);
            assert (this.repository != null);
        }
        catch (Throwable e) {
            throw new SQLException(e.getMessage(), e);
        }
        return new JcrConnection(this.repository, this.connInfo, this);
    }

    @Override
    public ConnectionInfo getConnectionInfo() {
        return this.connInfo;
    }

    @Override
    public void commit() throws RepositoryException {
        if (this.session != null) {
            this.session.save();
        }
    }

    @Override
    public void rollback() throws RepositoryException {
        if (this.session != null) {
            this.session.refresh(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            if (this.session != null) {
                this.session.logout();
            }
        }
        finally {
            this.session = null;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isInstance(this) || iface.isInstance(Repository.class) || iface.isInstance(Session.class) || iface.isInstance(Workspace.class);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return iface.cast(this);
        }
        if (iface.isInstance(Session.class)) {
            return iface.cast(this.session);
        }
        if (iface.isInstance(this.repository)) {
            return iface.cast(this.repository);
        }
        if (iface.isInstance(Workspace.class)) {
            Workspace workspace = this.session.getWorkspace();
            return iface.cast(workspace);
        }
        throw new SQLException(JdbcI18n.classDoesNotImplementInterface.text(Connection.class.getSimpleName(), iface.getName()));
    }

    @Override
    public boolean isValid(int timeout) throws RepositoryException {
        this.session().getRootNode();
        return true;
    }

    @Override
    public Set<String> getRepositoryNames() {
        return this.repositoryNames;
    }

    @Override
    public DatabaseMetaData createMetaData(JcrConnection connection) throws RepositoryException {
        Session localSession = this.session();
        if (localSession.getRepository().getDescriptor("jcr.repository.name") != null && localSession.getRepository().getDescriptor("jcr.repository.name").toLowerCase().contains("modeshape")) {
            return new ModeShapeMetaData(connection, localSession);
        }
        return new JcrMetaData(connection, localSession);
    }

    protected class FileConnectionInfo
    extends ConnectionInfo {
        private String fileName;

        protected FileConnectionInfo(String url, Properties properties) {
            super(url, properties);
            this.init();
        }

        protected String getFileName() {
            return this.fileName;
        }

        private void init() {
            Properties props = this.getProperties() != null ? (Properties)this.getProperties().clone() : new Properties();
            this.fileName = this.getUrl().substring("jdbc:jcr:file:".length());
            int questionMarkIndex = this.fileName.indexOf(63);
            if (questionMarkIndex != -1) {
                if (this.fileName.length() > questionMarkIndex + 1) {
                    String paramStr = this.fileName.substring(questionMarkIndex + 1);
                    for (String param : paramStr.split("&")) {
                        String[] pair = param.split("=");
                        if (pair.length <= 1) continue;
                        String key = URL_DECODER.decode(pair[0] != null ? pair[0].trim() : null);
                        String value = URL_DECODER.decode(pair[1] != null ? pair[1].trim() : null);
                        if (props.containsKey(key)) continue;
                        props.put(key, value);
                    }
                }
                this.fileName = this.fileName.substring(0, questionMarkIndex).trim();
            }
            Properties newprops = new Properties(props);
            this.setProperties(newprops);
            String url = this.getUrl();
            this.setUrl(url != null ? url.trim() : null);
        }

        @Override
        public String getEffectiveUrl() {
            StringBuilder url = new StringBuilder("jdbc:jcr:file:");
            url.append(this.fileName);
            int propertyDelim = 63;
            for (String propertyName : this.getProperties().stringPropertyNames()) {
                String value = this.getProperties().getProperty(propertyName);
                if (value == null) continue;
                if ("password".equals(propertyName)) {
                    value = StringUtil.createString('*', value.length());
                }
                url.append((char)propertyDelim).append(propertyName).append('=').append(value);
                propertyDelim = 38;
            }
            return url.toString();
        }

        @Override
        public DriverPropertyInfo[] getPropertyInfos() {
            DriverPropertyInfo info;
            ArrayList<DriverPropertyInfo> results = new ArrayList<DriverPropertyInfo>();
            if (this.getUrl() == null) {
                info = new DriverPropertyInfo(JdbcI18n.urlPropertyName.text(new Object[0]), null);
                info.description = JdbcI18n.urlPropertyDescription.text(FileRepositoryDelegate.FILE_EXAMPLE_URL);
                info.required = true;
                info.choices = new String[]{FileRepositoryDelegate.FILE_EXAMPLE_URL};
                results.add(info);
            }
            if (this.getUsername() == null) {
                info = new DriverPropertyInfo(JdbcI18n.usernamePropertyName.text(new Object[0]), null);
                info.description = JdbcI18n.usernamePropertyDescription.text(new Object[0]);
                info.required = false;
                info.choices = null;
                results.add(info);
            }
            if (this.getPassword() == null) {
                info = new DriverPropertyInfo(JdbcI18n.passwordPropertyName.text(new Object[0]), null);
                info.description = JdbcI18n.passwordPropertyDescription.text(new Object[0]);
                info.required = false;
                info.choices = null;
                results.add(info);
            }
            if (this.getWorkspaceName() == null) {
                info = new DriverPropertyInfo(JdbcI18n.workspaceNamePropertyName.text(new Object[0]), null);
                info.description = JdbcI18n.workspaceNamePropertyDescription.text(new Object[0]);
                info.required = false;
                info.choices = null;
                results.add(info);
            }
            return results.toArray(new DriverPropertyInfo[results.size()]);
        }
    }
}

