/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc.delegate;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.modeshape.jcr.api.Repositories;
import org.modeshape.jdbc.JcrConnection;
import org.modeshape.jdbc.JcrDriver;
import org.modeshape.jdbc.JcrMetaData;
import org.modeshape.jdbc.JdbcI18n;
import org.modeshape.jdbc.ModeShapeMetaData;
import org.modeshape.jdbc.delegate.ConnectionInfo;
import org.modeshape.jdbc.delegate.RepositoryDelegate;
import org.modeshape.jdbc.util.StringUtil;
import org.modeshape.jdbc.util.TextDecoder;
import org.modeshape.jdbc.util.UrlEncoder;

public class LocalRepositoryDelegate
implements RepositoryDelegate {
    private static final String JNDI_EXAMPLE_URL = "jdbc:jcr:jndi:{jndiName}";
    public static final TextDecoder URL_DECODER = new UrlEncoder();
    private JcrDriver.JcrContextFactory jcrContext = null;
    private QueryResult jcrResults;
    private Query jcrQuery;
    private JNDIConnectionInfo connInfo = null;
    private Session session;
    private Repository repository = null;
    private Set<String> repositoryNames = null;

    public LocalRepositoryDelegate(String url, Properties info, JcrDriver.JcrContextFactory contextFactory) {
        this.jcrContext = contextFactory == null ? new JcrDriver.JcrContextFactory(){

            @Override
            public Context createContext(Properties properties) throws NamingException {
                InitialContext initContext = properties == null || properties.isEmpty() ? new InitialContext() : new InitialContext(properties);
                return initContext;
            }
        } : contextFactory;
        this.connInfo = new JNDIConnectionInfo(url, info);
    }

    protected Session session() throws RepositoryException {
        if (this.session == null) {
            Credentials credentials = this.connInfo.getCredentials();
            String workspaceName = this.connInfo.getWorkspaceName();
            if (workspaceName != null) {
                this.session = credentials != null ? this.repository.login(credentials, workspaceName) : this.repository.login(workspaceName);
            } else {
                Session session = this.session = credentials != null ? this.repository.login(credentials) : this.repository.login();
            }
            assert (this.session != null);
        }
        return this.session;
    }

    @Override
    public NodeType nodeType(String name) throws RepositoryException {
        return this.session().getWorkspace().getNodeTypeManager().getNodeType(name);
    }

    @Override
    public List<NodeType> nodeTypes() throws RepositoryException {
        ArrayList<NodeType> types = new ArrayList<NodeType>();
        NodeTypeIterator its = this.session().getWorkspace().getNodeTypeManager().getAllNodeTypes();
        while (its.hasNext()) {
            types.add((NodeType)its.next());
        }
        return types;
    }

    @Override
    public QueryResult execute(String query, String language) throws RepositoryException {
        this.jcrQuery = null;
        this.jcrResults = null;
        this.jcrQuery = this.session().getWorkspace().getQueryManager().createQuery(query, language);
        this.jcrResults = this.jcrQuery.execute();
        return this.jcrResults;
    }

    @Override
    public Connection createConnection() throws SQLException {
        String jndiName = this.connInfo.getJndiName();
        if (jndiName == null) {
            String msg = JdbcI18n.urlMustContainJndiNameOfRepositoryOrRepositoriesObject.text(new Object[0]);
            throw new SQLException(msg);
        }
        Context context = null;
        try {
            context = this.jcrContext.createContext(this.connInfo.getProperties());
        }
        catch (NamingException e) {
            throw new SQLException(JdbcI18n.unableToGetJndiContext.text(e.getLocalizedMessage()));
        }
        if (context == null) {
            throw new SQLException(JdbcI18n.unableToFindObjectInJndi.text(jndiName));
        }
        this.repository = null;
        try {
            Object target = context.lookup(jndiName);
            String repositoryName = this.connInfo.getRepositoryName();
            if (target instanceof Repositories) {
                Repositories repositories = (Repositories)target;
                if (repositoryName == null) {
                    this.repositoryNames = repositories.getRepositoryNames();
                    if (this.repositoryNames == null || this.repositoryNames.isEmpty()) {
                        throw new SQLException(JdbcI18n.noRepositoryNamesFound.text(new Object[0]));
                    }
                    if (this.repositoryNames != null && this.repositoryNames.size() == 1) {
                        String repoName = this.repositoryNames.iterator().next();
                        if (repositoryName == null) {
                            repositoryName = repoName;
                            this.connInfo.setRepositoryName(repositoryName);
                        } else if (!repositoryName.equals(repoName)) {
                            throw new SQLException(JdbcI18n.unableToFindNamedRepository.text(jndiName, repositoryName));
                        }
                    } else {
                        throw new SQLException(JdbcI18n.objectInJndiIsRepositories.text(jndiName));
                    }
                }
                try {
                    this.repository = repositories.getRepository(repositoryName);
                }
                catch (RepositoryException e) {
                    throw new SQLException(JdbcI18n.unableToFindNamedRepository.text(jndiName, repositoryName));
                }
            } else if (target instanceof Repository) {
                this.repository = (Repository)target;
                this.repositoryNames = new HashSet<String>(1);
                if (repositoryName == null) {
                    repositoryName = "DefaultRepository";
                    this.connInfo.setRepositoryName(repositoryName);
                }
                this.repositoryNames.add(repositoryName);
            } else {
                throw new SQLException(JdbcI18n.objectInJndiMustBeRepositoryOrRepositories.text(jndiName));
            }
            assert (this.repository != null);
        }
        catch (NamingException e) {
            throw new SQLException(JdbcI18n.unableToFindObjectInJndi.text(jndiName), e);
        }
        return new JcrConnection(this.repository, this.connInfo, this);
    }

    @Override
    public ConnectionInfo getConnectionInfo() {
        return this.connInfo;
    }

    @Override
    public void commit() throws RepositoryException {
        if (this.session != null) {
            this.session.save();
        }
    }

    @Override
    public void rollback() throws RepositoryException {
        if (this.session != null) {
            this.session.refresh(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            if (this.session != null) {
                this.session.logout();
            }
        }
        finally {
            this.session = null;
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isInstance(this) || iface.isInstance(Repository.class) || iface.isInstance(Session.class) || iface.isInstance(Workspace.class);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return iface.cast(this);
        }
        if (iface.isInstance(Session.class)) {
            return iface.cast(this.session);
        }
        if (iface.isInstance(this.repository)) {
            return iface.cast(this.repository);
        }
        if (iface.isInstance(Workspace.class)) {
            Workspace workspace = this.session.getWorkspace();
            return iface.cast(workspace);
        }
        throw new SQLException(JdbcI18n.classDoesNotImplementInterface.text(Connection.class.getSimpleName(), iface.getName()));
    }

    @Override
    public boolean isValid(int timeout) throws RepositoryException {
        this.session().getRootNode();
        return true;
    }

    @Override
    public Set<String> getRepositoryNames() {
        return this.repositoryNames;
    }

    @Override
    public DatabaseMetaData createMetaData(JcrConnection connection) throws RepositoryException {
        Session localSession = this.session();
        if (localSession.getRepository().getDescriptor("jcr.repository.name") != null && localSession.getRepository().getDescriptor("jcr.repository.name").toLowerCase().contains("modeshape")) {
            return new ModeShapeMetaData(connection, localSession);
        }
        return new JcrMetaData(connection, localSession);
    }

    protected class JNDIConnectionInfo
    extends ConnectionInfo {
        private String jndiName;

        protected JNDIConnectionInfo(String url, Properties properties) {
            super(url, properties);
            this.init();
        }

        protected String getJndiName() {
            return this.jndiName;
        }

        private void init() {
            Properties props = this.getProperties() != null ? (Properties)this.getProperties().clone() : new Properties();
            this.jndiName = this.getUrl().substring("jdbc:jcr:jndi:".length());
            int questionMarkIndex = this.jndiName.indexOf(63);
            if (questionMarkIndex != -1) {
                if (this.jndiName.length() > questionMarkIndex + 1) {
                    String paramStr = this.jndiName.substring(questionMarkIndex + 1);
                    for (String param : paramStr.split("&")) {
                        String[] pair = param.split("=");
                        if (pair.length <= 1) continue;
                        String key = URL_DECODER.decode(pair[0] != null ? pair[0].trim() : null);
                        String value = URL_DECODER.decode(pair[1] != null ? pair[1].trim() : null);
                        if (props.containsKey(key)) continue;
                        props.put(key, value);
                    }
                }
                this.jndiName = this.jndiName.substring(0, questionMarkIndex).trim();
            }
            Properties newprops = new Properties(props);
            this.setProperties(newprops);
            String url = this.getUrl();
            this.setUrl(url != null ? url.trim() : null);
        }

        @Override
        public String getEffectiveUrl() {
            StringBuilder url = new StringBuilder("jdbc:jcr:jndi:");
            url.append(this.jndiName);
            int propertyDelim = 63;
            for (String propertyName : this.getProperties().stringPropertyNames()) {
                String value = this.getProperties().getProperty(propertyName);
                if (value == null) continue;
                if ("password".equals(propertyName)) {
                    value = StringUtil.createString('*', value.length());
                }
                url.append((char)propertyDelim).append(propertyName).append('=').append(value);
                propertyDelim = 38;
            }
            return url.toString();
        }

        @Override
        public DriverPropertyInfo[] getPropertyInfos() {
            DriverPropertyInfo info;
            JcrDriver.JcrContextFactory cf = LocalRepositoryDelegate.this.jcrContext;
            ArrayList<DriverPropertyInfo> results = new ArrayList<DriverPropertyInfo>();
            if (this.getUrl() == null) {
                info = new DriverPropertyInfo(JdbcI18n.urlPropertyName.text(new Object[0]), null);
                info.description = JdbcI18n.urlPropertyDescription.text(LocalRepositoryDelegate.JNDI_EXAMPLE_URL);
                info.required = true;
                info.choices = new String[]{LocalRepositoryDelegate.JNDI_EXAMPLE_URL};
                results.add(info);
                cf = null;
            }
            if (this.getUsername() == null) {
                info = new DriverPropertyInfo(JdbcI18n.usernamePropertyName.text(new Object[0]), null);
                info.description = JdbcI18n.usernamePropertyDescription.text(new Object[0]);
                info.required = false;
                info.choices = null;
                results.add(info);
            }
            if (this.getPassword() == null) {
                info = new DriverPropertyInfo(JdbcI18n.passwordPropertyName.text(new Object[0]), null);
                info.description = JdbcI18n.passwordPropertyDescription.text(new Object[0]);
                info.required = false;
                info.choices = null;
                results.add(info);
            }
            boolean nameRequired = false;
            if (this.getRepositoryName() == null) {
                boolean found = false;
                if (cf != null) {
                    try {
                        Context context = cf.createContext(this.getProperties());
                        Object obj = context.lookup(((JNDIConnectionInfo)LocalRepositoryDelegate.this.getConnectionInfo()).getJndiName());
                        if (obj instanceof Repositories) {
                            nameRequired = true;
                            found = true;
                        } else if (obj instanceof Repository) {
                            found = true;
                        }
                    }
                    catch (NamingException e) {
                        // empty catch block
                    }
                }
                if (nameRequired || !found) {
                    DriverPropertyInfo info2 = new DriverPropertyInfo(JdbcI18n.repositoryNamePropertyName.text(new Object[0]), null);
                    info2.description = JdbcI18n.repositoryNamePropertyDescription.text(new Object[0]);
                    info2.required = nameRequired;
                    info2.choices = null;
                    results.add(info2);
                }
            }
            if (this.getWorkspaceName() == null) {
                DriverPropertyInfo info3 = new DriverPropertyInfo(JdbcI18n.workspaceNamePropertyName.text(new Object[0]), null);
                info3.description = JdbcI18n.workspaceNamePropertyDescription.text(new Object[0]);
                info3.required = false;
                info3.choices = null;
                results.add(info3);
            }
            return results.toArray(new DriverPropertyInfo[results.size()]);
        }
    }
}

