/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc.metadata;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.List;
import javax.jcr.NodeIterator;
import javax.jcr.query.QueryResult;
import javax.jcr.query.RowIterator;
import org.modeshape.jdbc.metadata.QueryResultRowIterator;

public class MetaDataQueryResult
implements QueryResult {
    private ResultSetMetaData rsmd;
    private String[] columnNames = null;
    private List<List<?>> tuplesArray = null;

    public static MetaDataQueryResult createResultSet(List<List<?>> records, ResultSetMetaData resultSetMetaData) {
        MetaDataQueryResult mdqr = new MetaDataQueryResult(records, resultSetMetaData);
        return mdqr;
    }

    MetaDataQueryResult(List<List<?>> tuples, ResultSetMetaData rsmd) {
        this.rsmd = rsmd;
        this.tuplesArray = tuples;
        this.getColumnNames();
    }

    public String[] getColumnNames() {
        if (this.columnNames != null) {
            return this.columnNames;
        }
        try {
            this.columnNames = new String[this.rsmd.getColumnCount()];
            for (int col = 0; col < this.columnNames.length; ++col) {
                this.columnNames[col] = this.rsmd.getColumnName(col + 1);
            }
            return this.columnNames;
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
            return null;
        }
    }

    public NodeIterator getNodes() {
        throw new UnsupportedOperationException();
    }

    public RowIterator getRows() {
        QueryResultRowIterator ri = new QueryResultRowIterator(this.tuplesArray, this.columnNames);
        return ri;
    }

    public String[] getColumnTypes() {
        String[] columnTypes = new String[this.columnNames.length];
        for (int i = 0; i <= this.columnNames.length; ++i) {
            try {
                columnTypes[i] = this.rsmd.getColumnTypeName(i + 1);
                continue;
            }
            catch (SQLException e) {
                columnTypes[i] = "NotFound";
            }
        }
        return columnTypes;
    }

    public String[] getSelectorNames() {
        throw new UnsupportedOperationException();
    }
}

