/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.NamingException;
import org.modeshape.jdbc.JdbcI18n;
import org.modeshape.jdbc.delegate.ConnectionInfo;
import org.modeshape.jdbc.delegate.RepositoryDelegateFactory;
import org.modeshape.jdbc.util.Collections;

public class JcrDriver
implements Driver {
    protected static Logger logger = Logger.getLogger("org.modeshape.jdbc");
    public static final String WORKSPACE_PROPERTY_NAME = "workspace";
    public static final String REPOSITORY_PROPERTY_NAME = "repositoryName";
    public static final String USERNAME_PROPERTY_NAME = "user";
    public static final String PASSWORD_PROPERTY_NAME = "password";
    protected static final Set<String> ALL_PROPERTY_NAMES = Collections.unmodifiableSet("workspace", "repositoryName", "user", "password");
    public static final String JNDI_URL_PREFIX = "jdbc:jcr:jndi:";
    public static final String HTTP_URL_PREFIX = "jdbc:jcr:http://";
    private static DriverMetadata driverMetadata;
    public JcrContextFactory contextFactory = null;
    private static JcrDriver INSTANCE;

    public static JcrDriver getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean acceptsURL(String url) {
        return RepositoryDelegateFactory.acceptUrl(url);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return RepositoryDelegateFactory.createRepositoryDelegate(url, info, this.contextFactory).getConnectionInfo().getPropertyInfos();
    }

    protected ConnectionInfo createConnectionInfo(String url, Properties info) throws SQLException {
        return RepositoryDelegateFactory.createRepositoryDelegate(url, info, this.contextFactory).getConnectionInfo();
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        return RepositoryDelegateFactory.createRepositoryDelegate(url, info, this.contextFactory).createConnection();
    }

    @Override
    public int getMajorVersion() {
        return JcrDriver.getDriverMetadata().getMajorVersion();
    }

    @Override
    public int getMinorVersion() {
        return JcrDriver.getDriverMetadata().getMinorVersion();
    }

    public String getVendorName() {
        return JcrDriver.getDriverMetadata().getVendorName();
    }

    public String getVendorUrl() {
        return JcrDriver.getDriverMetadata().getVendorUrl();
    }

    public String getVersion() {
        return JcrDriver.getDriverMetadata().getVersion();
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    static DriverMetadata getDriverMetadata() {
        if (driverMetadata == null) {
            driverMetadata = new DriverMetadata();
        }
        return driverMetadata;
    }

    void setContextFactory(JcrContextFactory factory) {
        assert (factory != null);
        this.contextFactory = factory;
    }

    static {
        INSTANCE = new JcrDriver();
        try {
            DriverManager.registerDriver(INSTANCE);
        }
        catch (SQLException e) {
            String logMsg = JdbcI18n.driverErrorRegistering.text(e.getMessage());
            logger.log(Level.SEVERE, logMsg);
        }
    }

    public static interface JcrContextFactory {
        public Context createContext(Properties var1) throws NamingException;
    }

    static class DriverMetadata {
        private final int major;
        private final int minor;

        protected DriverMetadata() {
            String[] coords = this.getVersion().split("[.-]");
            this.major = Integer.parseInt(coords[0]);
            this.minor = Integer.parseInt(coords[1]);
        }

        public String getVendorName() {
            return JdbcI18n.driverVendor.text(new Object[0]);
        }

        public String getVendorUrl() {
            return JdbcI18n.driverVendorUrl.text(new Object[0]);
        }

        public String getVersion() {
            return JdbcI18n.driverVersion.text(new Object[0]);
        }

        public int getMajorVersion() {
            return this.major;
        }

        public int getMinorVersion() {
            return this.minor;
        }

        public String getName() {
            return JdbcI18n.driverName.text(new Object[0]);
        }
    }
}

