/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.modeshape.jdbc.JcrConnection;
import org.modeshape.jdbc.JcrDriver;
import org.modeshape.jdbc.JcrResultSet;
import org.modeshape.jdbc.JcrStatement;
import org.modeshape.jdbc.JcrType;
import org.modeshape.jdbc.JdbcI18n;
import org.modeshape.jdbc.metadata.MetaDataQueryResult;
import org.modeshape.jdbc.metadata.MetadataProvider;
import org.modeshape.jdbc.metadata.ResultSetMetaDataImpl;
import org.modeshape.jdbc.metadata.ResultsMetadataConstants;

public class JcrMetaData
implements DatabaseMetaData {
    protected static final String WILDCARD = "%";
    protected static final Integer DEFAULT_ZERO = new Integer(0);
    protected static final int NO_LIMIT = 0;
    private JcrConnection connection;
    private String catalogName;

    public JcrMetaData(JcrConnection connection) {
        this.connection = connection;
        assert (this.connection != null);
        this.catalogName = connection.getCatalog();
        assert (this.catalogName != null);
    }

    @Override
    public int getDriverMajorVersion() {
        return JcrDriver.getDriverMetadata().getMajorVersion();
    }

    @Override
    public int getDriverMinorVersion() {
        return JcrDriver.getDriverMetadata().getMinorVersion();
    }

    @Override
    public String getDriverName() {
        return JcrDriver.getDriverMetadata().getName();
    }

    @Override
    public String getDriverVersion() {
        return JcrDriver.getDriverMetadata().getVersion();
    }

    @Override
    public int getDatabaseMajorVersion() {
        return Integer.parseInt(this.getDatabaseProductVersion().split("[.-]")[0]);
    }

    @Override
    public int getDatabaseMinorVersion() {
        return Integer.parseInt(this.getDatabaseProductVersion().split("[.-]")[1]);
    }

    @Override
    public String getDatabaseProductName() {
        return this.connection.getRepositoryDelegate().getDescriptor("jcr.repository.name");
    }

    public String getDatabaseProductUrl() {
        return this.connection.getRepositoryDelegate().getDescriptor("jcr.repository.vendor.url");
    }

    @Override
    public String getDatabaseProductVersion() {
        return this.connection.getRepositoryDelegate().getDescriptor("jcr.repository.version");
    }

    @Override
    public int getJDBCMajorVersion() {
        return 2;
    }

    @Override
    public int getJDBCMinorVersion() {
        return 0;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        return false;
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return false;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        return false;
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        return null;
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        return null;
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return null;
    }

    @Override
    public String getCatalogTerm() {
        return "Repository";
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        ArrayList records = new ArrayList(1);
        List<String> row = Arrays.asList(this.catalogName);
        records.add(row);
        Map[] metadataList = new Map[]{MetadataProvider.getColumnMetadata(this.catalogName, null, "TABLE_CAT", "String", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.connection)};
        MetadataProvider provider = new MetadataProvider(metadataList);
        ResultSetMetaDataImpl resultSetMetaData = new ResultSetMetaDataImpl(provider);
        JcrStatement stmt = new JcrStatement(this.connection);
        MetaDataQueryResult queryresult = MetaDataQueryResult.createResultSet(records, resultSetMetaData);
        JcrResultSet rs = new JcrResultSet(stmt, queryresult, resultSetMetaData);
        return rs;
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        return null;
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        return null;
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        JcrDriver.logger.log(Level.FINE, "getcolumns: " + catalog + ":" + schemaPattern + ":" + tableNamePattern + ":" + columnNamePattern);
        if (tableNamePattern == null) {
            tableNamePattern = WILDCARD;
        }
        Map[] metadataList = new Map[]{MetadataProvider.getColumnMetadata(this.catalogName, null, "TABLE_CAT", "String", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "TABLE_SCHEM", "String", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "TABLE_NAME", "String", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "COLUMN_NAME", "String", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "DATA_TYPE", "Long", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "TYPE_NAME", "String", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "COLUMN_SIZE", "Long", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "BUFFER_LENGTH", "Long", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "DECIMAL_DIGITS", "Long", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "NUM_PREC_RADIX", "Long", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "NULLABLE", "Long", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "REMARKS", "String", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "COLUMN_DEF", "String", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "SQL_DATA_TYPE", "Long", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "SQL_DATETIME_SUB", "Long", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "CHAR_OCTET_LENGTH", "Long", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "ORDINAL_POSITION", "Long", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "IS_NULLABLE", "String", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "SCOPE_CATLOG", "String", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "SCOPE_SCHEMA", "String", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "SCOPE_TABLE", "String", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "SOURCE_DATA_TYPE", "Long", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.connection)};
        MetadataProvider provider = new MetadataProvider(metadataList);
        ResultSetMetaDataImpl resultSetMetaData = new ResultSetMetaDataImpl(provider);
        ArrayList records = new ArrayList();
        try {
            List<NodeType> nodetypes = this.filterNodeTypes(tableNamePattern);
            for (NodeType type : nodetypes) {
                if (type.getPropertyDefinitions() == null) {
                    throw new SQLException("Program Error:  missing propertydefintions for " + type.getName());
                }
                List<PropertyDefinition> defns = this.filterPropertyDefnitions(columnNamePattern, type.getPropertyDefinitions());
                int ordinal = 0;
                for (PropertyDefinition propDefn : defns) {
                    ArrayList<Object> currentRow = new ArrayList<Object>(22);
                    JcrType jcrtype = JcrType.typeInfo(propDefn.getRequiredType());
                    currentRow.add(this.catalogName);
                    currentRow.add("NULL");
                    currentRow.add(type.getName());
                    currentRow.add(propDefn.getName());
                    currentRow.add(jcrtype.getJdbcType());
                    currentRow.add(jcrtype.getJcrName());
                    currentRow.add(jcrtype.getNominalDisplaySize());
                    currentRow.add("NULL");
                    currentRow.add(DEFAULT_ZERO);
                    currentRow.add(DEFAULT_ZERO);
                    currentRow.add(propDefn.isMandatory() ? ResultsMetadataConstants.NULL_TYPES.NOT_NULL : ResultsMetadataConstants.NULL_TYPES.NULLABLE);
                    currentRow.add("");
                    currentRow.add("NULL");
                    currentRow.add(DEFAULT_ZERO);
                    currentRow.add(DEFAULT_ZERO);
                    currentRow.add(DEFAULT_ZERO);
                    currentRow.add(new Integer(ordinal + 1));
                    currentRow.add(propDefn.isMandatory() ? "NO" : "YES");
                    currentRow.add("NULL");
                    currentRow.add("NULL");
                    currentRow.add("NULL");
                    currentRow.add(DEFAULT_ZERO);
                    records.add(currentRow);
                    ++ordinal;
                }
            }
            JcrStatement jcrstmt = new JcrStatement(this.connection);
            MetaDataQueryResult queryresult = MetaDataQueryResult.createResultSet(records, resultSetMetaData);
            return new JcrResultSet(jcrstmt, queryresult, resultSetMetaData);
        }
        catch (RepositoryException e) {
            throw new SQLException(e.getLocalizedMessage());
        }
    }

    @Override
    public ResultSet getCrossReference(String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        return null;
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        return null;
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        return null;
    }

    @Override
    public ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String columnNamePattern) throws SQLException {
        return null;
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        return null;
    }

    @Override
    public String getIdentifierQuoteString() {
        return "'";
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        return null;
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        return null;
    }

    @Override
    public int getMaxBinaryLiteralLength() {
        return 0;
    }

    @Override
    public int getMaxCatalogNameLength() {
        return 0;
    }

    @Override
    public int getMaxCharLiteralLength() {
        return 0;
    }

    @Override
    public int getMaxColumnNameLength() {
        return 0;
    }

    @Override
    public int getMaxColumnsInGroupBy() {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() {
        return 0;
    }

    @Override
    public int getMaxColumnsInOrderBy() {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() {
        return 0;
    }

    @Override
    public int getMaxConnections() {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() {
        return 0;
    }

    @Override
    public int getMaxIndexLength() {
        return 0;
    }

    @Override
    public int getMaxProcedureNameLength() {
        return 0;
    }

    @Override
    public int getMaxRowSize() {
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() {
        return 0;
    }

    @Override
    public int getMaxStatementLength() {
        return 0;
    }

    @Override
    public int getMaxStatements() {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() {
        return 0;
    }

    @Override
    public int getMaxTablesInSelect() {
        return 0;
    }

    @Override
    public int getMaxUserNameLength() {
        return 0;
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return null;
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        return null;
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        return null;
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return null;
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        return null;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 0;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() {
        return RowIdLifetime.ROWID_UNSUPPORTED;
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        return null;
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return 0;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return " ";
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        ArrayList records = new ArrayList(1);
        Map[] metadataList = new Map[]{MetadataProvider.getColumnMetadata(this.catalogName, null, "TABLE_SCHEM", "String", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.connection)};
        MetadataProvider provider = new MetadataProvider(metadataList);
        ResultSetMetaDataImpl resultSetMetaData = new ResultSetMetaDataImpl(provider);
        JcrStatement stmt = new JcrStatement(this.connection);
        MetaDataQueryResult queryresult = MetaDataQueryResult.createResultSet(records, resultSetMetaData);
        JcrResultSet rs = new JcrResultSet(stmt, queryresult, resultSetMetaData);
        return rs;
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        return this.getSchemas();
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return null;
    }

    @Override
    public String getStringFunctions() throws SQLException {
        return null;
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return null;
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        return null;
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return null;
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        return null;
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        ArrayList records = new ArrayList(1);
        List<String> row = Arrays.asList("VIEW");
        records.add(row);
        Map[] metadataList = new Map[]{MetadataProvider.getColumnMetadata(this.catalogName, null, "TABLE_TYPE", "String", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.connection)};
        MetadataProvider provider = new MetadataProvider(metadataList);
        ResultSetMetaDataImpl resultSetMetaData = new ResultSetMetaDataImpl(provider);
        JcrStatement stmt = new JcrStatement(this.connection);
        MetaDataQueryResult queryresult = MetaDataQueryResult.createResultSet(records, resultSetMetaData);
        JcrResultSet rs = new JcrResultSet(stmt, queryresult, resultSetMetaData);
        return rs;
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        JcrDriver.logger.log(Level.FINE, "getTables: " + catalog + ":" + schemaPattern + ":" + tableNamePattern + ":" + types);
        if (tableNamePattern == null) {
            tableNamePattern = WILDCARD;
        }
        Map[] metadataList = new Map[]{MetadataProvider.getColumnMetadata(this.catalogName, null, "TABLE_CAT", "String", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "TABLE_SCHEM", "String", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "TABLE_NAME", "String", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "TABLE_TYPE", "String", ResultsMetadataConstants.NULL_TYPES.NOT_NULL, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "REMARKS", "String", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "TYPE_CAT", "String", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "TYPE_SCHEM", "String", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "TYPE_NAME", "String", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "SELF_REFERENCING_COL_NAME", "String", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.connection), MetadataProvider.getColumnMetadata(this.catalogName, null, "REF_GENERATION", "String", ResultsMetadataConstants.NULL_TYPES.NULLABLE, this.connection)};
        MetadataProvider provider = new MetadataProvider(metadataList);
        ResultSetMetaDataImpl resultSetMetaData = new ResultSetMetaDataImpl(provider);
        ArrayList records = new ArrayList();
        try {
            List<NodeType> nodetypes = this.filterNodeTypes(tableNamePattern);
            for (NodeType type : nodetypes) {
                if (!type.isQueryable()) continue;
                ArrayList<String> currentRow = new ArrayList<String>(10);
                currentRow.add(this.catalogName);
                currentRow.add("NULL");
                currentRow.add(type.getName());
                currentRow.add("VIEW");
                currentRow.add("Is Mixin: " + type.isMixin());
                currentRow.add("NULL");
                currentRow.add("NULL");
                currentRow.add("NULL");
                currentRow.add(type.getPrimaryItemName());
                currentRow.add("DERIVED");
                records.add(currentRow);
            }
            JcrStatement jcrstmt = new JcrStatement(this.connection);
            MetaDataQueryResult queryresult = MetaDataQueryResult.createResultSet(records, resultSetMetaData);
            return new JcrResultSet(jcrstmt, queryresult, resultSetMetaData);
        }
        catch (RepositoryException e) {
            throw new SQLException(e.getLocalizedMessage());
        }
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        return null;
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        return null;
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        return null;
    }

    @Override
    public String getURL() {
        return this.connection.info().getEffectiveUrl();
    }

    @Override
    public String getUserName() {
        return this.connection.info().getUsername();
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        return null;
    }

    @Override
    public boolean insertsAreDetected(int type) {
        return false;
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        return true;
    }

    @Override
    public boolean locatorsUpdateCopy() {
        return false;
    }

    @Override
    public boolean nullPlusNonNullIsNull() {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtEnd() {
        return false;
    }

    @Override
    public boolean nullsAreSortedAtStart() {
        return false;
    }

    @Override
    public boolean nullsAreSortedHigh() {
        return false;
    }

    @Override
    public boolean nullsAreSortedLow() {
        return true;
    }

    @Override
    public boolean othersDeletesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean othersInsertsAreVisible(int type) {
        return false;
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean ownDeletesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean ownInsertsAreVisible(int type) {
        return false;
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) {
        return false;
    }

    @Override
    public boolean storesLowerCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean storesMixedCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean storesUpperCaseIdentifiers() {
        return false;
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() {
        return false;
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() {
        return false;
    }

    @Override
    public boolean supportsANSI92FullSQL() {
        return false;
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() {
        return false;
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() {
        return false;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() {
        return false;
    }

    @Override
    public boolean supportsColumnAliasing() {
        return false;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsFullOuterJoins() {
        return false;
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOuterJoins() {
        return true;
    }

    @Override
    public boolean supportsPositionedDelete() {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() {
        return false;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSavepoints() {
        return false;
    }

    @Override
    public boolean supportsSchemasInDataManipulation() {
        return false;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() {
        return false;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() {
        return false;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() {
        return false;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() {
        return false;
    }

    @Override
    public boolean supportsSelectForUpdate() {
        return false;
    }

    @Override
    public boolean supportsStatementPooling() {
        return false;
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() {
        return false;
    }

    @Override
    public boolean supportsStoredProcedures() {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInExists() {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInIns() {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() {
        return false;
    }

    @Override
    public boolean supportsTableCorrelationNames() {
        return true;
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) {
        return level == 2;
    }

    @Override
    public boolean supportsTransactions() {
        return false;
    }

    @Override
    public boolean supportsUnion() {
        return false;
    }

    @Override
    public boolean supportsUnionAll() {
        return false;
    }

    @Override
    public boolean updatesAreDetected(int type) {
        return false;
    }

    @Override
    public boolean usesLocalFilePerTable() {
        return false;
    }

    @Override
    public boolean usesLocalFiles() {
        return false;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!this.isWrapperFor(iface)) {
            throw new SQLException(JdbcI18n.classDoesNotImplementInterface.text(DatabaseMetaData.class.getSimpleName(), iface.getName()));
        }
        return iface.cast(this);
    }

    private List<NodeType> filterNodeTypes(String tableNamePattern) throws RepositoryException {
        List<NodeType> nodetypes = null;
        if (tableNamePattern.trim().equals(WILDCARD)) {
            nodetypes = this.connection.getRepositoryDelegate().nodeTypes();
        } else if (tableNamePattern.contains(WILDCARD)) {
            nodetypes = new ArrayList<NodeType>();
            String partName = null;
            boolean isLeading = false;
            boolean isTrailing = false;
            partName = tableNamePattern;
            if (partName.startsWith(WILDCARD)) {
                partName = partName.substring(1);
                isLeading = true;
            }
            if (partName.endsWith(WILDCARD) && partName.length() > 1) {
                partName = partName.substring(0, partName.length() - 1);
                isTrailing = true;
            }
            List<NodeType> nts = this.connection.getRepositoryDelegate().nodeTypes();
            for (NodeType type : nts) {
                if (isLeading) {
                    if (isTrailing) {
                        if (type.getName().indexOf(partName, 1) <= -1) continue;
                        nodetypes.add(type);
                        continue;
                    }
                    if (!type.getName().endsWith(partName)) continue;
                    nodetypes.add(type);
                    continue;
                }
                if (!isTrailing || !type.getName().startsWith(partName)) continue;
                nodetypes.add(type);
            }
        } else {
            NodeType nt = this.connection.getRepositoryDelegate().nodeType(tableNamePattern);
            if (nt != null) {
                nodetypes = new ArrayList<NodeType>(1);
                nodetypes.add(nt);
            }
        }
        if (nodetypes.size() > 1) {
            Comparator<NodeType> name_order = new Comparator<NodeType>(){

                @Override
                public int compare(NodeType e1, NodeType e2) {
                    return e1.getName().compareTo(e2.getName());
                }
            };
            Collections.sort(nodetypes, name_order);
        }
        return nodetypes;
    }

    private List<PropertyDefinition> filterPropertyDefnitions(String columnNamePattern, PropertyDefinition[] defns) {
        List<Object> resultDefns = new ArrayList(defns.length);
        if (columnNamePattern.trim().equals(WILDCARD)) {
            resultDefns = Arrays.asList(defns);
        } else if (columnNamePattern.contains(WILDCARD)) {
            String partName = null;
            boolean isLeading = false;
            boolean isTrailing = false;
            partName = columnNamePattern;
            if (partName.startsWith(WILDCARD)) {
                partName = partName.substring(1);
                isLeading = true;
            }
            if (partName.endsWith(WILDCARD) && partName.length() > 1) {
                partName = partName.substring(0, partName.length() - 1);
                isTrailing = true;
            }
            for (int i = 0; i < defns.length; ++i) {
                PropertyDefinition defn = defns[i];
                if (isLeading) {
                    if (isTrailing) {
                        if (defn.getName().indexOf(partName, 1) <= -1) continue;
                        resultDefns.add(defn);
                        continue;
                    }
                    if (!defn.getName().endsWith(partName)) continue;
                    resultDefns.add(defn);
                    continue;
                }
                if (!isTrailing || !defn.getName().startsWith(partName)) continue;
                resultDefns.add(defn);
            }
        } else {
            for (int i = 0; i < defns.length; ++i) {
                PropertyDefinition defn = defns[i];
                if (!defn.getName().equals(columnNamePattern)) continue;
                resultDefns.add(defn);
            }
        }
        if (resultDefns.size() > 1) {
            Comparator<PropertyDefinition> name_order = new Comparator<PropertyDefinition>(){

                @Override
                public int compare(PropertyDefinition e1, PropertyDefinition e2) {
                    return e1.getName().compareTo(e2.getName());
                }
            };
            Collections.sort(resultDefns, name_order);
        }
        return resultDefns;
    }
}

