/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest.client.domain;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import net.jcip.annotations.Immutable;
import org.modeshape.common.util.HashCode;
import org.modeshape.web.jcr.rest.client.RestClientI18n;
import org.modeshape.web.jcr.rest.client.domain.IModeShapeObject;
import org.modeshape.web.jcr.rest.client.domain.Workspace;

@Immutable
public class NodeType
implements IModeShapeObject {
    private final String name;
    private final Workspace workspace;
    private Properties properties = null;
    private NodeType parentNodeType = null;
    private List<NodeType> childrenNodeType = null;
    private List<NodeType> propertyDefinitons = null;
    private List<NodeType> childNodeDefinitons = null;

    public NodeType(String name, Workspace workspace, Properties properties) {
        assert (name != null);
        assert (workspace != null);
        this.name = name;
        this.workspace = workspace;
        this.properties = properties == null ? new Properties() : properties;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        NodeType otherNodeType = (NodeType)obj;
        return this.name.equals(otherNodeType.name) && this.workspace.equals(otherNodeType.workspace);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public List<NodeType> getChildren() {
        return this.childrenNodeType != null ? this.childrenNodeType : Collections.emptyList();
    }

    public void addChildNodeType(NodeType childNodeType) {
        if (this.childrenNodeType == null) {
            this.childrenNodeType = new ArrayList<NodeType>();
        }
        this.childrenNodeType.add(childNodeType);
        childNodeType.setParentNodeType(this);
    }

    public void addPropertyDefinitionNodeType(NodeType propertyDefinitionNodeType) {
        if (this.propertyDefinitons == null) {
            this.propertyDefinitons = new ArrayList<NodeType>();
        }
        this.propertyDefinitons.add(propertyDefinitionNodeType);
        propertyDefinitionNodeType.setParentNodeType(this);
    }

    public void addChildNodeDefinitionNodeType(NodeType childNodeDefinitionNodeType) {
        if (this.childNodeDefinitons == null) {
            this.childNodeDefinitons = new ArrayList<NodeType>();
        }
        this.childNodeDefinitons.add(childNodeDefinitionNodeType);
        childNodeDefinitionNodeType.setParentNodeType(this);
    }

    public List<NodeType> getPropertyDefinitions() {
        return this.propertyDefinitons != null ? this.propertyDefinitons : Collections.emptyList();
    }

    public List<NodeType> getChildNodeDefinitions() {
        return this.childNodeDefinitons != null ? this.childNodeDefinitons : Collections.emptyList();
    }

    public NodeType getParentNodeType() {
        return this.parentNodeType;
    }

    public void setParentNodeType(NodeType parent) {
        this.parentNodeType = parent;
    }

    @Override
    public String getShortDescription() {
        return RestClientI18n.nodeTypeShortDescription.text(this.name, this.workspace.getServer());
    }

    public int hashCode() {
        return HashCode.compute(this.name, this.workspace);
    }

    public String toString() {
        return this.getShortDescription();
    }
}

