/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest.client.domain;

import net.jcip.annotations.Immutable;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.HashCode;
import org.modeshape.web.jcr.rest.client.RestClientI18n;
import org.modeshape.web.jcr.rest.client.Utils;
import org.modeshape.web.jcr.rest.client.domain.IModeShapeObject;

@Immutable
public class Server
implements IModeShapeObject {
    private final String password;
    private final String url;
    private final String user;

    public Server(String url, String user, String password) {
        assert (url != null);
        assert (user != null);
        this.url = url;
        this.user = user;
        this.password = password;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Server otherServer = (Server)obj;
        return Utils.equivalent(this.url, otherServer.url) && Utils.equivalent(this.user, otherServer.user) && Utils.equivalent(this.password, otherServer.password);
    }

    @Override
    public String getName() {
        return this.getUrl();
    }

    public String getPassword() {
        return this.password;
    }

    @Override
    public String getShortDescription() {
        return RestClientI18n.serverShortDescription.text(this.url, this.user);
    }

    public String getUrl() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    public int hashCode() {
        return HashCode.compute(this.url, this.user, this.password);
    }

    public boolean hasSameKey(Server otherServer) {
        CheckArg.isNotNull(otherServer, "otherServer");
        return Utils.equivalent(this.url, otherServer.url) && Utils.equivalent(this.user, otherServer.user);
    }

    public String toString() {
        return this.getShortDescription();
    }
}

