/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc.delegate;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Set;
import javax.jcr.Repository;
import org.modeshape.jdbc.JcrConnection;
import org.modeshape.jdbc.JcrMetaData;
import org.modeshape.jdbc.JdbcI18n;
import org.modeshape.jdbc.ModeShapeMetaData;
import org.modeshape.jdbc.delegate.ConnectionInfo;
import org.modeshape.jdbc.delegate.RepositoryDelegate;
import org.modeshape.jdbc.util.Logger;

public abstract class AbstractRepositoryDelegate
implements RepositoryDelegate {
    protected static final Logger LOGGER = Logger.getLogger("org.modeshape.jdbc.delegate");
    private Repository repository = null;
    private Set<String> repositoryNames = null;
    private ConnectionInfo connInfo = null;
    private String url;
    private Properties propertiesInfo;

    public AbstractRepositoryDelegate(String url, Properties info) {
        this.url = url;
        this.propertiesInfo = info;
    }

    protected abstract ConnectionInfo createConnectionInfo(String var1, Properties var2);

    @Override
    public synchronized ConnectionInfo getConnectionInfo() {
        if (this.connInfo == null) {
            this.connInfo = this.createConnectionInfo(this.url, this.propertiesInfo);
            this.connInfo.init();
        }
        return this.connInfo;
    }

    protected abstract void createRepository() throws SQLException;

    protected boolean isSessionAvailable() {
        return false;
    }

    @Override
    public Connection createConnection() throws SQLException {
        LOGGER.debug("Creating connection for RepositoryDelegte", new Object[0]);
        if (this.repository == null) {
            this.createRepository();
        }
        return new JcrConnection(this);
    }

    public synchronized Repository getRepository() {
        return this.repository;
    }

    protected void setRepository(Repository repository) {
        this.repository = repository;
    }

    public String getRepositoryName() {
        return this.getConnectionInfo().getRepositoryName();
    }

    protected void setRepositoryName(String repositoryName) {
        this.getConnectionInfo().setRepositoryName(repositoryName);
    }

    @Override
    public Set<String> getRepositoryNames() {
        return this.repositoryNames;
    }

    protected void setRepositoryNames(Set<String> repositoryNames) {
        this.repositoryNames = repositoryNames;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        return iface.isInstance(this);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!this.isWrapperFor(iface)) {
            throw new SQLException(JdbcI18n.classDoesNotImplementInterface.text(RepositoryDelegate.class.getSimpleName(), iface.getName()));
        }
        return iface.cast(this);
    }

    @Override
    public DatabaseMetaData createMetaData(JcrConnection connection) {
        if (this.getDescriptor("jcr.repository.name") != null && this.getDescriptor("jcr.repository.name").toLowerCase().contains("modeshape")) {
            return new ModeShapeMetaData(connection);
        }
        return new JcrMetaData(connection);
    }
}

