/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc.delegate;

import java.sql.DriverPropertyInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.jcr.Credentials;
import javax.jcr.SimpleCredentials;
import org.modeshape.jdbc.JdbcI18n;
import org.modeshape.jdbc.util.StringUtil;
import org.modeshape.jdbc.util.TextDecoder;
import org.modeshape.jdbc.util.UrlEncoder;

public abstract class ConnectionInfo {
    public static final TextDecoder URL_DECODER = new UrlEncoder();
    protected String url;
    protected String repositoryPath;
    protected Properties properties;
    private char propertyDelimiter = (char)63;

    protected ConnectionInfo(String url, Properties properties) {
        this.url = url;
        this.properties = properties;
    }

    protected void init() {
        Properties props = this.getProperties() != null ? (Properties)this.getProperties().clone() : new Properties();
        this.repositoryPath = this.getUrl().substring(this.getUrlPrefix().length());
        int questionMarkIndex = this.repositoryPath.indexOf(63);
        if (questionMarkIndex != -1) {
            if (this.repositoryPath.length() > questionMarkIndex + 1) {
                String paramStr = this.repositoryPath.substring(questionMarkIndex + 1);
                for (String param : paramStr.split("&")) {
                    String[] pair = param.split("=");
                    if (pair.length <= 1) continue;
                    String key = URL_DECODER.decode(pair[0] != null ? pair[0].trim() : null);
                    String value = URL_DECODER.decode(pair[1] != null ? pair[1].trim() : null);
                    if (props.containsKey(key)) continue;
                    props.put(key, value);
                }
            }
            this.repositoryPath = this.repositoryPath.substring(0, questionMarkIndex).trim();
        }
        Properties newprops = new Properties();
        newprops.putAll((Map<?, ?>)props);
        this.setProperties(newprops);
        String url = this.getUrl();
        this.setUrl(url != null ? url.trim() : null);
    }

    public String getUrl() {
        return this.url;
    }

    public String getRepositoryPath() {
        return this.repositoryPath;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getRepositoryName() {
        return this.properties.getProperty("repositoryName");
    }

    void setRepositoryName(String repositoryName) {
        this.properties.setProperty("repositoryName", repositoryName);
    }

    public String getWorkspaceName() {
        return this.properties.getProperty("workspace");
    }

    public void setWorkspaceName(String workSpaceName) {
        this.properties.setProperty("workspace", workSpaceName);
    }

    public String getUsername() {
        return this.properties.getProperty("user");
    }

    public char[] getPassword() {
        String result = this.properties.getProperty("password");
        return result != null ? result.toCharArray() : null;
    }

    void setUrl(String url) {
        this.url = url;
    }

    void setProperties(Properties properties) {
        this.properties = properties;
    }

    public String getEffectiveUrl() {
        StringBuilder url = new StringBuilder(this.getUrlPrefix());
        url.append(this.getRepositoryPath());
        int propertyDelim = this.getPropertyDelimiter();
        for (String propertyName : this.getProperties().stringPropertyNames()) {
            String value = this.getProperties().getProperty(propertyName);
            if (value == null) continue;
            if ("password".equals(propertyName)) {
                value = StringUtil.createString('*', value.length());
            }
            url.append((char)propertyDelim).append(propertyName).append('=').append(value);
            propertyDelim = 38;
        }
        return url.toString();
    }

    protected char getPropertyDelimiter() {
        return this.propertyDelimiter;
    }

    protected void setPropertyDelimiter(char delimiter) {
        this.propertyDelimiter = delimiter;
    }

    public DriverPropertyInfo[] getPropertyInfos() {
        ArrayList<DriverPropertyInfo> results = new ArrayList<DriverPropertyInfo>();
        this.addUrlPropertyInfo(results);
        this.addUserNamePropertyInfo(results);
        this.addPasswordPropertyInfo(results);
        this.addWorkspacePropertyInfo(results);
        this.addRepositoryNamePropertyInfo(results);
        return results.toArray(new DriverPropertyInfo[results.size()]);
    }

    protected void addUrlPropertyInfo(List<DriverPropertyInfo> results) {
        if (this.getUrl() == null) {
            DriverPropertyInfo info = new DriverPropertyInfo(JdbcI18n.urlPropertyName.text(new Object[0]), null);
            info.description = JdbcI18n.urlPropertyDescription.text(this.getEffectiveUrl(), this.getUrlExample());
            info.required = true;
            info.choices = new String[]{this.getUrlExample()};
            results.add(info);
        }
    }

    protected void addUserNamePropertyInfo(List<DriverPropertyInfo> results) {
        if (this.getUsername() == null) {
            DriverPropertyInfo info = new DriverPropertyInfo(JdbcI18n.usernamePropertyName.text(new Object[0]), null);
            info.description = JdbcI18n.usernamePropertyDescription.text(new Object[0]);
            info.required = false;
            info.choices = null;
            results.add(info);
        }
    }

    protected void addPasswordPropertyInfo(List<DriverPropertyInfo> results) {
        if (this.getPassword() == null) {
            DriverPropertyInfo info = new DriverPropertyInfo(JdbcI18n.passwordPropertyName.text(new Object[0]), null);
            info.description = JdbcI18n.passwordPropertyDescription.text(new Object[0]);
            info.required = false;
            info.choices = null;
            results.add(info);
        }
    }

    protected void addWorkspacePropertyInfo(List<DriverPropertyInfo> results) {
        if (this.getWorkspaceName() == null) {
            DriverPropertyInfo info = new DriverPropertyInfo(JdbcI18n.workspaceNamePropertyName.text(new Object[0]), null);
            info.description = JdbcI18n.workspaceNamePropertyDescription.text(new Object[0]);
            info.required = false;
            info.choices = null;
            results.add(info);
        }
    }

    protected void addRepositoryNamePropertyInfo(List<DriverPropertyInfo> results) {
        if (this.getRepositoryName() == null) {
            DriverPropertyInfo info = new DriverPropertyInfo(JdbcI18n.repositoryNamePropertyName.text(new Object[0]), null);
            info.description = JdbcI18n.repositoryNamePropertyDescription.text(new Object[0]);
            info.required = true;
            info.choices = null;
            results.add(info);
        }
    }

    public abstract String getUrlExample();

    public abstract String getUrlPrefix();

    public Credentials getCredentials() {
        String username = this.getUsername();
        char[] password = this.getPassword();
        if (username != null) {
            return new SimpleCredentials(username, password);
        }
        return null;
    }
}

