/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc.delegate;

import java.sql.Connection;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.modeshape.jcr.api.Repositories;
import org.modeshape.jdbc.JcrDriver;
import org.modeshape.jdbc.JdbcI18n;
import org.modeshape.jdbc.delegate.AbstractRepositoryDelegate;
import org.modeshape.jdbc.delegate.ConnectionInfo;

public class LocalRepositoryDelegate
extends AbstractRepositoryDelegate {
    private static final String JNDI_EXAMPLE_URL = "jdbc:jcr:jndi:{jndiName}";
    private JcrDriver.JcrContextFactory jcrContext = null;
    private QueryResult jcrResults;
    private Query jcrQuery;
    private Session session;

    public LocalRepositoryDelegate(String url, Properties info, JcrDriver.JcrContextFactory contextFactory) {
        super(url, info);
        this.jcrContext = contextFactory == null ? new JcrDriver.JcrContextFactory(){

            @Override
            public Context createContext(Properties properties) throws NamingException {
                InitialContext initContext = properties == null || properties.isEmpty() ? new InitialContext() : new InitialContext(properties);
                return initContext;
            }
        } : contextFactory;
    }

    @Override
    protected ConnectionInfo createConnectionInfo(String url, Properties info) {
        return new JNDIConnectionInfo(url, info);
    }

    protected Session session() throws RepositoryException {
        if (this.session == null) {
            LOGGER.debug("Setting up session for LocalRepositoryDelegte", new Object[0]);
            ConnectionInfo connInfo = this.getConnectionInfo();
            Repository repository = this.getRepository();
            Credentials credentials = connInfo.getCredentials();
            String workspaceName = connInfo.getWorkspaceName();
            if (workspaceName != null) {
                this.session = credentials != null ? repository.login(credentials, workspaceName) : repository.login(workspaceName);
                LOGGER.trace("Creating session when workspaceName is null", new Object[0]);
            } else {
                this.session = credentials != null ? repository.login(credentials) : repository.login();
                LOGGER.trace("Creating session for workspace {0}", workspaceName);
            }
            assert (this.session != null);
        }
        return this.session;
    }

    @Override
    protected boolean isSessionAvailable() {
        try {
            return this.session() != null;
        }
        catch (RepositoryException repositoryException) {
            return false;
        }
    }

    protected JcrDriver.JcrContextFactory getJcrContext() {
        return this.jcrContext;
    }

    @Override
    public String getDescriptor(String descriptorKey) {
        return this.getRepository().getDescriptor(descriptorKey);
    }

    @Override
    public NodeType nodeType(String name) throws RepositoryException {
        return this.session().getWorkspace().getNodeTypeManager().getNodeType(name);
    }

    @Override
    public List<NodeType> nodeTypes() throws RepositoryException {
        ArrayList<NodeType> types = new ArrayList<NodeType>();
        NodeTypeIterator its = this.session().getWorkspace().getNodeTypeManager().getAllNodeTypes();
        while (its.hasNext()) {
            types.add((NodeType)its.next());
        }
        return types;
    }

    @Override
    public QueryResult execute(String query, String language) throws RepositoryException {
        LOGGER.trace("Executing query: {0}" + query, new Object[0]);
        this.jcrQuery = null;
        this.jcrResults = null;
        this.jcrQuery = this.session().getWorkspace().getQueryManager().createQuery(query, language);
        this.jcrResults = this.jcrQuery.execute();
        return this.jcrResults;
    }

    @Override
    protected void createRepository() throws SQLException {
        LOGGER.debug("Creating repository for LocalRepositoryDelegte", new Object[0]);
        Repository repository = null;
        HashSet<String> repositoryNames = null;
        ConnectionInfo connInfo = this.getConnectionInfo();
        assert (connInfo != null);
        String jndiName = connInfo.getRepositoryPath();
        if (jndiName == null) {
            String msg = JdbcI18n.urlMustContainJndiNameOfRepositoryOrRepositoriesObject.text(new Object[0]);
            throw new SQLException(msg);
        }
        Context context = null;
        try {
            context = this.jcrContext.createContext(connInfo.getProperties());
        }
        catch (NamingException e) {
            throw new SQLException(JdbcI18n.unableToGetJndiContext.text(e.getLocalizedMessage()));
        }
        if (context == null) {
            throw new SQLException(JdbcI18n.unableToFindObjectInJndi.text(jndiName));
        }
        String repositoryName = "NotAssigned";
        try {
            Object target = context.lookup(jndiName);
            repositoryName = connInfo.getRepositoryName();
            if (target instanceof Repositories) {
                LOGGER.trace("JNDI Lookup found Repositories ", new Object[0]);
                Repositories repositories = (Repositories)target;
                if (repositoryName == null) {
                    repositoryNames = repositories.getRepositoryNames();
                    if (repositoryNames == null || repositoryNames.isEmpty()) {
                        throw new SQLException(JdbcI18n.noRepositoryNamesFound.text(new Object[0]));
                    }
                    if (repositoryNames.size() == 1) {
                        repositoryName = (String)repositoryNames.iterator().next();
                        connInfo.setRepositoryName(repositoryName);
                        LOGGER.trace("Setting Repository {0} as default", repositoryName);
                    } else {
                        throw new SQLException(JdbcI18n.objectInJndiIsRepositories.text(jndiName));
                    }
                }
                try {
                    repository = repositories.getRepository(repositoryName);
                }
                catch (RepositoryException e) {
                    throw new SQLException(JdbcI18n.unableToFindNamedRepository.text(jndiName, repositoryName));
                }
            } else if (target instanceof Repository) {
                LOGGER.trace("JNDI Lookup found a Repository", new Object[0]);
                repository = (Repository)target;
                repositoryNames = new HashSet<String>(1);
                if (repositoryName == null) {
                    repositoryName = "DefaultRepository";
                    connInfo.setRepositoryName(repositoryName);
                }
                repositoryNames.add(repositoryName);
            } else {
                throw new SQLException(JdbcI18n.objectInJndiMustBeRepositoryOrRepositories.text(jndiName));
            }
            assert (repository != null);
        }
        catch (NamingException e) {
            throw new SQLException(JdbcI18n.unableToFindObjectInJndi.text(jndiName), e);
        }
        this.setRepository(repository);
        this.setRepositoryName(repositoryName);
        this.setRepositoryNames(repositoryNames);
    }

    @Override
    public boolean isValid(int timeout) throws RepositoryException {
        if (!this.isSessionAvailable()) {
            return false;
        }
        this.session().getRootNode();
        return true;
    }

    @Override
    public void commit() throws RepositoryException {
        if (!this.isSessionAvailable()) {
            return;
        }
        Session session = this.session();
        if (session != null) {
            session.save();
        }
    }

    @Override
    public void rollback() throws RepositoryException {
        if (!this.isSessionAvailable()) {
            return;
        }
        Session session = this.session();
        if (session != null) {
            session.refresh(false);
        }
    }

    @Override
    public void close() {
        if (this.session == null || !this.isSessionAvailable()) {
            return;
        }
        try {
            Session session = this.session();
            if (session != null) {
                session.refresh(false);
                session.logout();
            }
        }
        catch (RepositoryException repositoryException) {
            // empty catch block
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            if (iface.isInstance(this)) {
                return iface.cast(this);
            }
            if (iface.isInstance(Workspace.class)) {
                Workspace workspace = this.session().getWorkspace();
                return iface.cast(workspace);
            }
        }
        catch (RepositoryException re) {
            throw new SQLException(re.getLocalizedMessage());
        }
        throw new SQLException(JdbcI18n.classDoesNotImplementInterface.text(Connection.class.getSimpleName(), iface.getName()));
    }

    class JNDIConnectionInfo
    extends ConnectionInfo {
        protected JNDIConnectionInfo(String url, Properties properties) {
            super(url, properties);
        }

        @Override
        public String getUrlExample() {
            return LocalRepositoryDelegate.JNDI_EXAMPLE_URL;
        }

        @Override
        public String getUrlPrefix() {
            return "jdbc:jcr:jndi:";
        }

        @Override
        protected void addRepositoryNamePropertyInfo(List<DriverPropertyInfo> results) {
            boolean no_errors = results.size() == 0;
            boolean nameRequired = false;
            if (this.getRepositoryName() == null) {
                boolean found = false;
                if (no_errors) {
                    try {
                        Context context = LocalRepositoryDelegate.this.getJcrContext().createContext(this.getProperties());
                        Object obj = context.lookup(this.getRepositoryPath());
                        if (obj instanceof Repositories) {
                            nameRequired = true;
                            found = true;
                        } else if (obj instanceof Repository) {
                            found = true;
                        }
                    }
                    catch (NamingException e) {
                        // empty catch block
                    }
                }
                if (nameRequired || !found) {
                    DriverPropertyInfo info = new DriverPropertyInfo(JdbcI18n.repositoryNamePropertyName.text(new Object[0]), null);
                    info.description = JdbcI18n.repositoryNamePropertyDescription.text(new Object[0]);
                    info.required = nameRequired;
                    info.choices = null;
                    results.add(info);
                }
            }
        }
    }
}

