/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc.delegate;

import java.sql.SQLException;
import java.util.Properties;
import org.modeshape.jdbc.JcrDriver;
import org.modeshape.jdbc.JdbcI18n;
import org.modeshape.jdbc.delegate.HttpRepositoryDelegate;
import org.modeshape.jdbc.delegate.LocalRepositoryDelegate;
import org.modeshape.jdbc.delegate.RepositoryDelegate;

public class RepositoryDelegateFactory {
    private static final int JNDI_URL_OPTION = 1;
    private static final int HTTP_URL_OPTION = 2;

    public static RepositoryDelegate createRepositoryDelegate(String url, Properties info, JcrDriver.JcrContextFactory contextFactory) throws SQLException {
        if (!RepositoryDelegateFactory.acceptUrl(url)) {
            throw new SQLException(JdbcI18n.invalidUrlPrefix.text("jdbc:jcr:jndi:", "jdbc:jcr:http://"));
        }
        RepositoryDelegate jcri = RepositoryDelegateFactory.create(url, info, contextFactory);
        return jcri;
    }

    public static boolean acceptUrl(String url) {
        return RepositoryDelegateFactory.getUrlOption(url) > 0;
    }

    private static int getUrlOption(String url) {
        if (url == null || url.trim().length() == 0) {
            return -1;
        }
        String trimmedUrl = url.trim();
        if (trimmedUrl.startsWith("jdbc:jcr:jndi:") && trimmedUrl.length() > "jdbc:jcr:jndi:".length()) {
            return 1;
        }
        if (trimmedUrl.startsWith("jdbc:jcr:http://") && trimmedUrl.length() > "jdbc:jcr:http://".length()) {
            return 2;
        }
        return -1;
    }

    private static RepositoryDelegate create(String url, Properties info, JcrDriver.JcrContextFactory contextFactory) {
        switch (RepositoryDelegateFactory.getUrlOption(url)) {
            case 1: {
                return new LocalRepositoryDelegate(url, info, contextFactory);
            }
            case 2: {
                return new HttpRepositoryDelegate(url, info, contextFactory);
            }
        }
        return null;
    }
}

