/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.web.jcr.rest.client.json;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.codehaus.jettison.json.JSONObject;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.Logger;
import org.modeshape.web.jcr.rest.client.domain.Repository;
import org.modeshape.web.jcr.rest.client.domain.Server;
import org.modeshape.web.jcr.rest.client.json.JsonNode;
import org.modeshape.web.jcr.rest.client.json.JsonUtils;

public final class ServerNode
extends JsonNode {
    private static final Logger LOGGER = Logger.getLogger(ServerNode.class);
    private final Server server;

    public ServerNode(Server server) {
        super(server.getName());
        this.server = server;
    }

    @Override
    public URL getUrl() throws Exception {
        StringBuilder url = new StringBuilder(this.server.getUrl());
        if (url.lastIndexOf("/") == url.length() - 1) {
            url.delete(url.length() - 1, url.length() - 1);
        }
        return new URL(url.toString());
    }

    public URL getFindRepositoriesUrl() throws Exception {
        return new URL(this.getUrl().toString() + '/');
    }

    public Collection<Repository> getRepositories(String jsonResponse) throws Exception {
        CheckArg.isNotNull(jsonResponse, "jsonResponse");
        ArrayList<Repository> repositories = new ArrayList<Repository>();
        LOGGER.trace("getRepositories:jsonResponse={0}", jsonResponse);
        JSONObject jsonObj = new JSONObject(jsonResponse);
        Iterator itr = jsonObj.keys();
        while (itr.hasNext()) {
            String name = JsonUtils.decode((String)itr.next());
            Repository repository = new Repository(name, this.server);
            repositories.add(repository);
            LOGGER.trace("getRepositories: adding repository={0}", repository);
        }
        return repositories;
    }
}

