/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.mock.MockHttpRequest;
import org.jboss.resteasy.mock.MockHttpResponse;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.InternalServerErrorException;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
public class AsynchronousDispatcher
extends SynchronousDispatcher {
    protected ExecutorService executor;
    private int threadPoolSize = 100;
    private Map<String, Future<MockHttpResponse>> jobs;
    private Cache cache;
    private String basePath = "/asynch/jobs";
    private AtomicLong counter = new AtomicLong(0L);
    private static final Logger logger = LoggerFactory.getLogger(AsynchronousDispatcher.class);
    private long maxWaitMilliSeconds = 300000L;
    private int maxCacheSize = 100;

    public AsynchronousDispatcher(ResteasyProviderFactory providerFactory) {
        super(providerFactory);
    }

    public void setMaxCacheSize(int maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
        if (this.cache != null) {
            this.cache.setMaxSize(maxCacheSize);
        }
    }

    public void setMaxWaitMilliSeconds(long maxWaitMilliSeconds) {
        this.maxWaitMilliSeconds = maxWaitMilliSeconds;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public void setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }

    public void setExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    public void start() {
        this.cache = new Cache(this.maxCacheSize);
        this.jobs = Collections.synchronizedMap(this.cache);
        if (this.executor == null) {
            this.executor = Executors.newFixedThreadPool(this.threadPoolSize);
        }
        this.registry.addSingletonResource(this, this.basePath);
    }

    public void stop() {
        this.executor.shutdown();
    }

    @Path(value="{job-id}")
    @DELETE
    public void remove(@PathParam(value="job-id") String jobId) {
        this.jobs.remove(jobId);
    }

    @Path(value="{job-id}")
    @POST
    public Response readAndRemove(@QueryParam(value="wait") @DefaultValue(value="-1") long wait, @PathParam(value="job-id") String jobId) {
        return this.process(wait, jobId, true);
    }

    @Path(value="{job-id}")
    @GET
    public Response get(@QueryParam(value="wait") @DefaultValue(value="-1") long wait, @PathParam(value="job-id") String jobId) {
        return this.process(wait, jobId, false);
    }

    protected Response process(long wait, String jobId, boolean eatJob) {
        Future<MockHttpResponse> job = this.jobs.get(jobId);
        if (job == null) {
            return Response.status(Response.Status.GONE).build();
        }
        MockHttpResponse response = null;
        boolean nowait = false;
        if (wait <= 0L) {
            nowait = true;
        }
        if (nowait) {
            if (job.isDone()) {
                try {
                    response = job.get();
                }
                catch (Exception e) {
                    return Response.serverError().build();
                }
            }
        } else {
            try {
                if (wait > this.maxWaitMilliSeconds) {
                    wait = this.maxWaitMilliSeconds;
                }
                response = job.get(wait, TimeUnit.MILLISECONDS);
            }
            catch (Exception e) {
                return Response.serverError().build();
            }
        }
        if (response == null) {
            return Response.status(Response.Status.ACCEPTED).build();
        }
        Response.ResponseBuilder builder = Response.status(response.getStatus());
        builder.entity(response.getOutput());
        for (String name : response.getOutputHeaders().keySet()) {
            List values = (List)response.getOutputHeaders().get(name);
            for (Object value : values) {
                builder.header(name, value);
            }
        }
        if (eatJob) {
            this.jobs.remove(jobId);
        }
        return builder.build();
    }

    public void invokeSuper(HttpRequest request, HttpResponse response) {
        super.invoke(request, response);
    }

    public boolean isAsynchrnousRequest(HttpRequest in) {
        MultivaluedMap<String, String> queryParameters = in.getUri().getQueryParameters();
        return queryParameters.get("asynch") != null || queryParameters.get("oneway") != null;
    }

    public void invoke(HttpRequest in, HttpResponse response) {
        MultivaluedMap<String, String> queryParameters = in.getUri().getQueryParameters();
        if (queryParameters.get("asynch") != null) {
            this.postJob(in, response);
        } else if (queryParameters.get("oneway") != null) {
            this.oneway(in, response);
        } else {
            super.invoke(in, response);
        }
    }

    public void postJob(HttpRequest request, HttpResponse response) {
        MockHttpRequest in;
        try {
            in = MockHttpRequest.deepCopy(request);
        }
        catch (IOException e) {
            throw new InternalServerErrorException(e);
        }
        Callable<MockHttpResponse> callable = new Callable<MockHttpResponse>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public MockHttpResponse call() throws Exception {
                MockHttpResponse theResponse = new MockHttpResponse();
                try {
                    AsynchronousDispatcher.this.invokeSuper(in, theResponse);
                }
                finally {
                    ResteasyProviderFactory.clearContextData();
                }
                return theResponse;
            }
        };
        Future<MockHttpResponse> future = this.executor.submit(callable);
        String id = "" + System.currentTimeMillis() + "-" + this.counter.incrementAndGet();
        this.jobs.put(id, future);
        response.setStatus(202);
        URI uri = request.getUri().getBaseUriBuilder().path(this.basePath).path(id).build(new Object[0]);
        response.getOutputHeaders().add("Location", uri);
    }

    public void oneway(HttpRequest request, HttpResponse response) {
        MockHttpRequest in;
        logger.debug("IN ONE WAY!!!!!");
        try {
            in = MockHttpRequest.deepCopy(request);
        }
        catch (IOException e) {
            throw new InternalServerErrorException(e);
        }
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                logger.debug("RUNNING JOB!!!!");
                MockHttpResponse theResponse = new MockHttpResponse();
                try {
                    AsynchronousDispatcher.this.invokeSuper(in, theResponse);
                }
                catch (Exception ignored) {
                    logger.error("Failed to invoke asynchronously", (Throwable)ignored);
                }
                finally {
                    ResteasyProviderFactory.clearContextData();
                }
            }
        };
        this.executor.execute(runnable);
        response.setStatus(202);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Cache
    extends LinkedHashMap<String, Future<MockHttpResponse>> {
        private int maxSize = 100;

        public Cache(int maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Future<MockHttpResponse>> stringFutureEntry) {
            return this.size() > this.maxSize;
        }

        public void setMaxSize(int maxSize) {
            this.maxSize = maxSize;
        }
    }
}

