/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.common.FixFor;
import org.modeshape.jdbc.ConnectionResultsComparator;
import org.modeshape.jdbc.JcrConnection;
import org.modeshape.jdbc.JcrDriver;

public class JcrHttpDriverIntegrationTest {
    private Properties driverProperties = new Properties();
    private JcrDriver driver = new JcrDriver(null);

    @Before
    public void before() throws Exception {
        DriverManager.registerDriver((Driver)this.driver);
        this.driverProperties.setProperty("user", this.getUserName());
        this.driverProperties.setProperty("password", this.getPassword());
    }

    @After
    public void after() throws Exception {
        DriverManager.deregisterDriver((Driver)this.driver);
    }

    @Test
    public void shouldCreateConnectionToRemoteServer() throws SQLException {
        Connection connection = this.connectToRemoteRepository();
        Assert.assertTrue((boolean)(connection instanceof JcrConnection));
        Assert.assertTrue((connection.unwrap(JcrConnection.class) != null ? 1 : 0) != 0);
        Assert.assertFalse((boolean)connection.isClosed());
    }

    @Test(expected=SQLException.class)
    public void shouldNotConnectWithInvalidRepositoryName() throws Exception {
        DriverManager.getConnection(this.getContextPathUrl() + "/dummy", this.driverProperties);
    }

    @Test
    public void shouldRetrieveMetaData() throws SQLException {
        Connection connection = this.connectToRemoteRepository();
        DatabaseMetaData metaData = connection.getMetaData();
        Assert.assertNotNull((Object)metaData);
    }

    @Test
    @FixFor(value={"MODE-872"})
    public void shouldReturnResultsFromSimpleQuery() throws Exception {
        Connection connection = this.connectToRemoteRepository();
        String query = "SELECT [jcr:primaryType], [jcr:mixinTypes], [jcr:path], [jcr:name], [mode:localName], [mode:depth] FROM [nt:base] WHERE [jcr:path] LIKE '/%' AND [jcr:path] NOT LIKE '/%/%'ORDER BY [jcr:path]";
        String[] expectedResults = new String[]{"jcr:path[STRING]    jcr:name[STRING]    mode:depth[LONG]    mode:localName[STRING]    jcr:mixinTypes[STRING]    jcr:primaryType[STRING]", "/        0        null    mode:root", "/jcr:system    jcr:system    1    system    null    mode:system"};
        ConnectionResultsComparator.executeTest((Connection)connection, (String)query, (String[])expectedResults, (int)3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @FixFor(value={"MODE-872"})
    public void shouldReturnEmptyResultSetWhenNoResultsFoundForQuery() throws Exception {
        Connection connection = this.connectToRemoteRepository();
        String query = "SELECT [jcr:primaryType], [jcr:mixinTypes], [jcr:path], [jcr:name], [mode:localName], [mode:depth] FROM [mix:versionable] ORDER BY [jcr:path]";
        Statement statement = null;
        ResultSet rs = null;
        try {
            statement = connection.createStatement();
            rs = statement.executeQuery(query);
            Assert.assertNotNull((Object)rs);
            Assert.assertFalse((boolean)rs.next());
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (statement != null) {
                statement.close();
            }
        }
    }

    protected String getContextPathUrl() {
        return "localhost:8090/modeshape/v1";
    }

    protected String getRepositoryName() {
        return "repo";
    }

    protected String getWorkspaceName() {
        return "default";
    }

    protected String getUserName() {
        return "dnauser";
    }

    protected String getPassword() {
        return "password";
    }

    private String getRepositoryUrl() {
        return "jdbc:jcr:http://" + this.getContextPathUrl() + "/" + this.getRepositoryName() + "/" + this.getWorkspaceName();
    }

    private Connection connectToRemoteRepository() throws SQLException {
        Connection connection = DriverManager.getConnection(this.getRepositoryUrl(), this.driverProperties);
        Assert.assertNotNull((Object)connection);
        return connection;
    }
}

