/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc.rest;

import java.io.ByteArrayInputStream;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jdbc.JdbcI18n;
import org.modeshape.jdbc.rest.JSONRestClient;
import org.modeshape.jdbc.rest.NodeTypes;
import org.modeshape.jdbc.rest.QueryResult;
import org.modeshape.jdbc.rest.Repositories;
import org.modeshape.jdbc.rest.Workspaces;

public final class ModeShapeRestClient {
    private static final String NODE_TYPES_SEGMENT = "jcr:system/jcr:nodeTypes?depth=-1";
    private static final String ITEMS_METHOD = "items";
    private static final String QUERY_METHOD = "query";
    private static final String QUERY_PLAN_METHOD = "queryPlan";
    private final JSONRestClient jsonRestClient;

    public ModeShapeRestClient(String repoUrl, String username, String password) {
        CheckArg.isNotNull((Object)repoUrl, (String)"repoUrl");
        this.jsonRestClient = new JSONRestClient(repoUrl, username, password);
    }

    public String serverUrl() {
        return this.jsonRestClient.url();
    }

    public Repositories getRepositories() {
        JSONRestClient.Response response = this.jsonRestClient.doGet();
        if (!response.isOK()) {
            throw new RuntimeException(JdbcI18n.invalidServerResponse.text(new Object[]{this.jsonRestClient.url(), response.asString()}));
        }
        return new Repositories(response.json());
    }

    public Repositories.Repository getRepository(String name) {
        JSONRestClient.Response response = this.jsonRestClient.doGet();
        if (!response.isOK()) {
            throw new RuntimeException(JdbcI18n.invalidServerResponse.text(new Object[]{this.jsonRestClient.url(), response.asString()}));
        }
        return new Repositories(response.json()).getRepository(name);
    }

    public Workspaces getWorkspaces(String repositoryName) {
        String url = this.jsonRestClient.appendToBaseURL(repositoryName);
        JSONRestClient.Response response = this.jsonRestClient.doGet(url);
        if (!response.isOK()) {
            throw new RuntimeException(JdbcI18n.invalidServerResponse.text(new Object[]{url, response.asString()}));
        }
        return new Workspaces(response.json());
    }

    public NodeTypes getNodeTypes() {
        String url = this.jsonRestClient.appendToURL(ITEMS_METHOD, NODE_TYPES_SEGMENT);
        JSONRestClient.Response response = this.jsonRestClient.doGet(url);
        if (!response.isOK()) {
            throw new RuntimeException(JdbcI18n.invalidServerResponse.text(new Object[]{url, response.asString()}));
        }
        return new NodeTypes(response.json());
    }

    public QueryResult query(String query, String queryLanguage) {
        String url = this.jsonRestClient.appendToURL(QUERY_METHOD);
        String contentType = this.contentTypeForQueryLanguage(queryLanguage);
        JSONRestClient.Response response = this.jsonRestClient.postStream(new ByteArrayInputStream(query.getBytes()), url, contentType);
        if (!response.isOK()) {
            throw new RuntimeException(JdbcI18n.invalidServerResponse.text(new Object[]{url, response.asString()}));
        }
        return new QueryResult(response.json());
    }

    public String queryPlan(String query, String queryLanguage) {
        String url = this.jsonRestClient.appendToURL(QUERY_PLAN_METHOD);
        String contentType = this.contentTypeForQueryLanguage(queryLanguage);
        JSONRestClient.Response response = this.jsonRestClient.postStreamTextPlain(new ByteArrayInputStream(query.getBytes()), url, contentType);
        if (!response.isOK()) {
            throw new RuntimeException(JdbcI18n.invalidServerResponse.text(new Object[]{url, response.asString()}));
        }
        return response.asString();
    }

    private String contentTypeForQueryLanguage(String queryLanguage) {
        switch (queryLanguage) {
            case "xpath": {
                return "application/jcr+xpath";
            }
            case "sql": {
                return "application/jcr+sql";
            }
            case "JCR-SQL2": {
                return "application/jcr+sql2";
            }
            case "JCR-JQOM": {
                return "application/jcr+search";
            }
        }
        throw new IllegalArgumentException("Invalid query language: " + queryLanguage);
    }
}

