/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc.rest;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Binary;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.version.OnParentVersionAction;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.util.HashCode;
import org.modeshape.jdbc.JdbcI18n;
import org.modeshape.jdbc.rest.ItemDefinition;
import org.modeshape.jdbc.rest.JSONHelper;
import org.modeshape.jdbc.rest.NodeTypes;

@Immutable
public class PropertyDefinition
extends ItemDefinition
implements javax.jcr.nodetype.PropertyDefinition {
    private static final Map<String, Integer> PROPERTY_TYPES_BY_LOWERCASE_NAME;
    private final Id id;
    private final List<String> queryOps;
    private final List<String> defaultValues;
    private final List<String> valueConstraints;
    private final boolean isFullTextSearchable;
    private final boolean isQueryOrderable;

    private static void registerType(int propertyType, Map<String, Integer> types) {
        String name = PropertyType.nameFromValue((int)propertyType);
        types.put(name.toLowerCase(), propertyType);
    }

    protected PropertyDefinition(String declaringNodeTypeName, JSONObject json, NodeTypes nodeTypes) {
        super(declaringNodeTypeName, json, nodeTypes);
        String name = JSONHelper.valueFrom(json, "jcr:name", "*");
        boolean isMultiple = JSONHelper.valueFrom(json, "jcr:multiple", false);
        int requiredType = this.typeValueFrom(json, "jcr:requiredType", 0);
        this.id = new Id(name, isMultiple, requiredType);
        this.isFullTextSearchable = JSONHelper.valueFrom(json, "jcr:isFullTextSearchable", false);
        this.isQueryOrderable = JSONHelper.valueFrom(json, "jcr:isQueryOrderable", false);
        this.queryOps = JSONHelper.valuesFrom(json, "jcr:availableQueryOperators");
        this.defaultValues = JSONHelper.valuesFrom(json, "jcr:defaultValues");
        this.valueConstraints = JSONHelper.valuesFrom(json, "jcr:valueConstraints");
    }

    protected static Calendar parseDate(String dateString) throws IllegalArgumentException {
        DateTime result = new DateTime((Object)dateString);
        return result.toCalendar(null);
    }

    protected Id id() {
        return this.id;
    }

    public String getName() {
        return this.id.name;
    }

    public String[] getAvailableQueryOperators() {
        return this.queryOps.toArray(new String[this.queryOps.size()]);
    }

    public Value[] getDefaultValues() {
        if (this.defaultValues.isEmpty()) {
            return new Value[0];
        }
        int numValues = this.defaultValues.size();
        int i = 0;
        Value[] result = new Value[numValues];
        for (String value : this.defaultValues) {
            result[i++] = new StringValue(value);
        }
        return result;
    }

    public int getRequiredType() {
        return this.id.requiredType;
    }

    public String[] getValueConstraints() {
        return this.valueConstraints.toArray(new String[this.valueConstraints.size()]);
    }

    public boolean isFullTextSearchable() {
        return this.isFullTextSearchable;
    }

    public boolean isMultiple() {
        return this.id.isMultiple;
    }

    public boolean isQueryOrderable() {
        return this.isQueryOrderable;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PropertyDefinition) {
            PropertyDefinition that = (PropertyDefinition)obj;
            return this.id.equals(that.id);
        }
        return false;
    }

    protected int typeValueFrom(JSONObject json, String name, int defaultType) {
        try {
            if (!json.has(name)) {
                return defaultType;
            }
            String typeName = json.getString(name);
            Integer result = PROPERTY_TYPES_BY_LOWERCASE_NAME.get(typeName.toLowerCase());
            return result != null ? result : defaultType;
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        boolean first;
        StringBuilder sb = new StringBuilder();
        sb.append(" - ");
        sb.append(this.id.name);
        sb.append(" (");
        sb.append(PropertyType.nameFromValue((int)this.id.requiredType));
        sb.append(')');
        if (this.getDefaultValues().length != 0) {
            sb.append(" = ");
            first = true;
            for (Value value : this.getDefaultValues()) {
                if (value == null) continue;
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                sb.append(value);
            }
        }
        if (this.isAutoCreated()) {
            sb.append(" autocreated");
        }
        if (this.isMandatory()) {
            sb.append(" mandatory");
        }
        if (!this.isFullTextSearchable()) {
            sb.append(" nofulltext");
        }
        if (!this.isQueryOrderable()) {
            sb.append(" noqueryorder");
        }
        if (this.isMultiple()) {
            sb.append(" multiple");
        }
        if (this.isProtected()) {
            sb.append(" protected");
        }
        sb.append(' ').append(OnParentVersionAction.nameFromValue((int)this.getOnParentVersion()));
        if (this.getAvailableQueryOperators().length != 0) {
            sb.append(" queryops ");
            first = true;
            for (String string : this.getAvailableQueryOperators()) {
                if (string == null) continue;
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                sb.append('\'');
                sb.append(string);
                sb.append('\'');
            }
        }
        if (this.getValueConstraints().length != 0) {
            sb.append(" < ");
            first = true;
            for (String string : this.getValueConstraints()) {
                if (string == null) continue;
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                sb.append(string);
            }
        }
        return sb.toString();
    }

    static {
        HashMap<String, Integer> types = new HashMap<String, Integer>();
        PropertyDefinition.registerType(2, types);
        PropertyDefinition.registerType(6, types);
        PropertyDefinition.registerType(5, types);
        PropertyDefinition.registerType(12, types);
        PropertyDefinition.registerType(4, types);
        PropertyDefinition.registerType(3, types);
        PropertyDefinition.registerType(7, types);
        PropertyDefinition.registerType(8, types);
        PropertyDefinition.registerType(9, types);
        PropertyDefinition.registerType(1, types);
        PropertyDefinition.registerType(0, types);
        PropertyDefinition.registerType(11, types);
        PropertyDefinition.registerType(10, types);
        PROPERTY_TYPES_BY_LOWERCASE_NAME = Collections.unmodifiableMap(types);
    }

    protected static class Id {
        protected final String name;
        protected final boolean isMultiple;
        protected final int requiredType;

        protected Id(String name, boolean isMultiple, int requiredType) {
            this.name = name;
            this.isMultiple = isMultiple;
            this.requiredType = requiredType;
            assert (this.name != null);
        }

        public int hashCode() {
            return HashCode.compute((Object[])new Object[]{this.isMultiple, this.requiredType, this.name});
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Id) {
                Id that = (Id)obj;
                if (this.isMultiple != that.isMultiple) {
                    return false;
                }
                if (this.requiredType != that.requiredType) {
                    return false;
                }
                return this.name.equals(that.name);
            }
            return false;
        }

        public String toString() {
            return this.name + "(" + PropertyType.nameFromValue((int)this.requiredType) + ")" + (this.isMultiple ? (char)'*' : '1');
        }
    }

    protected final class StringValue
    implements Value {
        protected final String value;

        protected StringValue(String value) {
            this.value = value;
            assert (this.value != null);
        }

        public boolean getBoolean() {
            return Boolean.parseBoolean(this.value.trim());
        }

        public Calendar getDate() throws ValueFormatException {
            try {
                return PropertyDefinition.parseDate(this.value);
            }
            catch (IllegalArgumentException e) {
                String from = PropertyType.nameFromValue((int)this.getType());
                String to = PropertyType.nameFromValue((int)3);
                throw new ValueFormatException(JdbcI18n.unableToConvertValue.text(new Object[]{this.value, from, to}), (Throwable)e);
            }
        }

        public Calendar getDateInUtc() throws ValueFormatException {
            try {
                DateTime result = new DateTime((Object)this.value);
                DateTimeZone utc = DateTimeZone.forID((String)"UTC");
                if (!result.getZone().equals((Object)utc)) {
                    result = result.withZone(utc);
                }
                return result.toCalendar(null);
            }
            catch (IllegalArgumentException e) {
                String from = PropertyType.nameFromValue((int)this.getType());
                String to = PropertyType.nameFromValue((int)3);
                throw new ValueFormatException(JdbcI18n.unableToConvertValue.text(new Object[]{this.value, from, to}), (Throwable)e);
            }
        }

        public BigDecimal getDecimal() throws ValueFormatException {
            try {
                if (PropertyDefinition.this.getRequiredType() == 5) {
                    return new BigDecimal(this.getDateInUtc().getTime().getTime());
                }
                return new BigDecimal(this.value);
            }
            catch (NumberFormatException t) {
                String from = PropertyType.nameFromValue((int)this.getType());
                String to = PropertyType.nameFromValue((int)12);
                throw new ValueFormatException(JdbcI18n.unableToConvertValue.text(new Object[]{this.value, from, to}), (Throwable)t);
            }
        }

        public double getDouble() throws ValueFormatException {
            try {
                if (PropertyDefinition.this.getRequiredType() == 5) {
                    return this.getDateInUtc().getTime().getTime();
                }
                return Double.parseDouble(this.value);
            }
            catch (NumberFormatException t) {
                String from = PropertyType.nameFromValue((int)this.getType());
                String to = PropertyType.nameFromValue((int)4);
                throw new ValueFormatException(JdbcI18n.unableToConvertValue.text(new Object[]{this.value, from, to}), (Throwable)t);
            }
        }

        public long getLong() throws ValueFormatException {
            try {
                if (PropertyDefinition.this.getRequiredType() == 5) {
                    return this.getDateInUtc().getTime().getTime();
                }
                return Long.parseLong(this.value);
            }
            catch (NumberFormatException t) {
                String from = PropertyType.nameFromValue((int)this.getType());
                String to = PropertyType.nameFromValue((int)3);
                throw new ValueFormatException(JdbcI18n.unableToConvertValue.text(new Object[]{this.value, from, to}), (Throwable)t);
            }
        }

        public InputStream getStream() throws RepositoryException {
            return this.getBinary().getStream();
        }

        public String getString() {
            return this.value;
        }

        public int getType() {
            int type = PropertyDefinition.this.getRequiredType();
            return type == 0 ? 1 : type;
        }

        public Binary getBinary() {
            return new Binary(){
                private byte[] bytes;
                {
                    this.bytes = StringValue.this.value.getBytes();
                }

                public void dispose() {
                    this.bytes = null;
                }

                public long getSize() {
                    return this.bytes.length;
                }

                public InputStream getStream() {
                    return new ByteArrayInputStream(this.bytes);
                }

                public int read(byte[] b, long position) throws IOException {
                    if (this.getSize() <= position) {
                        return -1;
                    }
                    try (InputStream stream = this.getStream();){
                        long skipped;
                        for (long skip = position; skip > 0L; skip -= skipped) {
                            skipped = stream.skip(skip);
                            if (skipped > 0L) continue;
                            int n = -1;
                            return n;
                        }
                        int n = stream.read(b);
                        return n;
                    }
                }
            };
        }

        public String toString() {
            return this.value;
        }
    }
}

