/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc.rest;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public final class Repositories
implements Iterable<Repository> {
    private static final String KEY_REPOSITORIES = "repositories";
    private static final String KEY_NAME = "name";
    private final Map<String, Repository> repositories;

    protected Repositories(JSONObject json) {
        try {
            if (!json.has(KEY_REPOSITORIES)) {
                throw new IllegalArgumentException("Invalid JSON object: " + json);
            }
            JSONArray repositoriesJSON = json.getJSONArray(KEY_REPOSITORIES);
            int length = repositoriesJSON.length();
            this.repositories = new HashMap<String, Repository>(length);
            for (int i = 0; i < length; ++i) {
                JSONObject repositoryJSON = repositoriesJSON.getJSONObject(i);
                Repository repository = new Repository(repositoryJSON);
                this.repositories.put(repository.getName(), repository);
            }
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Iterator<Repository> iterator() {
        return this.repositories.values().iterator();
    }

    public Set<Repository> getRepositories() {
        return new HashSet<Repository>(this.repositories.values());
    }

    public Set<String> getRepositoryNames() {
        return new HashSet<String>(this.repositories.keySet());
    }

    public Repository getRepository(String name) {
        return this.repositories.get(name);
    }

    public static final class Repository {
        private final String name;
        private final Map<String, Object> metadata;
        private final int activeSessionsCount;

        protected Repository(JSONObject object) {
            try {
                this.name = object.getString(Repositories.KEY_NAME);
                this.activeSessionsCount = object.has("activeSessionsCount") ? object.getInt("activeSessionsCount") : 0;
                this.metadata = new LinkedHashMap<String, Object>();
                if (object.has("metadata")) {
                    JSONObject metadataObject = object.getJSONObject("metadata");
                    Iterator keysIterator = metadataObject.keys();
                    while (keysIterator.hasNext()) {
                        String key = (String)keysIterator.next();
                        Object value = metadataObject.get(key);
                        if (value instanceof JSONArray) {
                            JSONArray array = (JSONArray)value;
                            String[] strings = new String[array.length()];
                            for (int i = 0; i < array.length(); ++i) {
                                strings[i] = array.get(i).toString();
                            }
                            this.metadata.put(key, strings);
                            continue;
                        }
                        this.metadata.put(key, value.toString());
                    }
                }
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }

        public String getName() {
            return this.name;
        }

        public Map<String, Object> getMetadata() {
            return this.metadata;
        }

        public int getActiveSessionsCount() {
            return this.activeSessionsCount;
        }
    }
}

