/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc.rest;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.modeshape.jdbc.rest.ModeShapeRestClient;
import org.modeshape.jdbc.rest.NodeTypes;
import org.modeshape.jdbc.rest.QueryResult;
import org.modeshape.jdbc.rest.Repositories;
import org.modeshape.jdbc.rest.Workspaces;

public class ModeShapeRestClientTest {
    private static ModeShapeRestClient REST_CLIENT;

    @BeforeClass
    public static void beforeClass() {
        REST_CLIENT = new ModeShapeRestClient("http://localhost:8090/modeshape/repo/default", "dnauser", "password");
    }

    @Test
    public void shouldGetRepositories() throws Exception {
        Repositories repositories = REST_CLIENT.getRepositories();
        Assert.assertNotNull((Object)repositories);
        Set repositoryList = repositories.getRepositories();
        Assert.assertEquals((long)1L, (long)repositoryList.size());
        Repositories.Repository repository = (Repositories.Repository)repositories.iterator().next();
        Assert.assertEquals((Object)"repo", (Object)repository.getName());
        Map metadata = repository.getMetadata();
        Assert.assertNotNull((Object)metadata);
        Assert.assertFalse((boolean)metadata.isEmpty());
    }

    @Test
    public void shouldGetRepositoryByName() throws Exception {
        Assert.assertNull((Object)REST_CLIENT.getRepository("foobar"));
        Repositories.Repository repository = REST_CLIENT.getRepository("repo");
        Assert.assertNotNull((Object)repository);
    }

    @Test
    public void shouldGetWorkspacesForRepository() throws Exception {
        Workspaces workspaces = REST_CLIENT.getWorkspaces("repo");
        Assert.assertNotNull((Object)workspaces);
        List wsList = workspaces.getWorkspaces();
        Assert.assertEquals((long)1L, (long)wsList.size());
        Assert.assertEquals((Object)"default", wsList.get(0));
    }

    @Test
    public void shouldGetNodeTypesForRepository() throws Exception {
        NodeTypes nodeTypes = REST_CLIENT.getNodeTypes();
        Assert.assertFalse((boolean)nodeTypes.isEmpty());
        Assert.assertNotNull((Object)nodeTypes.getNodeType("nt:base"));
        Assert.assertNotNull((Object)nodeTypes.getNodeType("nt:unstructured"));
        Assert.assertNull((Object)nodeTypes.getNodeType("foobar"));
    }

    @Test
    public void shouldQueryRepository() throws Exception {
        QueryResult queryResult = REST_CLIENT.query("SELECT node.[jcr:path] FROM [mode:root] AS node", "JCR-SQL2");
        this.assertQueryResult(queryResult);
        queryResult = REST_CLIENT.query("SELECT jcr:path FROM mode:root", "sql");
        this.assertQueryResult(queryResult);
        queryResult = REST_CLIENT.query("//element(*, mode:root)", "xpath");
        this.assertQueryResult(queryResult);
    }

    private void assertQueryResult(QueryResult queryResult) {
        Map columns = queryResult.getColumns();
        String pathColumn = (String)columns.get("jcr:path");
        Assert.assertNotNull((Object)pathColumn);
        Assert.assertEquals((Object)"string", (Object)pathColumn.toLowerCase());
        List rows = queryResult.getRows();
        Assert.assertEquals((long)1L, (long)rows.size());
        QueryResult.Row result = (QueryResult.Row)rows.get(0);
        Assert.assertEquals((Object)"/", (Object)result.getValue("jcr:path"));
    }

    @Test
    public void shouldGetQueryPlan() throws Exception {
        Assert.assertNotNull((Object)REST_CLIENT.queryPlan("SELECT node.[jcr:path] FROM [mode:root] AS node", "JCR-SQL2"));
    }
}

