/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc.rest;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public final class JSONHelper {
    private JSONHelper() {
    }

    protected static List<String> valuesFrom(JSONObject json, String name) {
        if (!json.has(name)) {
            return Collections.emptyList();
        }
        Object prop = null;
        try {
            prop = json.get(name);
            if (prop instanceof JSONArray) {
                JSONArray array = (JSONArray)prop;
                int length = array.length();
                if (length == 0) {
                    return Collections.emptyList();
                }
                ArrayList<String> result = new ArrayList<String>(length);
                for (int i = 0; i < length; ++i) {
                    String value = array.getString(i);
                    result.add(value);
                }
                return result;
            }
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        return Collections.singletonList(prop.toString());
    }

    protected static boolean valueFrom(JSONObject object, String name, boolean defaultValue) {
        if (!object.has(name)) {
            return defaultValue;
        }
        try {
            return object.getBoolean(name);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    protected static String valueFrom(JSONObject object, String name) {
        return JSONHelper.valueFrom(object, name, null);
    }

    protected static String valueFrom(JSONObject object, String name, String defaultValue) {
        if (!object.has(name)) {
            return defaultValue;
        }
        try {
            return object.getString(name);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }
}

