/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jdbc.rest;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public final class QueryResult
implements Iterable<Row> {
    private final Map<String, String> columns;
    private final List<Row> rows;

    protected QueryResult(JSONObject object) {
        try {
            this.columns = new LinkedHashMap<String, String>();
            if (object.has("columns")) {
                JSONObject columnsObject = object.getJSONObject("columns");
                Iterator keysIterator = columnsObject.keys();
                while (keysIterator.hasNext()) {
                    String columnName = (String)keysIterator.next();
                    String columnType = columnsObject.get(columnName).toString();
                    this.columns.put(columnName, columnType);
                }
            }
            this.rows = new ArrayList<Row>();
            if (object.has("rows")) {
                JSONArray rowsArray = object.getJSONArray("rows");
                for (int i = 0; i < rowsArray.length(); ++i) {
                    this.rows.add(new Row(rowsArray.getJSONObject(i)));
                }
            }
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Iterator<Row> iterator() {
        return this.rows.iterator();
    }

    public Map<String, String> getColumns() {
        return this.columns;
    }

    public List<Row> getRows() {
        return this.rows;
    }

    public boolean isEmpty() {
        return this.rows.isEmpty();
    }

    public final class Row {
        private final Map<String, String> values;

        protected Row(JSONObject object) {
            try {
                Iterator keysIterator = object.keys();
                this.values = new LinkedHashMap<String, String>();
                while (keysIterator.hasNext()) {
                    String key = (String)keysIterator.next();
                    String value = object.get(key).toString();
                    this.values.put(key, value);
                }
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }

        public String getValue(String columnName) {
            return this.values.get(columnName);
        }
    }
}

