/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.lucene;

import java.io.InputStream;
import java.util.HashMap;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import org.junit.Test;
import org.modeshape.common.FixFor;
import org.modeshape.jcr.JcrRootNode;
import org.modeshape.jcr.LocalIndexProviderTest;
import org.modeshape.jcr.api.JcrTools;
import org.modeshape.jcr.api.index.IndexDefinition;
import org.modeshape.jcr.api.index.InvalidIndexDefinitionException;

public class LuceneIndexProviderTest
extends LocalIndexProviderTest {
    public void beforeEach() throws Exception {
        super.beforeEach();
        this.tools = new JcrTools();
    }

    protected InputStream repositoryConfiguration() {
        return this.resource("config/repo-config-persistent-lucene-provider-no-indexes.json");
    }

    protected String providerName() {
        return "lucene";
    }

    @Test
    @FixFor(value={"MODE-2520"})
    public void shouldUseMultiColumnIndex() throws Exception {
        this.registerNodeType("nt:testType");
        HashMap<String, Integer> properties = new HashMap<String, Integer>();
        properties.put("stringProp", 1);
        properties.put("longProp", 3);
        properties.put("jcr:name", 7);
        this.registerValueIndex("multiColIndex", "nt:testType", null, "*", properties);
        JcrRootNode root = this.session().getRootNode();
        Node node1 = root.addNode("node1", "nt:testType");
        node1.setProperty("stringProp", "string1");
        Node node2 = root.addNode("node2", "nt:testType");
        node2.setProperty("longProp", 1L);
        Node node3 = root.addNode("node3", "nt:testType");
        node3.setProperty("stringProp", "string3");
        node3.setProperty("longProp", 2L);
        this.session.save();
        org.modeshape.jcr.api.query.Query query = this.jcrSql2Query("SELECT * FROM [nt:testType] WHERE stringProp LIKE 'string%'");
        this.validateQuery().rowCount(2L).hasNodesAtPaths(new String[]{"/node1", "/node3"}).useIndex("multiColIndex").validate((Query)query, (QueryResult)query.execute());
        query = this.jcrSql2Query("SELECT * FROM [nt:testType] WHERE longProp >= 1");
        this.validateQuery().rowCount(2L).hasNodesAtPaths(new String[]{"/node2", "/node3"}).useIndex("multiColIndex").validate((Query)query, (QueryResult)query.execute());
        query = this.jcrSql2Query("SELECT * FROM [nt:testType] WHERE longProp > 1 AND stringProp LIKE 'string%' ");
        this.validateQuery().rowCount(1L).hasNodesAtPaths(new String[]{"/node3"}).useIndex("multiColIndex").validate((Query)query, (QueryResult)query.execute());
        query = this.jcrSql2Query("SELECT * FROM [nt:testType] WHERE NAME() LIKE 'node%' ");
        this.validateQuery().rowCount(3L).hasNodesAtPaths(new String[]{"/node1", "/node2", "/node3"}).useIndex("multiColIndex").validate((Query)query, (QueryResult)query.execute());
    }

    @Test(expected=InvalidIndexDefinitionException.class)
    public void shouldNotAllowMultiColumnTextIndex() throws Exception {
        HashMap<String, Integer> properties = new HashMap<String, Integer>();
        properties.put("prop1", 1);
        properties.put("prop2", 1);
        this.registerIndex("multiColTextIndex", IndexDefinition.IndexKind.TEXT, this.providerName(), "nt:unstructured", null, "*", properties);
    }

    @Test
    public void shouldUseIndexForFTSOnStringProperty() throws Exception {
        this.registerNodeType("nt:testType");
        this.registerTextIndex("textIndex", "nt:testType", null, "*", "FTSProp", 1);
        JcrRootNode root = this.session().getRootNode();
        Node node1 = root.addNode("node", "nt:testType");
        String propertyText = "the quick Brown fox jumps over to the dog in at the gate";
        node1.setProperty("FTSProp", propertyText);
        this.session.save();
        org.modeshape.jcr.api.query.Query query = this.jcrSql2Query("select [jcr:path] from [nt:testType] as n where contains([nt:testType].*,'" + propertyText + "')");
        this.validateQuery().rowCount(1L).hasNodesAtPaths(new String[]{"/node"}).useIndex("textIndex").validate((Query)query, (QueryResult)query.execute());
        this.jcrSql2Query("select [jcr:path] from [nt:testType] as n where contains(FTSProp,'" + propertyText + "')");
        this.validateQuery().rowCount(1L).hasNodesAtPaths(new String[]{"/node"}).useIndex("textIndex").validate((Query)query, (QueryResult)query.execute());
        this.jcrSql2Query("select [jcr:path] from [nt:testType] as n where contains(FTSProp,'" + propertyText.toUpperCase() + "')");
        this.validateQuery().rowCount(1L).hasNodesAtPaths(new String[]{"/node"}).useIndex("textIndex").validate((Query)query, (QueryResult)query.execute());
        this.jcrSql2Query("select [jcr:path] from [nt:testType] as n where contains(FTSProp,'the quick Dog')");
        this.validateQuery().rowCount(1L).hasNodesAtPaths(new String[]{"/node"}).useIndex("textIndex").validate((Query)query, (QueryResult)query.execute());
        this.jcrSql2Query("select [jcr:path] from [nt:testType] as n where contains(n.*,'the quick Dog')");
        this.validateQuery().rowCount(1L).hasNodesAtPaths(new String[]{"/node"}).useIndex("textIndex").validate((Query)query, (QueryResult)query.execute());
        this.jcrSql2Query("select [jcr:path] from [nt:testType] as n where contains(FTSProp,'the quick jumps over gate')");
        this.validateQuery().rowCount(1L).hasNodesAtPaths(new String[]{"/node"}).useIndex("textIndex").validate((Query)query, (QueryResult)query.execute());
        this.jcrSql2Query("select [jcr:path] from [nt:testType] as n where contains(n.*,'the quick jumps over gate')");
        this.validateQuery().rowCount(1L).hasNodesAtPaths(new String[]{"/node"}).useIndex("textIndex").validate((Query)query, (QueryResult)query.execute());
        this.jcrSql2Query("select [jcr:path] from [nt:testType] as n where contains(FTSProp,'the gate')");
        this.validateQuery().rowCount(1L).hasNodesAtPaths(new String[]{"/node"}).useIndex("textIndex").validate((Query)query, (QueryResult)query.execute());
        this.jcrSql2Query("select [jcr:path] from [nt:testType] as n where contains(n.*,'the gate')");
        this.validateQuery().rowCount(1L).hasNodesAtPaths(new String[]{"/node"}).useIndex("textIndex").validate((Query)query, (QueryResult)query.execute());
    }

    @Test
    public void shouldUseIndexForFTSOnBinaryProperty() throws Exception {
        this.registerTextIndex("textIndex", "nt:resource", null, "*", "jcr:data", 2);
        this.tools.uploadFile((Session)this.session, "/node", this.resourceStream("text-file.txt"));
        this.session.save();
        org.modeshape.jcr.api.query.Query query = this.jcrSql2Query("select [jcr:path] from [nt:resource] as n where contains(n.*,'the quick jumps')");
        this.validateQuery().rowCount(1L).hasNodesAtPaths(new String[]{"/node/jcr:content"}).useIndex("textIndex").validate((Query)query, (QueryResult)query.execute());
    }
}

