/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.lucene;

import java.util.List;
import java.util.UUID;
import org.junit.Test;
import org.modeshape.jcr.api.query.qom.Operator;
import org.modeshape.jcr.index.lucene.LuceneIndex;
import org.modeshape.jcr.index.lucene.MultiColumnIndex;
import org.modeshape.jcr.index.lucene.PropertiesTestUtil;
import org.modeshape.jcr.index.lucene.SingleColumnIndexSearchTest;
import org.modeshape.jcr.query.model.Comparison;
import org.modeshape.jcr.query.model.Constraint;
import org.modeshape.jcr.query.model.PropertyExistence;

public class MultiColumnIndexSearchTest
extends SingleColumnIndexSearchTest {
    @Override
    protected LuceneIndex createIndex(String name) {
        return new MultiColumnIndex(name + "-multi-valued", "default", this.config, PropertiesTestUtil.ALLOWED_PROPERTIES, this.context);
    }

    @Override
    @Test
    public void shouldSearchForReferenceValueInComparisonConstraint() throws Exception {
        String strongRef1 = UUID.randomUUID().toString();
        String strongRef2 = UUID.randomUUID().toString();
        List<String> nodesWithRefProp = this.indexNodes("prop:ref", strongRef1, strongRef2);
        String weakRef1 = UUID.randomUUID().toString();
        String weakRef2 = UUID.randomUUID().toString();
        this.addValues(nodesWithRefProp.get(0), "prop:weakref", weakRef1);
        this.addValues(nodesWithRefProp.get(1), "prop:weakref", weakRef2);
        String simpleRef1 = UUID.randomUUID().toString();
        String simpleRef2 = UUID.randomUUID().toString();
        this.addValues(nodesWithRefProp.get(0), "prop:simpleref", simpleRef1);
        this.addValues(nodesWithRefProp.get(1), "prop:simpleref", simpleRef2);
        Comparison constraint = this.referenceValue("prop:ref", Operator.EQUAL_TO, strongRef1, true, true);
        this.validateCardinality((Constraint)constraint, 1L);
        this.validateFilterResults((Constraint)constraint, 1, false, nodesWithRefProp.get(0));
        constraint = this.referenceValue(null, Operator.EQUAL_TO, weakRef1, true, true);
        this.validateCardinality((Constraint)constraint, 1L);
        this.validateFilterResults((Constraint)constraint, 1, false, nodesWithRefProp.get(0));
        constraint = this.referenceValue(null, Operator.EQUAL_TO, weakRef1, false, true);
        this.validateCardinality((Constraint)constraint, 0L);
        constraint = this.referenceValue(null, Operator.EQUAL_TO, simpleRef2, true, true);
        this.validateCardinality((Constraint)constraint, 1L);
        this.validateFilterResults((Constraint)constraint, 1, false, nodesWithRefProp.get(1));
        constraint = this.referenceValue(null, Operator.EQUAL_TO, simpleRef2, false, false);
        this.validateCardinality((Constraint)constraint, 0L);
    }

    @Override
    @Test
    public void shouldSearchForPropertyExistence() throws Exception {
        List<String> nodes = this.indexNodes("prop:long", 1L, 3L);
        String node1 = nodes.get(0);
        this.addValues(node1, "prop:string", "a");
        PropertyExistence existsLongProp = this.propertyExistence("prop:long");
        this.validateCardinality((Constraint)existsLongProp, 2L);
        this.validateFilterResults((Constraint)existsLongProp, 2, false, nodes.toArray(new String[nodes.size()]));
        PropertyExistence existsStringProp = this.propertyExistence("prop:string");
        this.validateCardinality((Constraint)existsStringProp, 1L);
        this.validateFilterResults((Constraint)existsStringProp, 1, false, node1);
        PropertyExistence nonExistentProp = this.propertyExistence("prop:date");
        this.validateCardinality((Constraint)nonExistentProp, 0L);
        this.index.remove(node1, "prop:long");
        this.validateCardinality((Constraint)existsLongProp, 1L);
        this.validateFilterResults((Constraint)existsLongProp, 1, false, nodes.get(1));
    }
}

