/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.lucene;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.modeshape.jcr.index.lucene.AbstractIndexPersistenceTest;
import org.modeshape.jcr.index.lucene.LuceneIndex;
import org.modeshape.jcr.index.lucene.PropertiesTestUtil;
import org.modeshape.jcr.index.lucene.SingleColumnIndex;
import org.modeshape.jcr.value.PropertyType;

public class SingleColumnIndexPersistenceTest
extends AbstractIndexPersistenceTest {
    @Override
    protected LuceneIndex createIndex(String name) {
        return new SingleColumnIndex(name + "-single-valued", "default", this.config, PropertiesTestUtil.ALLOWED_PROPERTIES, this.context);
    }

    @Test
    public void shouldClearAllData() throws Exception {
        Assert.assertEquals((long)0L, (long)this.index.estimateTotalCount());
        AbstractIndexPersistenceTest.IndexedProperty property = this.newProperty(PropertyType.STRING);
        this.index.add(UUID.randomUUID().toString(), property.getName(), property.getValue());
        this.index.commit();
        Assert.assertEquals((long)1L, (long)this.index.estimateTotalCount());
        this.index.clearAllData();
        Assert.assertEquals((long)0L, (long)this.index.estimateTotalCount());
    }

    @Test
    public void shouldAddNodesWithSingleValues() throws Exception {
        Assert.assertEquals((long)0L, (long)this.index.estimateTotalCount());
        Assert.assertTrue((boolean)this.index.requiresReindexing());
        ArrayList<PropertyType> types = new ArrayList<PropertyType>(Arrays.asList(PropertyType.values()));
        types.remove(PropertyType.OBJECT);
        for (PropertyType type : types) {
            String nodeKey = UUID.randomUUID().toString();
            AbstractIndexPersistenceTest.IndexedProperty property = this.newProperty(type);
            this.index.add(nodeKey, property.getName(), property.getValue());
        }
        this.index.commit();
        Assert.assertEquals((long)types.size(), (long)this.index.estimateTotalCount());
        Assert.assertFalse((boolean)this.index.requiresReindexing());
    }

    @Test
    public void shouldAddNodesWithMultipleValues() throws Exception {
        PropertyType[] types = new PropertyType[]{PropertyType.BOOLEAN, PropertyType.LONG, PropertyType.PATH};
        this.addMultipleNodes(this.index, 3, types);
        Assert.assertEquals((long)types.length, (long)this.index.estimateTotalCount());
    }

    @Test
    public void shouldUpdateValueForSameNodes() throws Exception {
        String nodeKey1 = UUID.randomUUID().toString();
        this.addMultiplePropertiesToSameNode(this.index, nodeKey1, 1, PropertyType.STRING);
        this.addMultiplePropertiesToSameNode(this.index, nodeKey1, 1, PropertyType.STRING);
        this.index.commit();
        String nodeKey2 = UUID.randomUUID().toString();
        this.addMultiplePropertiesToSameNode(this.index, nodeKey2, 1, PropertyType.STRING);
        this.addMultiplePropertiesToSameNode(this.index, nodeKey2, 1, PropertyType.STRING);
        this.index.commit();
        Assert.assertEquals((long)2L, (long)this.index.estimateTotalCount());
    }

    @Test
    public void shouldRemoveSingleValue() throws Exception {
        String nodeKey = UUID.randomUUID().toString();
        String propertyName = this.addMultiplePropertiesToSameNode(this.index, nodeKey, 1, PropertyType.STRING);
        this.index.commit();
        this.index.remove(nodeKey, propertyName);
        this.index.commit();
        Assert.assertEquals((long)0L, (long)this.index.estimateTotalCount());
    }

    @Test
    public void shouldRemoveAllValues() throws Exception {
        String nodeKey = UUID.randomUUID().toString();
        this.addMultiplePropertiesToSameNode(this.index, nodeKey, 2, PropertyType.LONG);
        this.index.commit();
        this.index.remove(nodeKey);
        this.index.commit();
        Assert.assertEquals((long)0L, (long)this.index.estimateTotalCount());
    }

    @Test
    public void shouldUpdateValuesBetweenRestarts() throws Exception {
        String nodeKey = UUID.randomUUID().toString();
        this.addMultiplePropertiesToSameNode(this.index, nodeKey, 2, PropertyType.LONG);
        this.index.commit();
        this.index.shutdown(false);
        this.index = this.defaultIndex();
        Assert.assertFalse((boolean)this.index.requiresReindexing());
        Assert.assertEquals((long)1L, (long)this.index.estimateTotalCount());
        this.addMultiplePropertiesToSameNode(this.index, nodeKey, 1, PropertyType.STRING);
        this.index.commit();
        Assert.assertEquals((long)1L, (long)this.index.estimateTotalCount());
        nodeKey = UUID.randomUUID().toString();
        this.addMultiplePropertiesToSameNode(this.index, nodeKey, 2, PropertyType.DECIMAL);
        this.index.commit();
        this.index.shutdown(false);
        this.index = this.defaultIndex();
        Assert.assertFalse((boolean)this.index.requiresReindexing());
        Assert.assertEquals((long)2L, (long)this.index.estimateTotalCount());
        this.index.remove(nodeKey);
        this.index.commit();
        this.index.shutdown(false);
        this.index = this.defaultIndex();
        Assert.assertFalse((boolean)this.index.requiresReindexing());
        Assert.assertEquals((long)1L, (long)this.index.estimateTotalCount());
        this.addMultiplePropertiesToSameNode(this.index, nodeKey, 2, PropertyType.DECIMAL);
        this.index.commit();
        Assert.assertEquals((long)2L, (long)this.index.estimateTotalCount());
    }

    @Test
    @Ignore(value="perf test")
    public void singleThreadIndexCrudPerformance() throws Exception {
        int nodeCount = 100000;
        int valuesPerProperty = 2;
        int batchSize = 1000;
        List<String> nodeKeys = this.insertNodes(nodeCount, valuesPerProperty, batchSize, this.index);
        Assert.assertEquals((long)nodeCount, (long)this.index.estimateTotalCount());
        this.updateNodes(valuesPerProperty, batchSize, this.index, nodeKeys, null);
        Assert.assertEquals((long)nodeCount, (long)this.index.estimateTotalCount());
        this.removeNodes(batchSize, this.index, nodeKeys, null);
        Assert.assertEquals((long)0L, (long)this.index.estimateTotalCount());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    @Ignore(value="perf test")
    public void multiThreadIndexCrudPerformance() throws Exception {
        void var10_15;
        int endIdx;
        void startIdx;
        void var10_13;
        int nodeCount = 100000;
        boolean valuesPerProperty = true;
        int batchSize = 1000;
        int threadCount = 4;
        int nodesPerThread = 25000;
        ExecutorService executorService = Executors.newFixedThreadPool(4);
        final ArrayList nodeKeys = new ArrayList();
        ArrayList<Future<List<String>>> futures = new ArrayList<Future<List<String>>>();
        for (int i2 = 0; i2 < 4; ++i2) {
            futures.add(executorService.submit(new Callable<List<String>>(){

                @Override
                public List<String> call() throws Exception {
                    return SingleColumnIndexPersistenceTest.this.insertNodes(25000, 1, 1000, SingleColumnIndexPersistenceTest.this.index);
                }
            }));
        }
        for (Future future : futures) {
            nodeKeys.addAll((Collection)future.get());
        }
        Assert.assertEquals((long)100000L, (long)this.index.estimateTotalCount());
        Assert.assertEquals((long)100000L, (long)nodeKeys.size());
        CyclicBarrier barrier = new CyclicBarrier(5);
        boolean bl = false;
        while (var10_13 < 4) {
            startIdx = var10_13 * 25000;
            endIdx = Math.min(nodeKeys.size(), (int)(startIdx + 25000));
            executorService.submit(new Callable<Void>((int)startIdx, endIdx, barrier){
                final /* synthetic */ int val$startIdx;
                final /* synthetic */ int val$endIdx;
                final /* synthetic */ CyclicBarrier val$barrier;
                {
                    this.val$startIdx = n;
                    this.val$endIdx = n2;
                    this.val$barrier = cyclicBarrier;
                }

                @Override
                public Void call() throws Exception {
                    SingleColumnIndexPersistenceTest.this.updateNodes(1, 1000, SingleColumnIndexPersistenceTest.this.index, nodeKeys.subList(this.val$startIdx, this.val$endIdx), this.val$barrier);
                    return null;
                }
            });
            ++var10_13;
        }
        barrier.await();
        Assert.assertEquals((long)100000L, (long)this.index.estimateTotalCount());
        barrier.reset();
        boolean bl2 = false;
        while (var10_15 < 4) {
            startIdx = var10_15 * 25000;
            endIdx = Math.min(nodeKeys.size(), (int)(startIdx + 25000));
            executorService.submit(new Callable<Void>((int)startIdx, endIdx, barrier){
                final /* synthetic */ int val$startIdx;
                final /* synthetic */ int val$endIdx;
                final /* synthetic */ CyclicBarrier val$barrier;
                {
                    this.val$startIdx = n;
                    this.val$endIdx = n2;
                    this.val$barrier = cyclicBarrier;
                }

                @Override
                public Void call() throws Exception {
                    SingleColumnIndexPersistenceTest.this.removeNodes(1000, SingleColumnIndexPersistenceTest.this.index, nodeKeys.subList(this.val$startIdx, this.val$endIdx), this.val$barrier);
                    return null;
                }
            });
            ++var10_15;
        }
        barrier.await();
        Assert.assertEquals((long)0L, (long)this.index.estimateTotalCount());
    }

    private void removeNodes(int batchSize, LuceneIndex index, List<String> nodeKeys, CyclicBarrier barrier) throws Exception {
        long start = System.nanoTime();
        for (int i = 0; i < nodeKeys.size(); ++i) {
            String nodeKey = nodeKeys.get(i);
            index.remove(nodeKey);
            if (i <= 0 || i % batchSize != 0) continue;
            index.commit();
            System.out.println(Thread.currentThread().getName() + " removed " + i + " nodes");
        }
        index.commit();
        long deleteTime = TimeUnit.SECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        System.out.println(Thread.currentThread().getName() + ": (" + index.getName() + ") Total time to delete " + nodeKeys.size() + " nodes: " + (double)deleteTime / 60.0 + " minutes");
        if (barrier != null) {
            barrier.await();
        }
    }

    private void updateNodes(int valuesPerProperty, int batchSize, LuceneIndex index, List<String> nodeKeys, CyclicBarrier barrier) throws Exception {
        long start = System.nanoTime();
        for (int i = 0; i < nodeKeys.size(); ++i) {
            String nodeKey = nodeKeys.get(i);
            this.addMultiplePropertiesToSameNode(index, nodeKey, valuesPerProperty, PropertyType.STRING);
            if (i <= 0 || i % batchSize != 0) continue;
            index.commit();
            System.out.println(Thread.currentThread().getName() + " updated " + i + " nodes");
        }
        index.commit();
        long updateTime = TimeUnit.SECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        System.out.println(Thread.currentThread().getName() + ": (" + index.getName() + ") Total time to update " + nodeKeys.size() + " nodes: " + (double)updateTime / 60.0 + " minutes");
        if (barrier != null) {
            barrier.await();
        }
    }

    private List<String> insertNodes(int nodeCount, int valuesPerProperty, int batchSize, LuceneIndex index) throws Exception {
        ArrayList<String> nodeKeys = new ArrayList<String>();
        long start = System.nanoTime();
        for (int i = 0; i < nodeCount; ++i) {
            String nodeKey = UUID.randomUUID().toString();
            nodeKeys.add(nodeKey);
            this.addMultiplePropertiesToSameNode(index, nodeKey, valuesPerProperty, PropertyType.STRING);
            if (i <= 0 || i % batchSize != 0) continue;
            index.commit();
            System.out.println(Thread.currentThread().getName() + " inserted " + i + " nodes");
        }
        index.commit();
        long insertTime = TimeUnit.SECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        System.out.println(Thread.currentThread().getName() + ": (" + index.getName() + ") Total time to insert " + nodeCount + " nodes: " + (double)insertTime / 60.0 + " minutes");
        return nodeKeys;
    }

    private void addMultipleNodes(LuceneIndex index, int propertiesCount, PropertyType[] types) {
        for (PropertyType type : types) {
            String nodeKey = UUID.randomUUID().toString();
            this.addMultiplePropertiesToSameNode(index, nodeKey, propertiesCount, type);
        }
        index.commit();
    }

    private static class IndexThread<T>
    implements Callable<T> {
        private final LuceneIndex index;
        private final IndexOperation<T> operation;

        protected IndexThread(LuceneIndex index, IndexOperation<T> operation) {
            this.index = index;
            this.operation = operation;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T call() throws Exception {
            try {
                T t = this.operation.execute(this.index);
                return t;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                T t = null;
                return t;
            }
            finally {
                this.index.shutdown(true);
            }
        }
    }

    private static interface IndexOperation<T> {
        public T execute(LuceneIndex var1) throws Exception;
    }
}

