/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.lucene.query;

import org.apache.lucene.index.IndexableField;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.jcr.index.lucene.query.CaseOperations;
import org.modeshape.jcr.index.lucene.query.ConstantScoreWeightQuery;
import org.modeshape.jcr.value.ValueFactory;

@Immutable
public abstract class CompareQuery<ValueType>
extends ConstantScoreWeightQuery {
    protected final ValueType constraintValue;
    protected final Evaluator<ValueType> evaluator;
    protected final ValueFactory<ValueType> valueTypeFactory;
    protected final ValueFactory<String> stringFactory;
    protected final CaseOperations.CaseOperation caseOperation;

    protected CompareQuery(String fieldName, ValueType constraintValue, ValueFactory<ValueType> valueTypeFactory, ValueFactory<String> stringFactory, Evaluator<ValueType> evaluator, CaseOperations.CaseOperation caseOperation) {
        super(fieldName);
        this.constraintValue = constraintValue;
        this.valueTypeFactory = valueTypeFactory;
        this.stringFactory = stringFactory;
        this.caseOperation = caseOperation;
        this.evaluator = evaluator;
        assert (this.constraintValue != null);
        assert (this.evaluator != null);
        assert (this.caseOperation != null);
    }

    @Override
    protected boolean areValid(IndexableField ... fields) {
        for (IndexableField field : fields) {
            Object value;
            String valueAsString = field.stringValue();
            Object object = value = valueAsString != null ? this.valueTypeFactory.create(this.caseOperation.execute(valueAsString)) : null;
            if (!this.evaluator.satisfiesConstraint(value, this.constraintValue)) continue;
            return true;
        }
        return false;
    }

    public String toString(String field) {
        return "(" + this.field() + this.evaluator.toString() + (this.stringFactory != null ? (String)this.stringFactory.create(this.constraintValue) : this.constraintValue.toString()) + ")";
    }

    protected static interface Evaluator<ValueType> {
        public boolean satisfiesConstraint(ValueType var1, ValueType var2);
    }
}

