/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.lucene.query;

import java.text.StringCharacterIterator;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.RegexpQuery;
import org.apache.lucene.search.WildcardQuery;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.jcr.index.lucene.query.CaseOperations;
import org.modeshape.jcr.index.lucene.query.CompareQuery;
import org.modeshape.jcr.value.ValueComparators;
import org.modeshape.jcr.value.ValueFactories;
import org.modeshape.jcr.value.ValueFactory;

@Immutable
public class CompareStringQuery
extends CompareQuery<String> {
    protected static final CompareQuery.Evaluator<String> EQUAL_TO = new CompareQuery.Evaluator<String>(){

        @Override
        public boolean satisfiesConstraint(String nodeValue, String constraintValue) {
            return constraintValue.equals(nodeValue);
        }

        public String toString() {
            return "=";
        }
    };
    protected static final CompareQuery.Evaluator<String> IS_LESS_THAN = new CompareQuery.Evaluator<String>(){

        @Override
        public boolean satisfiesConstraint(String nodeValue, String constraintValue) {
            return ValueComparators.STRING_COMPARATOR.compare(nodeValue, constraintValue) < 0;
        }

        public String toString() {
            return "<";
        }
    };
    protected static final CompareQuery.Evaluator<String> IS_LESS_THAN_OR_EQUAL_TO = new CompareQuery.Evaluator<String>(){

        @Override
        public boolean satisfiesConstraint(String nodeValue, String constraintValue) {
            return ValueComparators.STRING_COMPARATOR.compare(nodeValue, constraintValue) <= 0;
        }

        public String toString() {
            return "<=";
        }
    };
    protected static final CompareQuery.Evaluator<String> IS_GREATER_THAN = new CompareQuery.Evaluator<String>(){

        @Override
        public boolean satisfiesConstraint(String nodeValue, String constraintValue) {
            return ValueComparators.STRING_COMPARATOR.compare(nodeValue, constraintValue) > 0;
        }

        public String toString() {
            return ">";
        }
    };
    protected static final CompareQuery.Evaluator<String> IS_GREATER_THAN_OR_EQUAL_TO = new CompareQuery.Evaluator<String>(){

        @Override
        public boolean satisfiesConstraint(String nodeValue, String constraintValue) {
            return ValueComparators.STRING_COMPARATOR.compare(nodeValue, constraintValue) >= 0;
        }

        public String toString() {
            return ">=";
        }
    };

    public static Query createQueryForNodesWithFieldEqualTo(String constraintValue, String fieldName, ValueFactories factories, CaseOperations.CaseOperation caseOperation) {
        return new CompareStringQuery(fieldName, constraintValue, (ValueFactory<String>)factories.getStringFactory(), (ValueFactory<String>)factories.getStringFactory(), EQUAL_TO, caseOperation);
    }

    public static CompareStringQuery createQueryForNodesWithFieldGreaterThan(String constraintValue, String fieldName, ValueFactories factories, CaseOperations.CaseOperation caseOperation) {
        return new CompareStringQuery(fieldName, constraintValue, (ValueFactory<String>)factories.getStringFactory(), (ValueFactory<String>)factories.getStringFactory(), IS_GREATER_THAN, caseOperation);
    }

    public static CompareStringQuery createQueryForNodesWithFieldGreaterThanOrEqualTo(String constraintValue, String fieldName, ValueFactories factories, CaseOperations.CaseOperation caseOperation) {
        return new CompareStringQuery(fieldName, constraintValue, (ValueFactory<String>)factories.getStringFactory(), (ValueFactory<String>)factories.getStringFactory(), IS_GREATER_THAN_OR_EQUAL_TO, caseOperation);
    }

    public static CompareStringQuery createQueryForNodesWithFieldLessThan(String constraintValue, String fieldName, ValueFactories factories, CaseOperations.CaseOperation caseOperation) {
        return new CompareStringQuery(fieldName, constraintValue, (ValueFactory<String>)factories.getStringFactory(), (ValueFactory<String>)factories.getStringFactory(), IS_LESS_THAN, caseOperation);
    }

    public static CompareStringQuery createQueryForNodesWithFieldLessThanOrEqualTo(String constraintValue, String fieldName, ValueFactories factories, CaseOperations.CaseOperation caseOperation) {
        return new CompareStringQuery(fieldName, constraintValue, (ValueFactory<String>)factories.getStringFactory(), (ValueFactory<String>)factories.getStringFactory(), IS_LESS_THAN_OR_EQUAL_TO, caseOperation);
    }

    protected static boolean hasWildcardCharacters(String expression) {
        StringCharacterIterator iter = new StringCharacterIterator(expression);
        boolean skipNext = false;
        char c = iter.first();
        while (c != '\uffff') {
            if (skipNext) {
                skipNext = false;
            } else {
                if (c == '*' || c == '?' || c == '%' || c == '_') {
                    return true;
                }
                if (c == '\\') {
                    skipNext = true;
                }
            }
            c = iter.next();
        }
        return false;
    }

    public static Query createQueryForNodesWithFieldLike(String likeExpression, String fieldName, ValueFactories factories, CaseOperations.CaseOperation caseOperation) {
        char firstChar;
        assert (likeExpression != null);
        assert (likeExpression.length() > 0);
        if (!CompareStringQuery.hasWildcardCharacters(likeExpression)) {
            return CompareStringQuery.createQueryForNodesWithFieldEqualTo(likeExpression, fieldName, factories, caseOperation);
        }
        if (caseOperation == CaseOperations.AS_IS && (firstChar = likeExpression.charAt(0)) != '%' && firstChar != '_' && firstChar != '*' && firstChar != '?') {
            String expression = CompareStringQuery.toWildcardExpression(likeExpression);
            return new WildcardQuery(new Term(fieldName, expression));
        }
        String regex = CompareStringQuery.toRegularExpression(likeExpression);
        RegexpQuery query = new RegexpQuery(new Term(fieldName, regex));
        int flags = 64;
        if (caseOperation != CaseOperations.AS_IS) {
            flags |= 2;
        }
        return query;
    }

    protected static String toWildcardExpression(String likeExpression) {
        return likeExpression.replace('%', '*').replace('_', '?').replaceAll("\\\\(.)", "$1");
    }

    public static String toRegularExpression(String likeExpression) {
        String result = likeExpression.replaceAll("\\\\(.)", "$1");
        result = result.replaceAll("([$.|+()\\[\\\\^\\\\\\\\])", "\\\\$1");
        result = result.replace("*", ".*").replace("?", ".");
        result = result.replace("%", ".*").replace("_", ".");
        return result;
    }

    protected CompareStringQuery(String fieldName, String constraintValue, ValueFactory<String> valueFactory, ValueFactory<String> stringFactory, CompareQuery.Evaluator<String> evaluator, CaseOperations.CaseOperation caseOperation) {
        super(fieldName, constraintValue, valueFactory, stringFactory, evaluator, caseOperation);
    }

    public Query clone() {
        return new CompareStringQuery(this.field(), (String)this.constraintValue, (ValueFactory<String>)this.valueTypeFactory, (ValueFactory<String>)this.stringFactory, this.evaluator, this.caseOperation);
    }
}

