/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.lucene.query;

import org.apache.lucene.search.Query;
import org.modeshape.jcr.index.lucene.query.CaseOperations;
import org.modeshape.jcr.index.lucene.query.CompareQuery;
import org.modeshape.jcr.value.Name;
import org.modeshape.jcr.value.ValueComparators;
import org.modeshape.jcr.value.ValueFactories;
import org.modeshape.jcr.value.ValueFactory;

public class CompareNameQuery
extends CompareQuery<Name> {
    protected static final CompareQuery.Evaluator<Name> EQUAL_TO = new CompareQuery.Evaluator<Name>(){

        @Override
        public boolean satisfiesConstraint(Name nodeValue, Name constraintValue) {
            return ValueComparators.NAME_COMPARATOR.compare(nodeValue, constraintValue) == 0;
        }

        public String toString() {
            return " = ";
        }
    };
    protected static final CompareQuery.Evaluator<Name> IS_LESS_THAN = new CompareQuery.Evaluator<Name>(){

        @Override
        public boolean satisfiesConstraint(Name nodeValue, Name constraintValue) {
            return ValueComparators.NAME_COMPARATOR.compare(nodeValue, constraintValue) < 0;
        }

        public String toString() {
            return " < ";
        }
    };
    protected static final CompareQuery.Evaluator<Name> IS_LESS_THAN_OR_EQUAL_TO = new CompareQuery.Evaluator<Name>(){

        @Override
        public boolean satisfiesConstraint(Name nodeValue, Name constraintValue) {
            return ValueComparators.NAME_COMPARATOR.compare(nodeValue, constraintValue) <= 0;
        }

        public String toString() {
            return " <= ";
        }
    };
    protected static final CompareQuery.Evaluator<Name> IS_GREATER_THAN = new CompareQuery.Evaluator<Name>(){

        @Override
        public boolean satisfiesConstraint(Name nodeValue, Name constraintValue) {
            return ValueComparators.NAME_COMPARATOR.compare(nodeValue, constraintValue) > 0;
        }

        public String toString() {
            return " > ";
        }
    };
    protected static final CompareQuery.Evaluator<Name> IS_GREATER_THAN_OR_EQUAL_TO = new CompareQuery.Evaluator<Name>(){

        @Override
        public boolean satisfiesConstraint(Name nodeValue, Name constraintValue) {
            return ValueComparators.NAME_COMPARATOR.compare(nodeValue, constraintValue) >= 0;
        }

        public String toString() {
            return " >= ";
        }
    };

    public static Query createQueryForNodesWithNameEqualTo(Name constraintValue, String fieldName, ValueFactories factories, CaseOperations.CaseOperation caseOperation) {
        return new CompareNameQuery(fieldName, constraintValue, (ValueFactory<Name>)factories.getNameFactory(), (ValueFactory<String>)factories.getStringFactory(), EQUAL_TO, caseOperation);
    }

    public static CompareNameQuery createQueryForNodesWithNameGreaterThan(Name constraintValue, String localNameField, ValueFactories factories, CaseOperations.CaseOperation caseOperation) {
        return new CompareNameQuery(localNameField, constraintValue, (ValueFactory<Name>)factories.getNameFactory(), (ValueFactory<String>)factories.getStringFactory(), IS_GREATER_THAN, caseOperation);
    }

    public static CompareNameQuery createQueryForNodesWithNameGreaterThanOrEqualTo(Name constraintValue, String localNameField, ValueFactories factories, CaseOperations.CaseOperation caseOperation) {
        return new CompareNameQuery(localNameField, constraintValue, (ValueFactory<Name>)factories.getNameFactory(), (ValueFactory<String>)factories.getStringFactory(), IS_GREATER_THAN_OR_EQUAL_TO, caseOperation);
    }

    public static CompareNameQuery createQueryForNodesWithNameLessThan(Name constraintValue, String localNameField, ValueFactories factories, CaseOperations.CaseOperation caseOperation) {
        return new CompareNameQuery(localNameField, constraintValue, (ValueFactory<Name>)factories.getNameFactory(), (ValueFactory<String>)factories.getStringFactory(), IS_LESS_THAN, caseOperation);
    }

    public static CompareNameQuery createQueryForNodesWithNameLessThanOrEqualTo(Name constraintValue, String localNameField, ValueFactories factories, CaseOperations.CaseOperation caseOperation) {
        return new CompareNameQuery(localNameField, constraintValue, (ValueFactory<Name>)factories.getNameFactory(), (ValueFactory<String>)factories.getStringFactory(), IS_LESS_THAN_OR_EQUAL_TO, caseOperation);
    }

    protected CompareNameQuery(String field, Name constraintValue, ValueFactory<Name> nameFactory, ValueFactory<String> stringFactory, CompareQuery.Evaluator<Name> evaluator, CaseOperations.CaseOperation caseOperation) {
        super(field, constraintValue, nameFactory, stringFactory, evaluator, caseOperation);
    }

    public Query clone() {
        return new CompareNameQuery(this.field(), (Name)this.constraintValue, (ValueFactory<Name>)this.valueTypeFactory, (ValueFactory<String>)this.stringFactory, this.evaluator, this.caseOperation);
    }
}

