/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.lucene.query;

import java.io.IOException;
import java.util.Collections;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.util.CheckArg;

@Immutable
public abstract class ConstantScoreWeightQuery
extends Query {
    private final String field;

    protected ConstantScoreWeightQuery(String field) {
        CheckArg.isNotNull((Object)field, (String)"field");
        this.field = field;
    }

    protected String field() {
        return this.field;
    }

    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new ConstantWeight(this);
    }

    protected abstract boolean areValid(IndexableField ... var1);

    protected class ConstantWeightScorer
    extends Scorer {
        private int docId;
        private final int maxDocId;
        private final LeafReader leafReader;

        public ConstantWeightScorer(LeafReaderContext readerContext, Weight weight) {
            super(weight);
            this.docId = -1;
            this.leafReader = readerContext.reader();
            assert (this.leafReader != null);
            this.maxDocId = this.leafReader.maxDoc();
        }

        public int freq() throws IOException {
            return 1;
        }

        public long cost() {
            return this.maxDocId;
        }

        public int docID() {
            return this.docId;
        }

        public int nextDoc() throws IOException {
            IndexableField[] fields;
            Document document;
            do {
                ++this.docId;
                if (this.docId != this.maxDocId) continue;
                this.docId = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            } while ((document = this.leafReader.document(this.docId, Collections.singleton(ConstantScoreWeightQuery.this.field))) == null || (fields = document.getFields(ConstantScoreWeightQuery.this.field)) == null || fields.length == 0 || !ConstantScoreWeightQuery.this.areValid(fields));
            return this.docId;
        }

        public int advance(int target) throws IOException {
            int doc;
            if (target == Integer.MAX_VALUE) {
                return target;
            }
            while ((doc = this.nextDoc()) < target) {
            }
            return doc;
        }

        public float score() {
            return 1.0f;
        }
    }

    protected class ConstantWeight
    extends ConstantScoreWeight {
        private ConstantWeight(Query query) {
            super(query);
        }

        public Scorer scorer(LeafReaderContext context) throws IOException {
            return new ConstantWeightScorer(context, (Weight)this);
        }
    }
}

