/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.lucene;

import java.util.UUID;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.query.Query;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.modeshape.common.FixFor;
import org.modeshape.jcr.ClusteringHelper;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.TestingUtil;
import org.modeshape.jcr.ValidateQuery;
import org.modeshape.jcr.api.Workspace;

public class LuceneRepositoryTest {
    @BeforeClass
    public static void beforeClass() throws Exception {
        ClusteringHelper.bindJGroupsToLocalAddress();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        ClusteringHelper.removeJGroupsBindings();
    }

    @Test
    public void shouldAllowAdvancedLuceneConfiguration() throws Exception {
        JcrRepository repository = TestingUtil.startRepositoryWithConfig((String)"config/repo-config-persistent-lucene-provider-advanced-settings.json");
        JcrSession defaultSession = repository.login();
        Node node = defaultSession.getRootNode().addNode("node1");
        node.addMixin("mix:title");
        node.setProperty("jcr:title", "title1");
        defaultSession.save();
        JcrSession otherSession = repository.login("other");
        node = otherSession.getRootNode().addNode("node2");
        node.addMixin("mix:title");
        node.setProperty("jcr:title", "title2");
        otherSession.save();
        Query query = defaultSession.getWorkspace().getQueryManager().createQuery("select node.[jcr:path] from [mix:title] as node where node.[jcr:title] LIKE 'title%'", "JCR-SQL2");
        ValidateQuery.validateQuery().hasNodesAtPaths(new String[]{"/node1"}).useIndex("titleIndex").validate(query, query.execute());
        query = otherSession.getWorkspace().getQueryManager().createQuery("select node.[jcr:path] from [mix:title] as node where node.[jcr:title] LIKE 'title%'", "JCR-SQL2");
        ValidateQuery.validateQuery().hasNodesAtPaths(new String[]{"/node2"}).useIndex("titleIndex").validate(query, query.execute());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @FixFor(value={"MODE-1903"})
    public void shouldReindexContentInClusterIncrementally() throws Exception {
        TestingUtil.waitUntilFolderCleanedUp((String)"target/clustered");
        JcrRepository repository1 = null;
        JcrRepository repository2 = null;
        try {
            String clusterNode1 = UUID.randomUUID().toString();
            repository1 = TestingUtil.startClusteredRepositoryWithConfig((String)"config/repo-config-clustered-incremental-indexes.json", (String)clusterNode1);
            String clusterNode2 = UUID.randomUUID().toString();
            repository2 = TestingUtil.startClusteredRepositoryWithConfig((String)"config/repo-config-clustered-incremental-indexes.json", (String)clusterNode2);
            JcrSession session1 = repository1.login();
            Node node = session1.getRootNode().addNode("repo1_node1");
            node.addMixin("mix:title");
            node.setProperty("jcr:title", "title1");
            session1.save();
            Thread.sleep(300L);
            TestingUtil.killRepository((JcrRepository)repository2);
            node = session1.getRootNode().addNode("repo1_node2");
            node.addMixin("mix:title");
            node.setProperty("jcr:title", "title2");
            session1.save();
            repository2 = TestingUtil.startClusteredRepositoryWithConfig((String)"config/repo-config-clustered-incremental-indexes.json", (String)clusterNode2);
            JcrSession session2 = repository2.login();
            Workspace workspace2 = (Workspace)session2.getWorkspace();
            org.modeshape.jcr.api.query.Query query = workspace2.getQueryManager().createQuery("select node.[jcr:path] from [mix:title] as node where node.[jcr:title] = 'title2'", "JCR-SQL2");
            ValidateQuery.validateQuery().hasNodesAtPaths(new String[]{"/repo1_node2"}).useIndex("titleIndex").validate((Query)query, query.execute());
            TestingUtil.killRepository((JcrRepository)repository2);
            Thread.sleep(100L);
            session1.getNode("/repo1_node2").remove();
            session1.getNode("/repo1_node1").setProperty("jcr:title", "title1_edited");
            session1.save();
            repository2 = TestingUtil.startClusteredRepositoryWithConfig((String)"config/repo-config-clustered-incremental-indexes.json", (String)clusterNode2);
            session2 = repository2.login();
            workspace2 = (Workspace)session2.getWorkspace();
            query = workspace2.getQueryManager().createQuery("select node.[jcr:path] from [mix:title] as node where node.[jcr:title] = 'title2'", "JCR-SQL2");
            ValidateQuery.validateQuery().rowCount(0).useIndex("titleIndex").validate((Query)query, query.execute());
            query = workspace2.getQueryManager().createQuery("select node.[jcr:path] from [mix:title] as node where node.[jcr:title] = 'title1'", "JCR-SQL2");
            ValidateQuery.validateQuery().rowCount(0).useIndex("titleIndex").validate((Query)query, query.execute());
            query = workspace2.getQueryManager().createQuery("select node.[jcr:path] from [mix:title] as node where node.[jcr:title] = 'title1_edited'", "JCR-SQL2");
            ValidateQuery.validateQuery().hasNodesAtPaths(new String[]{"/repo1_node1"}).useIndex("titleIndex").validate((Query)query, query.execute());
        }
        catch (Throwable throwable) {
            TestingUtil.killRepositories((Repository[])new Repository[]{repository1, repository2});
            throw throwable;
        }
        TestingUtil.killRepositories((Repository[])new Repository[]{repository1, repository2});
    }
}

