/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.lucene;

import java.util.UUID;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.jcr.index.lucene.LuceneIndex;
import org.modeshape.jcr.index.lucene.MultiColumnIndex;
import org.modeshape.jcr.index.lucene.PropertiesTestUtil;
import org.modeshape.jcr.index.lucene.SingleColumnIndexPersistenceTest;
import org.modeshape.jcr.value.PropertyType;

public class MultiColumnIndexPersistenceTest
extends SingleColumnIndexPersistenceTest {
    @Override
    protected LuceneIndex createIndex(String name) {
        return new MultiColumnIndex(name + "-multi-valued", "default", this.config, PropertiesTestUtil.ALLOWED_PROPERTIES, this.context);
    }

    @Test
    public void shouldUpdateMultipleValuesForSameNodeWithIndividualCommits() throws Exception {
        String nodeKey = UUID.randomUUID().toString();
        this.addMultiplePropertiesToSameNode(this.index, nodeKey, 2, PropertyType.LONG);
        this.index.commit();
        this.addMultiplePropertiesToSameNode(this.index, nodeKey, 1, PropertyType.DECIMAL);
        this.index.commit();
        this.addMultiplePropertiesToSameNode(this.index, nodeKey, 1, PropertyType.STRING);
        this.index.commit();
        this.addMultiplePropertiesToSameNode(this.index, nodeKey, 1, PropertyType.STRING);
        this.index.commit();
        this.addMultiplePropertiesToSameNode(this.index, nodeKey, 1, PropertyType.URI);
        this.index.commit();
        Assert.assertEquals((long)1L, (long)this.index.estimateTotalCount());
    }

    @Test
    public void shouldUpdateMultipleValuesForSameNodeWithBatchCommit() throws Exception {
        String nodeKey = UUID.randomUUID().toString();
        this.addMultiplePropertiesToSameNode(this.index, nodeKey, 2, PropertyType.LONG);
        this.addMultiplePropertiesToSameNode(this.index, nodeKey, 1, PropertyType.DECIMAL);
        this.addMultiplePropertiesToSameNode(this.index, nodeKey, 1, PropertyType.STRING);
        this.addMultiplePropertiesToSameNode(this.index, nodeKey, 1, PropertyType.STRING);
        this.addMultiplePropertiesToSameNode(this.index, nodeKey, 1, PropertyType.URI);
        this.index.commit();
        Assert.assertEquals((long)1L, (long)this.index.estimateTotalCount());
    }

    @Override
    @Test
    public void shouldRemoveAllValues() throws Exception {
        String nodeKey = UUID.randomUUID().toString();
        this.addMultiplePropertiesToSameNode(this.index, nodeKey, 2, PropertyType.LONG);
        this.addMultiplePropertiesToSameNode(this.index, nodeKey, 1, PropertyType.STRING);
        this.index.commit();
        this.index.remove(nodeKey);
        this.index.commit();
        Assert.assertEquals((long)0L, (long)this.index.estimateTotalCount());
    }

    @Override
    @Test
    public void shouldRemoveSingleValue() throws Exception {
        String nodeKey = UUID.randomUUID().toString();
        this.addMultiplePropertiesToSameNode(this.index, nodeKey, 2, PropertyType.LONG);
        String stringProperty = this.addMultiplePropertiesToSameNode(this.index, nodeKey, 1, PropertyType.STRING);
        this.index.commit();
        this.index.remove(nodeKey, stringProperty);
        this.index.commit();
        Assert.assertEquals((long)1L, (long)this.index.estimateTotalCount());
    }
}

