/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.lucene;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.Test;
import org.modeshape.jcr.index.lucene.AbstractLuceneIndexSearchTest;
import org.modeshape.jcr.index.lucene.LuceneIndex;
import org.modeshape.jcr.index.lucene.TextIndex;
import org.modeshape.jcr.query.model.Constraint;
import org.modeshape.jcr.value.PropertyType;

public class TextIndexSearchTest
extends AbstractLuceneIndexSearchTest {
    private static final Map<String, PropertyType> ALLOWED_PROPERTIES = new HashMap<String, PropertyType>(){
        {
            this.put("prop:string", PropertyType.STRING);
        }
    };

    @Override
    protected LuceneIndex createIndex(String name) {
        return new TextIndex(name + "-text", "default", this.config, ALLOWED_PROPERTIES, this.context);
    }

    @Test
    public void shouldSupportFTSWithSimpleExpressions() throws Exception {
        List<String> nodeKeys = this.indexNodes("prop:string", "the quick", "brown fox", "green fox");
        Constraint fts = this.fullTextSearch("prop:string", "quick");
        this.validateCardinality(fts, 1L);
        this.validateFilterResults(fts, 1, true, nodeKeys.get(0));
        fts = this.fullTextSearch("prop:string", "fox");
        this.validateCardinality(fts, 2L);
        this.validateFilterResults(fts, 1, true, nodeKeys.get(1), nodeKeys.get(2));
        fts = this.fullTextSearch("prop:string", "-fox");
        this.validateCardinality(fts, 1L);
        this.validateFilterResults(fts, 1, true, nodeKeys.get(0));
        fts = this.fullTextSearch("prop:string", "fo*");
        this.validateCardinality(fts, 2L);
        this.validateFilterResults(fts, 1, false, nodeKeys.get(1), nodeKeys.get(2));
    }

    @Test
    public void shouldSupportFTSWithSimpleExpressionsAndNoPropertyName() throws Exception {
        List<String> nodeKeys = this.indexNodes("prop:string", "the quick", "brown fox", "green fox");
        Constraint fts = this.fullTextSearch(null, "quick");
        this.validateCardinality(fts, 1L);
        this.validateFilterResults(fts, 1, true, nodeKeys.get(0));
    }

    @Test
    public void shouldSupportFTSWithConjunctions() throws Exception {
        List<String> nodeKeys = this.indexNodes("prop:string", "the quick brown fox", "jumps over");
        Constraint fts = this.fullTextSearch("prop:string", "quick brown");
        this.validateCardinality(fts, 1L);
        this.validateFilterResults(fts, 1, true, nodeKeys.get(0));
        fts = this.fullTextSearch("prop:string", "jumps o*");
        this.validateCardinality(fts, 1L);
        this.validateFilterResults(fts, 1, false, nodeKeys.get(1));
        fts = this.fullTextSearch("prop:string", "-jumps brown");
        this.validateCardinality(fts, 1L);
        this.validateFilterResults(fts, 1, true, nodeKeys.get(0));
        fts = this.fullTextSearch("prop:string", "-jumps -brown");
        this.validateCardinality(fts, 0L);
    }

    @Test
    public void shouldSupportFTSWithDisjunctions() throws Exception {
        List<String> nodeKeys = this.indexNodes("prop:string", "the quick brown fox", "jumps over");
        Constraint fts = this.fullTextSearch("prop:string", "quick OR over");
        this.validateCardinality(fts, 2L);
        this.validateFilterResults(fts, 1, true, nodeKeys.toArray(new String[nodeKeys.size()]));
        fts = this.fullTextSearch("prop:string", "jumps OR o*");
        this.validateCardinality(fts, 1L);
        this.validateFilterResults(fts, 1, false, nodeKeys.get(1));
        fts = this.fullTextSearch("prop:string", "-jumps OR brown");
        this.validateCardinality(fts, 1L);
        this.validateFilterResults(fts, 1, true, nodeKeys.get(0));
        fts = this.fullTextSearch("prop:string", "-jumps OR -brown");
        this.validateCardinality(fts, 2L);
        this.validateFilterResults(fts, 2, true, nodeKeys.toArray(new String[nodeKeys.size()]));
    }

    @Test
    public void shouldSupportFTSWithDisjunctionsAndConjunctions() throws Exception {
        List<String> nodeKeys = this.indexNodes("prop:string", "the quick brown fox", "jumps over");
        Constraint fts = this.fullTextSearch("prop:string", "-quick OR -over jumps");
        this.validateCardinality(fts, 0L);
        fts = this.fullTextSearch("prop:string", "quick OR -fox jumps");
        this.validateCardinality(fts, 2L);
        this.validateFilterResults(fts, 1, true, nodeKeys.toArray(new String[nodeKeys.size()]));
    }
}

