/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.lucene;

import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import org.junit.BeforeClass;
import org.junit.Test;
import org.modeshape.common.util.FileUtil;
import org.modeshape.jcr.JcrQueryManagerTest;

public class LuceneIndexProviderQueryTest
extends JcrQueryManagerTest {
    @BeforeClass
    public static void beforeAll() throws Exception {
        FileUtil.delete((String)"target/LuceneIndexProviderQueryTest");
        String configFileName = LuceneIndexProviderQueryTest.class.getSimpleName() + ".json";
        JcrQueryManagerTest.beforeAll((String)configFileName);
    }

    @Test
    public void shouldBeAbleToExecuteXPathQueryWithCompoundCriteria() throws Exception {
        String xpath = "/jcr:root/Cars//element(*,car:Car)[@car:year='2008' and jcr:contains(@car:engine, '\"liters V 12\"')]";
        org.modeshape.jcr.api.query.Query query = LuceneIndexProviderQueryTest.getSession().getWorkspace().getQueryManager().createQuery(xpath, "xpath");
        QueryResult result = query.execute();
        String[] columnNames = new String[]{"jcr:primaryType", "jcr:mixinTypes", "jcr:path", "jcr:score", "jcr:created", "jcr:createdBy", "jcr:name", "mode:localName", "mode:depth", "mode:id", "car:mpgCity", "car:userRating", "car:mpgHighway", "car:engine", "car:model", "car:year", "car:maker", "car:lengthInInches", "car:valueRating", "car:wheelbaseInInches", "car:msrp", "car:alternateModels"};
        this.validateQuery().rowCount(1).hasColumns(columnNames).validate((Query)query, result);
        xpath = "/jcr:root/Cars//element(*,car:Car)[@car:year='2007' and jcr:contains(@car:engine, '\"liter V 12\"')]";
        query = LuceneIndexProviderQueryTest.getSession().getWorkspace().getQueryManager().createQuery(xpath, "xpath");
        result = query.execute();
        this.validateQuery().rowCount(0).hasColumns(columnNames).validate((Query)query, result);
    }
}

