/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.index.lucene;

import java.io.InputStream;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.query.Query;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.modeshape.common.FixFor;
import org.modeshape.common.util.FileUtil;
import org.modeshape.jcr.ClusteringHelper;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.TestingUtil;
import org.modeshape.jcr.ValidateQuery;
import org.modeshape.jcr.api.Session;
import org.modeshape.jcr.api.Workspace;

public class LuceneRepositoryTest {
    private org.modeshape.jcr.api.Repository repository;

    @BeforeClass
    public static void beforeClass() throws Exception {
        ClusteringHelper.bindJGroupsToLocalAddress();
    }

    @AfterClass
    public static void afterClass() throws Exception {
        ClusteringHelper.removeJGroupsBindings();
    }

    @After
    public void after() {
        if (this.repository != null) {
            TestingUtil.killRepositories((Repository[])new Repository[]{this.repository});
        }
    }

    @Test
    public void shouldAllowAdvancedLuceneConfiguration() throws Exception {
        this.repository = TestingUtil.startRepositoryWithConfig((String)"config/repo-config-persistent-lucene-provider-advanced-settings.json");
        Session defaultSession = this.repository.login();
        Node node = defaultSession.getRootNode().addNode("node1");
        node.addMixin("mix:title");
        node.setProperty("jcr:title", "title1");
        defaultSession.save();
        Session otherSession = this.repository.login("other");
        node = otherSession.getRootNode().addNode("node2");
        node.addMixin("mix:title");
        node.setProperty("jcr:title", "title2");
        otherSession.save();
        Query query = defaultSession.getWorkspace().getQueryManager().createQuery("select node.[jcr:path] from [mix:title] as node where node.[jcr:title] LIKE 'title%'", "JCR-SQL2");
        ValidateQuery.validateQuery().hasNodesAtPaths(new String[]{"/node1"}).useIndex("titleIndex").validate(query, query.execute());
        query = otherSession.getWorkspace().getQueryManager().createQuery("select node.[jcr:path] from [mix:title] as node where node.[jcr:title] LIKE 'title%'", "JCR-SQL2");
        ValidateQuery.validateQuery().hasNodesAtPaths(new String[]{"/node2"}).useIndex("titleIndex").validate(query, query.execute());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @FixFor(value={"MODE-1903"})
    public void shouldReindexContentInClusterIncrementally() throws Exception {
        TestingUtil.waitUntilFolderCleanedUp((String)"target/clustered");
        JcrRepository repository1 = null;
        JcrRepository repository2 = null;
        try {
            String clusterNode1 = UUID.randomUUID().toString();
            repository1 = TestingUtil.startClusteredRepositoryWithConfig((String)"config/repo-config-clustered-incremental-indexes.json", (String)clusterNode1);
            String clusterNode2 = UUID.randomUUID().toString();
            repository2 = TestingUtil.startClusteredRepositoryWithConfig((String)"config/repo-config-clustered-incremental-indexes.json", (String)clusterNode2);
            JcrSession session1 = repository1.login();
            Node node = session1.getRootNode().addNode("repo1_node1");
            node.addMixin("mix:title");
            node.setProperty("jcr:title", "title1");
            session1.save();
            Thread.sleep(300L);
            TestingUtil.killRepository((JcrRepository)repository2);
            node = session1.getRootNode().addNode("repo1_node2");
            node.addMixin("mix:title");
            node.setProperty("jcr:title", "title2");
            session1.save();
            repository2 = TestingUtil.startClusteredRepositoryWithConfig((String)"config/repo-config-clustered-incremental-indexes.json", (String)clusterNode2);
            JcrSession session2 = repository2.login();
            Workspace workspace2 = (Workspace)session2.getWorkspace();
            org.modeshape.jcr.api.query.Query query = workspace2.getQueryManager().createQuery("select node.[jcr:path] from [mix:title] as node where node.[jcr:title] = 'title2'", "JCR-SQL2");
            ValidateQuery.validateQuery().hasNodesAtPaths(new String[]{"/repo1_node2"}).useIndex("titleIndex").validate((Query)query, query.execute());
            TestingUtil.killRepository((JcrRepository)repository2);
            Thread.sleep(100L);
            session1.getNode("/repo1_node2").remove();
            session1.getNode("/repo1_node1").setProperty("jcr:title", "title1_edited");
            session1.save();
            repository2 = TestingUtil.startClusteredRepositoryWithConfig((String)"config/repo-config-clustered-incremental-indexes.json", (String)clusterNode2);
            session2 = repository2.login();
            workspace2 = (Workspace)session2.getWorkspace();
            query = workspace2.getQueryManager().createQuery("select node.[jcr:path] from [mix:title] as node where node.[jcr:title] = 'title2'", "JCR-SQL2");
            ValidateQuery.validateQuery().rowCount(0).useIndex("titleIndex").validate((Query)query, query.execute());
            query = workspace2.getQueryManager().createQuery("select node.[jcr:path] from [mix:title] as node where node.[jcr:title] = 'title1'", "JCR-SQL2");
            ValidateQuery.validateQuery().rowCount(0).useIndex("titleIndex").validate((Query)query, query.execute());
            query = workspace2.getQueryManager().createQuery("select node.[jcr:path] from [mix:title] as node where node.[jcr:title] = 'title1_edited'", "JCR-SQL2");
            ValidateQuery.validateQuery().hasNodesAtPaths(new String[]{"/repo1_node1"}).useIndex("titleIndex").validate((Query)query, query.execute());
        }
        catch (Throwable throwable) {
            TestingUtil.killRepositories((Repository[])new Repository[]{repository1, repository2});
            throw throwable;
        }
        TestingUtil.killRepositories((Repository[])new Repository[]{repository1, repository2});
    }

    @Test
    @FixFor(value={"MODE-2586"})
    public void shouldReadIndexesFromLucene53() throws Exception {
        FileUtil.unzip((InputStream)LuceneRepositoryTest.class.getClassLoader().getResourceAsStream("lucene53_indexes.zip"), (String)"target/indexes");
        FileUtil.unzip((InputStream)LuceneRepositoryTest.class.getClassLoader().getResourceAsStream("lucene53_repo.zip"), (String)"target/repo");
        this.repository = TestingUtil.startRepositoryWithConfig((String)"config/repo-config-backward-compatibility-indexes.json");
        Session session = this.repository.login();
        Node node1 = session.getNode("/node1");
        Assert.assertTrue((boolean)node1.isNodeType("mix:title"));
        Assert.assertEquals((Object)"title1", (Object)node1.getProperty("jcr:title").getString());
        Node node2 = session.getNode("/node2");
        Assert.assertTrue((boolean)node2.isNodeType("mix:title"));
        Assert.assertEquals((Object)"title2", (Object)node2.getProperty("jcr:title").getString());
        Query query = session.getWorkspace().getQueryManager().createQuery("select node.[jcr:path] from [mix:title] as node where node.[jcr:title] LIKE 'title%'", "JCR-SQL2");
        ValidateQuery.validateQuery().hasNodesAtPaths(new String[]{"/node1", "/node2"}).useIndex("titleIndex").validate(query, query.execute());
    }

    @Test
    @Ignore(value=" perf test")
    @FixFor(value={"MODE-2585"})
    public void shouldQueryLargeNumberOfNodes() throws Exception {
        Assert.assertTrue((boolean)FileUtil.delete((String)"target/repo"));
        Assert.assertTrue((boolean)FileUtil.delete((String)"target/indexes"));
        this.repository = TestingUtil.startRepositoryWithConfig((String)"config/repo-config-backward-compatibility-indexes.json");
        Session session = this.repository.login();
        int nodeCount = 10003;
        int batchSize = 1000;
        IntStream.range(0, nodeCount).forEach(arg_0 -> LuceneRepositoryTest.lambda$shouldQueryLargeNumberOfNodes$0((javax.jcr.Session)session, batchSize, arg_0));
        if (session.hasPendingChanges()) {
            System.out.printf("inserting last batch ", new Object[0]);
            session.save();
        }
        Query query = session.getWorkspace().getQueryManager().createQuery("select node.[jcr:path] from [mix:title] as node where node.[jcr:title] LIKE 'title%' ORDER BY [jcr:created] ASC LIMIT 3 OFFSET 1000", "JCR-SQL2");
        long start = System.nanoTime();
        ValidateQuery.validateQuery().rowCount(3).printDetail().useIndex("titleIndex").hasNodesAtPaths(new String[]{"/node1001", "/node1002", "/node1003"}).validate(query, query.execute());
        System.out.println("Time to run query with limit and offset: " + (double)TimeUnit.MILLISECONDS.convert(System.nanoTime() - start, TimeUnit.NANOSECONDS) / 1000.0 + " seconds");
    }

    private static /* synthetic */ void lambda$shouldQueryLargeNumberOfNodes$0(javax.jcr.Session session, int batchSize, int i) {
        int idx = i + 1;
        try {
            Node node = session.getRootNode().addNode("node" + idx);
            node.addMixin("mix:title");
            node.addMixin("mix:created");
            node.setProperty("jcr:title", "title" + idx);
            if (i > 0 && i % batchSize == 0) {
                System.out.println("inserting batch [" + (i - batchSize) + "," + i + "]");
                session.save();
            }
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }
}

